/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.fileformat;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;

public class GedcomxFileEntry {
    private final JarEntry jarEntry;

    public GedcomxFileEntry(JarEntry jarEntry) {
        if (jarEntry == null) {
            throw new NullPointerException("jarEntry");
        }
        this.jarEntry = jarEntry;
    }

    public JarEntry getJarEntry() {
        return this.jarEntry;
    }

    public String getContentType() throws IOException {
        Attributes attributes = this.jarEntry.getAttributes();
        return attributes != null ? attributes.getValue(Attributes.Name.CONTENT_TYPE) : null;
    }

    public String getAttribute(String name) throws IOException {
        Attributes attributes = this.jarEntry.getAttributes();
        return attributes != null ? attributes.getValue(name) : null;
    }

    public Map<String, String> getAttributes() throws IOException {
        HashMap<String, String> attributesMap = new HashMap<String, String>();
        Attributes attributes = this.jarEntry.getAttributes();
        if (attributes != null) {
            for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
                String key = entry.getKey().toString();
                String value = (String)entry.getValue();
                attributesMap.put(key, value);
            }
        }
        return attributesMap;
    }
}

