/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.fileformat;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.gedcomx.Gedcomx;
import org.gedcomx.fileformat.DefaultXMLSerialization;
import org.gedcomx.fileformat.GedcomxEntrySerializer;
import org.gedcomx.fileformat.GedcomxTimeStampUtil;

public class GedcomxOutputStream {
    private final GedcomxEntrySerializer serializer;
    private final JarOutputStream gedxOutputStream;
    private final Manifest mf;
    private int entryCount = 0;

    public GedcomxOutputStream(OutputStream gedxOutputStream, GedcomxEntrySerializer serializer) throws IOException {
        this.serializer = serializer;
        this.gedxOutputStream = new JarOutputStream(gedxOutputStream);
        this.mf = new Manifest();
        this.mf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
    }

    public GedcomxOutputStream(OutputStream gedxOutputStream, Class<?> ... classes) throws IOException {
        this(gedxOutputStream, new DefaultXMLSerialization(classes));
    }

    public void addAttribute(String name, String value) {
        this.mf.getMainAttributes().putValue(name, value);
    }

    public void addResource(Gedcomx resource) throws IOException {
        this.addResource(resource, new Date());
    }

    public void addResource(Gedcomx resource, Date lastModified) throws IOException {
        StringBuilder entryName = new StringBuilder("tree");
        if (this.entryCount > 0) {
            entryName.append(this.entryCount);
        }
        entryName.append(".xml");
        this.addResource(entryName.toString(), resource, lastModified);
    }

    public void addResource(String entryName, Gedcomx resource, Date lastModified) throws IOException {
        this.addResource("application/x-gedcomx-v1+xml", entryName, resource, lastModified, null);
    }

    public void addResource(String contentType, String entryName, Object resource, Date lastModified) throws IOException {
        this.addResource(contentType, entryName, resource, lastModified, null);
    }

    public void addResource(String contentType, String entryName, Object resource, Date lastModified, Map<String, String> attributes) throws IOException {
        this.putNextEntry(contentType, entryName, lastModified, attributes);
        this.serializer.serialize(resource, this.gedxOutputStream);
        ++this.entryCount;
    }

    public void addResource(String contentType, String entryName, InputStream resource, Date lastModified, Map<String, String> attributes) throws IOException {
        this.putNextEntry(contentType, entryName, lastModified, attributes);
        byte[] buffer = new byte[1024];
        int len = resource.read(buffer);
        while (len >= 0) {
            this.gedxOutputStream.write(buffer, 0, len);
            len = resource.read(buffer);
        }
        ++this.entryCount;
    }

    protected void putNextEntry(String contentType, String entryName, Date lastModified, Map<String, String> attributes) throws IOException {
        if (contentType.trim().length() == 0) {
            throw new IllegalArgumentException("contentType must not be null or empty.");
        }
        entryName = (entryName = entryName.replaceAll("\\\\", "/")).charAt(0) == '/' ? entryName.substring(1) : entryName;
        JarEntry gedxEntry = new JarEntry(entryName);
        Attributes entryAttrs = new Attributes();
        if (lastModified != null) {
            entryAttrs.putValue("X-DC-modified", GedcomxTimeStampUtil.formatAsXmlUTC(lastModified));
        }
        if (!this.isKnownContentType(contentType)) {
            entryAttrs.put(Attributes.Name.CONTENT_TYPE, contentType);
        }
        if (attributes != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                entryAttrs.putValue(entry.getKey(), entry.getValue());
            }
        }
        if (!entryAttrs.isEmpty()) {
            this.mf.getEntries().put(entryName, entryAttrs);
        }
        this.gedxOutputStream.putNextEntry(gedxEntry);
    }

    protected boolean isKnownContentType(String contentType) {
        return this.serializer.isKnownContentType(contentType);
    }

    public void close() throws IOException {
        this.gedxOutputStream.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
        this.mf.write(this.gedxOutputStream);
        this.gedxOutputStream.close();
    }
}

