/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.fileformat;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;

public class GedcomxTimeStampUtil {
    private static final DatatypeFactory DATATYPE_FACTORY;
    private static final TimeZone UTC_TIME_ZONE;

    public static String formatAsXmlUTC(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        gc.setTimeZone(UTC_TIME_ZONE);
        return DATATYPE_FACTORY.newXMLGregorianCalendar(gc).toXMLFormat();
    }

    private GedcomxTimeStampUtil() {
    }

    static {
        try {
            DATATYPE_FACTORY = DatatypeFactory.newInstance();
            UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

