/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.fileformat;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;
import org.gedcomx.fileformat.GedcomxEntryDeserializer;
import org.gedcomx.fileformat.GedcomxEntrySerializer;
import org.gedcomx.rt.json.GedcomJacksonModule;

public class JacksonJsonSerialization
implements GedcomxEntrySerializer,
GedcomxEntryDeserializer {
    private final ObjectMapper mapper;
    private final JsonFactory factory;
    private Set<String> knownContentTypes = new HashSet<String>(Arrays.asList("application/x-gedcomx-v1+json"));

    public JacksonJsonSerialization(Class<?> ... classes) {
        this(true, classes);
    }

    public JacksonJsonSerialization(boolean pretty, Class<?> ... classes) {
        this(JacksonJsonSerialization.createObjectMapper(pretty, classes));
    }

    public JacksonJsonSerialization(ObjectMapper mapper) {
        this(mapper, new JsonFactory());
    }

    public JacksonJsonSerialization(JsonFactory factory) {
        this(JacksonJsonSerialization.createObjectMapper(true, new Class[0]), factory);
    }

    public JacksonJsonSerialization(ObjectMapper mapper, JsonFactory factory) {
        this.mapper = mapper;
        this.factory = factory;
    }

    public static ObjectMapper createObjectMapper(boolean pretty, Class<?> ... classes) {
        return GedcomJacksonModule.createObjectMapper(classes);
    }

    @Override
    public Object deserialize(InputStream in) throws IOException {
        return this.mapper.readValue(this.factory.createJsonParser(in), (JavaType)null);
    }

    @Override
    public void serialize(Object resource, OutputStream out) throws IOException {
        JsonGenerator generator = this.factory.createJsonGenerator(out);
        this.mapper.writeValue(generator, resource);
    }

    @Override
    public boolean isKnownContentType(String contentType) {
        return this.knownContentTypes.contains(contentType);
    }

    public Set<String> getKnownContentTypes() {
        return this.knownContentTypes;
    }

    public void setKnownContentTypes(Set<String> knownContentTypes) {
        this.knownContentTypes = knownContentTypes;
    }
}

