/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.records;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.json.JsonName;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gedcomx.common.Attributable;
import org.gedcomx.common.Attribution;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.Identifier;
import org.gedcomx.links.HypermediaEnabledData;
import org.gedcomx.links.Link;
import org.gedcomx.records.CollectionContent;
import org.gedcomx.rt.GedcomxModelVisitor;
import org.gedcomx.rt.json.JsonElementWrapper;

@XmlRootElement
@JsonElementWrapper(name="collections")
@XmlType(name="Collection", propOrder={"identifiers", "title", "size", "content", "attribution"})
@Facet(name="http://record.gedcomx.org/")
public class Collection
extends HypermediaEnabledData
implements Attributable {
    private String lang;
    private List<Identifier> identifiers;
    private List<CollectionContent> content;
    private String title;
    private Integer size;
    private Attribution attribution;

    @Override
    public Collection id(String id) {
        return (Collection)super.id(id);
    }

    @Override
    public Collection extensionElement(Object element) {
        return (Collection)super.extensionElement(element);
    }

    @Override
    public Collection link(Link link) {
        return (Collection)super.link(link);
    }

    @Override
    public Collection link(String rel, URI href) {
        return (Collection)super.link(rel, href);
    }

    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Collection lang(String lang) {
        this.setLang(lang);
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Collection title(String title) {
        this.setTitle(title);
        return this;
    }

    @XmlElement(name="identifier")
    @JsonProperty(value="identifiers")
    @JsonName(value="identifiers")
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    @JsonProperty(value="identifiers")
    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    public Collection identifier(Identifier identifier) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.add(identifier);
        return this;
    }

    public List<CollectionContent> getContent() {
        return this.content;
    }

    public void setContent(List<CollectionContent> content) {
        this.content = content;
    }

    public Collection content(CollectionContent content) {
        this.addContent(content);
        return this;
    }

    public void addContent(CollectionContent content) {
        if (content != null) {
            if (this.content == null) {
                this.content = new LinkedList<CollectionContent>();
            }
            this.content.add(content);
        }
    }

    @Override
    public Attribution getAttribution() {
        return this.attribution;
    }

    @Override
    public void setAttribution(Attribution attribution) {
        this.attribution = attribution;
    }

    public Collection attribution(Attribution attribution) {
        this.setAttribution(attribution);
        return this;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Collection size(Integer size) {
        this.setSize(size);
        return this;
    }

    public void accept(GedcomxModelVisitor visitor) {
        visitor.visitCollection(this);
    }

    public void embed(Collection collection) {
        this.lang = this.lang == null ? collection.lang : this.lang;
        this.title = this.title == null ? collection.title : this.title;
        this.size = this.size == null ? collection.size : this.size;
        this.attribution = this.attribution == null ? collection.attribution : this.attribution;
        Attribution attribution = this.attribution = this.attribution == null ? collection.attribution : this.attribution;
        if (collection.content != null) {
            this.content = this.content == null ? new ArrayList() : this.content;
            this.content.addAll(collection.content);
        }
        super.embed(collection);
    }
}

