/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rt;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import javax.ws.rs.core.MediaType;
import org.apache.commons.codec.binary.Base64;

public class DataURIUtil {
    private DataURIUtil() {
    }

    public static String getValueAsString(URI uri) {
        if ("data".equals(uri.getScheme())) {
            String ssp;
            try {
                ssp = URLDecoder.decode(uri.getRawSchemeSpecificPart(), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
            int commaIndex = ssp.indexOf(44);
            if (commaIndex >= 0) {
                String meta = ssp.substring(0, commaIndex);
                try {
                    MediaType mediaType;
                    boolean base64 = meta.endsWith(";base64");
                    if (base64) {
                        meta = meta.substring(0, meta.indexOf(";base64"));
                    }
                    MediaType mediaType2 = mediaType = meta.trim().length() > 0 ? MediaType.valueOf(meta) : MediaType.TEXT_PLAIN_TYPE;
                    if (MediaType.TEXT_PLAIN_TYPE.isCompatible(mediaType)) {
                        String value = ssp.substring(commaIndex + 1);
                        if (base64) {
                            byte[] decoded = Base64.decodeBase64(value);
                            String charset = mediaType.getParameters().get("charset");
                            if (charset == null) {
                                charset = "utf-8";
                            }
                            return new String(decoded, charset);
                        }
                        return value;
                    }
                }
                catch (IllegalArgumentException e) {
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static URI encodeDataURI(String text) {
        try {
            return new URI("data", "," + text, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

