/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rt;

import java.lang.reflect.Field;
import java.net.URI;
import java.util.EnumMap;
import java.util.Map;
import org.codehaus.enunciate.qname.XmlQNameEnum;
import org.codehaus.enunciate.qname.XmlQNameEnumValue;
import org.codehaus.enunciate.qname.XmlUnknownQNameEnumValue;

public class EnumURIMap<K extends Enum<K>>
extends EnumMap<K, String> {
    private K unknownValue;
    private URI defaultNamespace;

    public EnumURIMap(Class<K> keyType) {
        this(keyType, "http://gedcomx.org/");
    }

    public EnumURIMap(Class<K> keyType, String defaultNamespace) {
        super(keyType);
        defaultNamespace = this.loadOverriddenDefaultNamespace(keyType, defaultNamespace);
        K unknownValue = this.loadOverrides(keyType, defaultNamespace);
        for (Enum constant : (Enum[])keyType.getEnumConstants()) {
            if (constant == unknownValue || this.containsKey(constant)) continue;
            this.put(constant, defaultNamespace + constant.name());
        }
        this.unknownValue = unknownValue;
        this.defaultNamespace = defaultNamespace == null ? null : URI.create(defaultNamespace);
    }

    private String loadOverriddenDefaultNamespace(Class<K> clazz, String defaultNamespace) {
        XmlQNameEnum enumInfo = clazz.getAnnotation(XmlQNameEnum.class);
        if (enumInfo == null) {
            throw new IllegalArgumentException(String.format("Class %s isn't a QName enum.", clazz.getName()));
        }
        if (enumInfo.base() != XmlQNameEnum.BaseType.URI) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is supposed to be converted from a URI (not QName).");
        }
        String namespace = enumInfo.namespace();
        if (!"##default".equals(namespace)) {
            defaultNamespace = namespace;
        }
        return defaultNamespace;
    }

    private K loadOverrides(Class<K> clazz, String defaultNamespace) {
        Field[] fields;
        Enum unknownValue = null;
        block0: for (Field field : fields = clazz.getDeclaredFields()) {
            for (Enum e : (Enum[])clazz.getEnumConstants()) {
                if (!field.isEnumConstant() || !field.getName().equals(e.name())) continue;
                if (field.getAnnotation(XmlUnknownQNameEnumValue.class) != null) {
                    if (unknownValue != null) {
                        throw new IllegalArgumentException(e.getDeclaringClass().getName() + "." + e.name() + " conflicts with " + e.getDeclaringClass().getName() + "." + unknownValue.name() + " as an unknown qname value.");
                    }
                    unknownValue = e;
                    continue block0;
                }
                XmlQNameEnumValue enumValueInfo = field.getAnnotation(XmlQNameEnumValue.class);
                String ns = defaultNamespace;
                String localPart = field.getName();
                if (enumValueInfo != null && !enumValueInfo.exclude() && !enumValueInfo.exclude()) {
                    if (!"##default".equals(enumValueInfo.namespace())) {
                        ns = enumValueInfo.namespace();
                    }
                    if (!"##default".equals(enumValueInfo.localPart())) {
                        localPart = enumValueInfo.localPart();
                    }
                }
                this.put(e, ns + localPart);
                continue block0;
            }
        }
        return (K)unknownValue;
    }

    public K fromURIValue(org.gedcomx.common.URI uri) {
        String token = uri.toString();
        for (Map.Entry entry : this.entrySet()) {
            if (!token.equals(entry.getValue())) continue;
            return (K)((Enum)entry.getKey());
        }
        if (this.defaultNamespace != null) {
            try {
                String resolved = this.defaultNamespace.resolve(token).toString();
                for (Map.Entry entry : this.entrySet()) {
                    if (!resolved.equals(entry.getValue())) continue;
                    return (K)((Enum)entry.getKey());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.unknownValue;
    }

    public org.gedcomx.common.URI toURIValue(K constant) {
        String value = (String)this.get(constant);
        if (value == null) {
            throw new IllegalStateException("Unable to find URI value for " + ((Enum)constant).getDeclaringClass().getName() + "." + ((Enum)constant).name() + ".");
        }
        return org.gedcomx.common.URI.create(value);
    }
}

