/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rt;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import java.beans.Introspector;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.gedcomx.rt.DefaultNamespace;
import org.gedcomx.rt.MediaTypeDefinition;
import org.gedcomx.rt.Model;
import org.gedcomx.rt.json.JsonElementWrapper;

public class GedcomNamespaceManager
extends NamespacePrefixMapper {
    private final String defaultns;
    private final Map<String, String> ns2prefix;
    private static boolean INITIALIZED = false;
    private static final Map<String, String> KNOWN_PREFIXES = new HashMap<String, String>();
    private static final Map<String, String> RUNTIME_VERSIONS = new HashMap<String, String>();
    private static final Map<String, Class<?>> WRAPPED_JSON_TYPES_BY_NAME = new HashMap();
    private static final Map<QName, String> QNAME_WRAPPER_JSON_NAMES = new HashMap<QName, String>();
    private static final Map<String, Class<?>> KNOWN_JSON_TYPES_BY_NAME = new HashMap();
    private static final Map<String, Class<?>> KNOWN_JSON_TYPES_BY_TYPE_ID = new HashMap();

    public GedcomNamespaceManager(Class<?> rootClass) {
        this(GedcomNamespaceManager.getDefaultNamespace(rootClass));
    }

    private static String getDefaultNamespace(Class<?> rootClass) {
        DefaultNamespace defaultNs = rootClass.getAnnotation(DefaultNamespace.class);
        if (defaultNs == null && rootClass.getPackage() != null) {
            defaultNs = rootClass.getPackage().getAnnotation(DefaultNamespace.class);
        }
        String defaultNamespace = "";
        if (defaultNs != null) {
            defaultNamespace = defaultNs.value();
        } else {
            XmlRootElement rootElement = rootClass.getAnnotation(XmlRootElement.class);
            if (rootElement != null) {
                if ("##default".equals(rootElement.namespace())) {
                    XmlSchema xmlSchema;
                    if (rootClass.getPackage() != null && (xmlSchema = rootClass.getPackage().getAnnotation(XmlSchema.class)) != null) {
                        defaultNamespace = xmlSchema.namespace();
                    }
                } else {
                    defaultNamespace = rootElement.namespace();
                }
            }
        }
        return defaultNamespace;
    }

    public GedcomNamespaceManager(Map<String, String> overrides, String defaultns) {
        Map<String, String> ns2prefix = GedcomNamespaceManager.getKnownPrefixes();
        if (overrides != null) {
            ns2prefix.putAll(overrides);
        }
        this.ns2prefix = Collections.unmodifiableMap(ns2prefix);
        if (defaultns == null) {
            defaultns = "";
        }
        this.defaultns = defaultns;
    }

    public GedcomNamespaceManager(String defaultns) {
        this(null, defaultns);
    }

    public GedcomNamespaceManager(Map<String, String> overrides) {
        this(overrides, null);
    }

    public GedcomNamespaceManager() {
        this(null, null);
    }

    public static Map<String, String> getKnownPrefixes() {
        GedcomNamespaceManager.init(Thread.currentThread().getContextClassLoader());
        return KNOWN_PREFIXES;
    }

    protected static synchronized void init(ClassLoader loader) {
        if (INITIALIZED) {
            return;
        }
        HashMap<String, String> namespacePrefixes = new HashMap<String, String>();
        namespacePrefixes.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        namespacePrefixes.put("http://gedcomx.org/record/v1/", "gxr");
        namespacePrefixes.put("http://gedcomx.org/conclusion/v1/", "gxc");
        HashMap<QName, String> wrapperJsonNames = new HashMap<QName, String>();
        HashMap wrappedJsonTypes = new HashMap();
        HashSet modelClasses = new HashSet();
        try {
            Enumeration<URL> resources = loader.getResources("META-INF/gedcomx.models");
            while (resources.hasMoreElements()) {
                try {
                    URL uRL = resources.nextElement();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                    String classname = reader.readLine();
                    while (classname != null) {
                        modelClasses.add(Class.forName(classname, true, loader));
                        classname = reader.readLine();
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        for (Class clazz : modelClasses) {
            MediaTypeDefinition mediaTypeInfo = clazz.getAnnotation(MediaTypeDefinition.class);
            for (Model model : mediaTypeInfo.models()) {
                namespacePrefixes.put(model.namespace(), model.id());
                for (Class objectFactory : model.objectFactory()) {
                    for (Method method : objectFactory.getDeclaredMethods()) {
                        XmlElementDecl elementDecl;
                        JsonElementWrapper jsonElementWrapper = method.getAnnotation(JsonElementWrapper.class);
                        if (jsonElementWrapper == null || (elementDecl = method.getAnnotation(XmlElementDecl.class)) == null || method.getParameterTypes().length != 1) continue;
                        String ns = elementDecl.namespace();
                        if ("##default".equals(ns)) {
                            ns = objectFactory.getPackage().isAnnotationPresent(XmlSchema.class) ? objectFactory.getPackage().getAnnotation(XmlSchema.class).namespace() : "";
                        }
                        String name = elementDecl.name();
                        String jsonAttribute = jsonElementWrapper.namespace() + jsonElementWrapper.name();
                        wrapperJsonNames.put(new QName(ns, name), jsonAttribute);
                        wrappedJsonTypes.put(jsonAttribute, method.getParameterTypes()[0]);
                    }
                }
            }
        }
        KNOWN_PREFIXES.putAll(namespacePrefixes);
        QNAME_WRAPPER_JSON_NAMES.putAll(wrapperJsonNames);
        WRAPPED_JSON_TYPES_BY_NAME.putAll(wrappedJsonTypes);
        INITIALIZED = true;
    }

    public static String nameFromQName(String namespaceUri, String localPart) {
        if (namespaceUri == null) {
            namespaceUri = "";
        }
        StringBuilder nameBuilder = new StringBuilder(namespaceUri);
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceUri)) {
            nameBuilder.append('#');
        }
        nameBuilder.append(localPart);
        return nameBuilder.toString();
    }

    @Override
    public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
        String choice = this.ns2prefix.get(namespaceUri);
        if (!requirePrefix && this.defaultns.equals(namespaceUri)) {
            return "";
        }
        return choice;
    }

    public static String getJsonNameForWrapperName(QName wrapperName) {
        GedcomNamespaceManager.init(Thread.currentThread().getContextClassLoader());
        return QNAME_WRAPPER_JSON_NAMES.get(wrapperName);
    }

    public static QName findWrapperNameForJsonName(String jsonName) {
        GedcomNamespaceManager.init(Thread.currentThread().getContextClassLoader());
        for (Map.Entry<QName, String> entry : QNAME_WRAPPER_JSON_NAMES.entrySet()) {
            if (!entry.getValue().equals(jsonName)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Class<?> getWrappedTypeForJsonName(String jsonName) {
        GedcomNamespaceManager.init(Thread.currentThread().getContextClassLoader());
        return WRAPPED_JSON_TYPES_BY_NAME.get(jsonName);
    }

    public static void registerKnownJsonType(Class<?> type) {
        String jsonName = GedcomNamespaceManager.getJsonName(type);
        if (jsonName != null) {
            KNOWN_JSON_TYPES_BY_NAME.put(jsonName, type);
        }
        KNOWN_JSON_TYPES_BY_TYPE_ID.put(GedcomNamespaceManager.getTypeIdName(type), type);
    }

    public static String getJsonName(Class<?> type) {
        XmlRootElement rootElement;
        if (type.isAnnotationPresent(JsonElementWrapper.class)) {
            JsonElementWrapper ext = type.getAnnotation(JsonElementWrapper.class);
            return GedcomNamespaceManager.nameFromQName(ext.namespace(), ext.name());
        }
        if (type.isAnnotationPresent(XmlRootElement.class) && (rootElement = type.getAnnotation(XmlRootElement.class)) != null) {
            String namespaceURI;
            String localPart = rootElement.name();
            if ("##default".equals(localPart)) {
                localPart = Introspector.decapitalize(type.getSimpleName());
            }
            if ("##default".equals(namespaceURI = rootElement.namespace())) {
                Package pkg = type.getPackage();
                namespaceURI = pkg != null && pkg.isAnnotationPresent(XmlSchema.class) ? pkg.getAnnotation(XmlSchema.class).namespace() : "";
            }
            return GedcomNamespaceManager.nameFromQName(namespaceURI, localPart);
        }
        return null;
    }

    public static String getTypeIdName(Class<?> type) {
        String ns = "";
        if (type.getPackage() != null && type.getPackage().isAnnotationPresent(XmlSchema.class)) {
            ns = type.getPackage().getAnnotation(XmlSchema.class).namespace();
        }
        String name = Introspector.decapitalize(type.getSimpleName());
        if (type.isAnnotationPresent(XmlType.class)) {
            XmlType typeMeta = type.getAnnotation(XmlType.class);
            if (!"##default".equals(typeMeta.name())) {
                name = typeMeta.name();
            }
            if (!"##default".equals(typeMeta.namespace())) {
                ns = typeMeta.namespace();
            }
        }
        return ns + name;
    }

    public static Class<?> getKnownJsonType(String jsonName) {
        return KNOWN_JSON_TYPES_BY_NAME.get(jsonName);
    }

    public static Class<?> getKnownTypeById(String typeId) {
        return KNOWN_JSON_TYPES_BY_TYPE_ID.get(typeId);
    }

    public static synchronized String getRuntimeVersion(String namespace) {
        String prefix = GedcomNamespaceManager.getKnownPrefixes().get(namespace);
        String version = RUNTIME_VERSIONS.get(prefix);
        if (version == null) {
            InputStream in = GedcomNamespaceManager.class.getClassLoader().getResourceAsStream("META-INF/" + prefix + ".rt.properties");
            if (in != null) {
                Properties properties = new Properties();
                try {
                    properties.load(in);
                    version = properties.getProperty("version");
                }
                catch (IOException e) {
                    version = null;
                }
            }
            if (version == null) {
                version = "(unknown)";
            }
            RUNTIME_VERSIONS.put(prefix, version);
        }
        return version;
    }
}

