/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rt;

import org.gedcomx.Gedcomx;
import org.gedcomx.agent.Agent;
import org.gedcomx.common.EvidenceReference;
import org.gedcomx.common.ExtensibleData;
import org.gedcomx.common.Note;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.Conclusion;
import org.gedcomx.conclusion.Date;
import org.gedcomx.conclusion.Document;
import org.gedcomx.conclusion.Event;
import org.gedcomx.conclusion.EventRole;
import org.gedcomx.conclusion.Fact;
import org.gedcomx.conclusion.Gender;
import org.gedcomx.conclusion.Name;
import org.gedcomx.conclusion.NameForm;
import org.gedcomx.conclusion.NamePart;
import org.gedcomx.conclusion.Person;
import org.gedcomx.conclusion.PlaceDescription;
import org.gedcomx.conclusion.PlaceReference;
import org.gedcomx.conclusion.Relationship;
import org.gedcomx.conclusion.Subject;
import org.gedcomx.records.Collection;
import org.gedcomx.records.Field;
import org.gedcomx.records.FieldValue;
import org.gedcomx.records.RecordDescriptor;
import org.gedcomx.rt.GedcomxModelVisitorBase;
import org.gedcomx.source.SourceCitation;
import org.gedcomx.source.SourceDescription;
import org.gedcomx.source.SourceReference;

public class GedcomxLocalReferenceResolver
extends GedcomxModelVisitorBase {
    private final String resourceId;
    protected ExtensibleData resource;

    public GedcomxLocalReferenceResolver(String resourceId) {
        this.resourceId = resourceId;
    }

    public static ExtensibleData resolve(ResourceReference ref, Gedcomx document) {
        if (ref.getResource() == null) {
            return null;
        }
        return GedcomxLocalReferenceResolver.resolve(ref.getResource(), document);
    }

    public static ExtensibleData resolve(URI ref, Gedcomx document) {
        if (!ref.toString().startsWith("#")) {
            return null;
        }
        return GedcomxLocalReferenceResolver.resolve(ref.toString().substring(1), document);
    }

    public static ExtensibleData resolve(String resourceId, Gedcomx document) {
        if (resourceId == null) {
            return null;
        }
        GedcomxLocalReferenceResolver visitor = new GedcomxLocalReferenceResolver(resourceId);
        document.accept(visitor);
        return visitor.getResource();
    }

    public ExtensibleData getResource() {
        return this.resource;
    }

    protected void bindIfNeeded(ExtensibleData candidate) {
        if (this.resource == null && this.resourceId.equals(candidate.getId())) {
            this.resource = candidate;
        }
    }

    @Override
    public void visitGedcomx(Gedcomx gx) {
        this.bindIfNeeded(gx);
        super.visitGedcomx(gx);
    }

    @Override
    public void visitDocument(Document document) {
        this.bindIfNeeded(document);
        super.visitDocument(document);
    }

    @Override
    public void visitPlaceDescription(PlaceDescription place) {
        this.bindIfNeeded(place);
        super.visitPlaceDescription(place);
    }

    @Override
    public void visitEvent(Event event) {
        this.bindIfNeeded(event);
        super.visitEvent(event);
    }

    @Override
    public void visitEventRole(EventRole role) {
        this.bindIfNeeded(role);
        super.visitEventRole(role);
    }

    @Override
    public void visitAgent(Agent agent) {
        this.bindIfNeeded(agent);
        super.visitAgent(agent);
    }

    @Override
    public void visitSourceDescription(SourceDescription sourceDescription) {
        this.bindIfNeeded(sourceDescription);
        super.visitSourceDescription(sourceDescription);
    }

    @Override
    public void visitSourceCitation(SourceCitation citation) {
        this.bindIfNeeded(citation);
        super.visitSourceCitation(citation);
    }

    @Override
    public void visitCollection(Collection collection) {
        this.bindIfNeeded(collection);
        super.visitCollection(collection);
    }

    @Override
    public void visitRecordDescriptor(RecordDescriptor recordDescriptor) {
        this.bindIfNeeded(recordDescriptor);
        super.visitRecordDescriptor(recordDescriptor);
    }

    @Override
    public void visitField(Field field) {
        this.bindIfNeeded(field);
        super.visitField(field);
    }

    @Override
    public void visitFieldValue(FieldValue fieldValue) {
        this.bindIfNeeded(fieldValue);
        super.visitFieldValue(fieldValue);
    }

    @Override
    public void visitRelationship(Relationship relationship) {
        this.bindIfNeeded(relationship);
        super.visitRelationship(relationship);
    }

    @Override
    protected void visitConclusion(Conclusion conclusion) {
        this.bindIfNeeded(conclusion);
        super.visitConclusion(conclusion);
    }

    @Override
    protected void visitSubject(Subject subject) {
        this.bindIfNeeded(subject);
        super.visitSubject(subject);
    }

    @Override
    public void visitPerson(Person person) {
        this.bindIfNeeded(person);
        super.visitPerson(person);
    }

    @Override
    public void visitFact(Fact fact) {
        this.bindIfNeeded(fact);
        super.visitFact(fact);
    }

    @Override
    public void visitPlaceReference(PlaceReference place) {
        this.bindIfNeeded(place);
        super.visitPlaceReference(place);
    }

    @Override
    public void visitDate(Date date) {
        this.bindIfNeeded(date);
        super.visitDate(date);
    }

    @Override
    public void visitName(Name name) {
        this.bindIfNeeded(name);
        super.visitName(name);
    }

    @Override
    public void visitNameForm(NameForm form) {
        this.bindIfNeeded(form);
        super.visitNameForm(form);
    }

    @Override
    public void visitNamePart(NamePart part) {
        this.bindIfNeeded(part);
        super.visitNamePart(part);
    }

    @Override
    public void visitGender(Gender gender) {
        this.bindIfNeeded(gender);
        super.visitGender(gender);
    }

    @Override
    public void visitSourceReference(SourceReference sourceReference) {
        this.bindIfNeeded(sourceReference);
        super.visitSourceReference(sourceReference);
    }

    @Override
    public void visitNote(Note note) {
        this.bindIfNeeded(note);
        super.visitNote(note);
    }

    @Override
    public void visitEvidenceReference(EvidenceReference evidenceReference) {
        this.bindIfNeeded(evidenceReference);
        super.visitEvidenceReference(evidenceReference);
    }
}

