/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.node.ObjectNode;
import org.gedcomx.rt.GedcomNamespaceManager;
import org.gedcomx.rt.SerializationProcessListener;
import org.gedcomx.rt.json.GedcomJacksonModule;
import org.w3c.dom.Document;

public class SerializationUtil {
    public static <C> C processThroughXml(Object reference, SerializationProcessListener ... listeners) throws JAXBException, UnsupportedEncodingException {
        return (C)SerializationUtil.processThroughXml(reference, reference.getClass(), listeners);
    }

    public static <C> C processThroughXml(Object reference, Class<? extends C> instanceClass, SerializationProcessListener ... listeners) throws JAXBException, UnsupportedEncodingException {
        return SerializationUtil.processThroughXml(reference, instanceClass, JAXBContext.newInstance(instanceClass), listeners);
    }

    public static <C> C processThroughXml(Object reference, Class<? extends C> instanceClass, JAXBContext context, SerializationProcessListener ... listeners) throws JAXBException, UnsupportedEncodingException {
        byte[] out = SerializationUtil.toXmlStream(reference, instanceClass, context, listeners);
        JAXBElement<C> element = context.createUnmarshaller().unmarshal(new StreamSource(new ByteArrayInputStream(out)), instanceClass);
        reference = element.getValue();
        return (C)reference;
    }

    public static byte[] toXmlStream(Object reference, SerializationProcessListener ... listeners) throws JAXBException, UnsupportedEncodingException {
        return SerializationUtil.toXmlStream(reference, reference.getClass(), listeners);
    }

    public static void writeXml(Object reference, OutputStream out) throws JAXBException, UnsupportedEncodingException {
        SerializationUtil.writeXml(reference, reference.getClass(), out);
    }

    public static <C> byte[] toXmlStream(Object reference, Class<? extends C> instanceClass, SerializationProcessListener ... listeners) throws JAXBException, UnsupportedEncodingException {
        return SerializationUtil.toXmlStream(reference, instanceClass, JAXBContext.newInstance(instanceClass), listeners);
    }

    public static <C> void writeXml(Object reference, Class<? extends C> instanceClass, OutputStream out) throws JAXBException, UnsupportedEncodingException {
        SerializationUtil.writeXml(reference, instanceClass, JAXBContext.newInstance(instanceClass), out);
    }

    public static <C> byte[] toXmlStream(Object reference, Class<? extends C> instanceClass, JAXBContext context, SerializationProcessListener ... listeners) throws JAXBException, UnsupportedEncodingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SerializationUtil.writeXml(reference, instanceClass, context, out);
        if ("true".equals(System.getProperty("show.output"))) {
            System.out.println(new String(out.toByteArray(), "utf-8"));
        }
        if (listeners != null && listeners.length > 0) {
            String xml = new String(out.toByteArray(), "utf-8");
            for (SerializationProcessListener listener : listeners) {
                listener.xmlProcessed(reference, instanceClass, context, xml);
            }
        }
        return out.toByteArray();
    }

    public static <C> void writeXml(Object reference, Class<? extends C> instanceClass, JAXBContext context, OutputStream out) throws JAXBException, UnsupportedEncodingException {
        JAXBElement<Object> el;
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        JAXBElement<Object> jAXBElement = el = SerializationUtil.isRootElement(instanceClass) ? reference : null;
        if (el == null) {
            String ns = "";
            if (instanceClass.getPackage() != null && instanceClass.getPackage().getAnnotation(XmlSchema.class) != null) {
                ns = instanceClass.getPackage().getAnnotation(XmlSchema.class).namespace();
            }
            el = new JAXBElement<Object>(new QName(ns, instanceClass.getSimpleName()), instanceClass, reference);
        }
        marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", new GedcomNamespaceManager(instanceClass));
        marshaller.marshal((Object)el, out);
    }

    private static <C> boolean isRootElement(Class<? extends C> instanceClass) {
        return instanceClass.isAnnotationPresent(XmlRootElement.class) || JAXBElement.class.isAssignableFrom(instanceClass);
    }

    public static Document toXmlDom(Object reference) throws JAXBException, UnsupportedEncodingException {
        return SerializationUtil.toXmlDom(reference, reference.getClass());
    }

    public static Document toXmlDom(Object reference, Class<?> instanceClass) throws JAXBException, UnsupportedEncodingException {
        byte[] out = SerializationUtil.toXmlStream(reference, instanceClass, new SerializationProcessListener[0]);
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            return builder.parse(new ByteArrayInputStream(out));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Document toXmlDom(Object reference, Class<?> instanceClass, JAXBContext context) throws JAXBException, UnsupportedEncodingException {
        byte[] out = SerializationUtil.toXmlStream(reference, instanceClass, context, new SerializationProcessListener[0]);
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(out));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <C> C processThroughJson(Object reference, SerializationProcessListener ... listeners) throws IOException {
        return (C)SerializationUtil.processThroughJson(reference, reference.getClass(), listeners);
    }

    public static <C> C processThroughJson(Object reference, Class<? extends C> instanceClass, SerializationProcessListener ... listeners) throws IOException {
        return SerializationUtil.processThroughJson(reference, instanceClass, GedcomJacksonModule.createObjectMapper(instanceClass), listeners);
    }

    public static <C> C processThroughJson(Object reference, Class<? extends C> instanceClass, ObjectMapper mapper, SerializationProcessListener ... listeners) throws IOException {
        byte[] buffer = SerializationUtil.toJsonStream(reference, instanceClass, mapper, listeners);
        reference = mapper.readValue((InputStream)new ByteArrayInputStream(buffer), instanceClass);
        return (C)reference;
    }

    public static <C> byte[] toJsonStream(Object reference, SerializationProcessListener ... listeners) throws IOException {
        return SerializationUtil.toJsonStream(reference, reference.getClass(), listeners);
    }

    public static <C> void writeJson(Object reference, OutputStream out) throws IOException {
        SerializationUtil.writeJson(reference, reference.getClass(), out);
    }

    public static <C> byte[] toJsonStream(Object reference, Class<? extends C> instanceClass, SerializationProcessListener ... listeners) throws IOException {
        return SerializationUtil.toJsonStream(reference, instanceClass, GedcomJacksonModule.createObjectMapper(instanceClass), listeners);
    }

    public static <C> void writeJson(Object reference, Class<? extends C> instanceClass, OutputStream out) throws IOException {
        SerializationUtil.writeJson(reference, instanceClass, GedcomJacksonModule.createObjectMapper(instanceClass), out);
    }

    protected static <C> byte[] toJsonStream(Object reference, Class<? extends C> instanceClass, ObjectMapper mapper, SerializationProcessListener ... listeners) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SerializationUtil.writeJson(reference, instanceClass, mapper, out);
        if ("true".equals(System.getProperty("show.output"))) {
            System.out.println(new String(out.toByteArray(), "utf-8"));
        }
        if (listeners != null && listeners.length > 0) {
            String json = new String(out.toByteArray(), "utf-8");
            for (SerializationProcessListener listener : listeners) {
                listener.jsonProcessed(reference, instanceClass, mapper, json);
            }
        }
        return out.toByteArray();
    }

    public static <C> void writeJson(Object reference, Class<? extends C> instanceClass, ObjectMapper mapper, OutputStream out) throws IOException {
        GedcomNamespaceManager.registerKnownJsonType(instanceClass);
        mapper.getSerializationConfig().enable(SerializationConfig.Feature.INDENT_OUTPUT);
        mapper.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        mapper.writeValue(out, reference);
    }

    public static ObjectNode toJsonNode(Object reference) throws IOException {
        return SerializationUtil.toJsonNode(reference, reference.getClass());
    }

    public static ObjectNode toJsonNode(Object reference, Class<?> instanceClass) throws IOException {
        return SerializationUtil.toJsonNode(reference, instanceClass, GedcomJacksonModule.createObjectMapper(instanceClass));
    }

    public static ObjectNode toJsonNode(Object reference, Class<?> instanceClass, ObjectMapper mapper) throws IOException {
        byte[] out = SerializationUtil.toJsonStream(reference, instanceClass, mapper, new SerializationProcessListener[0]);
        return mapper.readValue((InputStream)new ByteArrayInputStream(out), ObjectNode.class);
    }
}

