/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rt.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.deser.BeanDeserializer;
import org.gedcomx.rt.GedcomNamespaceManager;
import org.gedcomx.rt.SupportsExtensionAttributes;
import org.gedcomx.rt.SupportsExtensionElements;
import org.gedcomx.rt.json.HasJsonKey;
import org.gedcomx.rt.json.KeyedListDeserializer;

public class ExtensibleObjectDeserializer
extends BeanDeserializer {
    public ExtensibleObjectDeserializer(BeanDeserializer src) {
        super(src);
    }

    @Override
    protected void handleUnknownProperty(JsonParser jp, DeserializationContext ctxt, Object beanOrClass, String propName) throws IOException, JsonProcessingException {
        if (this._ignoreAllUnknown) {
            jp.skipChildren();
            return;
        }
        if (beanOrClass instanceof SupportsExtensionElements) {
            SupportsExtensionElements target = (SupportsExtensionElements)beanOrClass;
            Class<?> type = GedcomNamespaceManager.getKnownJsonType(propName);
            if (type != null) {
                if (HasJsonKey.class.isAssignableFrom(type)) {
                    for (Object ext : this.readKeyedMapOf(type, jp, ctxt)) {
                        target.addExtensionElement(ext);
                    }
                } else {
                    for (Object ext : this.readArrayOf(type, jp, ctxt)) {
                        target.addExtensionElement(ext);
                    }
                }
                return;
            }
            QName wrapper = this.getWrapperName(propName);
            type = GedcomNamespaceManager.getWrappedTypeForJsonName(propName);
            if (type != null) {
                List<?> objects = this.readArrayOf(type, jp, ctxt);
                for (Object ext : objects) {
                    target.addExtensionElement(new JAXBElement(wrapper, type, ext));
                }
                return;
            }
        }
        if (beanOrClass instanceof SupportsExtensionAttributes && jp.getCurrentToken().isScalarValue()) {
            ((SupportsExtensionAttributes)beanOrClass).addExtensionAttribute(this.getWrapperName(propName), jp.getText());
            return;
        }
        jp.skipChildren();
    }

    private QName getWrapperName(String propName) {
        QName qname = GedcomNamespaceManager.findWrapperNameForJsonName(propName);
        if (qname == null && propName.indexOf(58) >= 0) {
            String localPart;
            String nsURI;
            ArrayList<String> knownNS = new ArrayList<String>(GedcomNamespaceManager.getKnownPrefixes().keySet());
            knownNS.add("http://www.w3.org/XML/1998/namespace#");
            for (String ns : knownNS) {
                if (!propName.startsWith(ns)) continue;
                String nsURI2 = propName.substring(0, ns.length());
                String localPart2 = propName.substring(ns.length());
                if ("".equals(localPart2)) break;
                qname = new QName(nsURI2, localPart2);
                break;
            }
            if (qname == null && propName.indexOf(35) > 0) {
                int hashIndex = propName.indexOf(35);
                nsURI = propName.substring(0, hashIndex);
                localPart = propName.substring(hashIndex + 1);
                if (!"".equals(localPart)) {
                    qname = new QName(nsURI, localPart);
                }
            }
            if (qname == null && propName.lastIndexOf(47) > 0) {
                int hashIndex = propName.lastIndexOf(47);
                nsURI = propName.substring(0, hashIndex);
                localPart = propName.substring(hashIndex + 1);
                if (!"".equals(localPart)) {
                    qname = new QName(nsURI, localPart);
                }
            }
        }
        if (qname == null) {
            qname = new QName("", propName);
        }
        return qname;
    }

    private List<?> readArrayOf(Class<?> type, JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ArrayList objects = new ArrayList();
        if (jp.getCurrentToken() == JsonToken.START_ARRAY) {
            jp.nextToken();
            while (jp.getCurrentToken() != JsonToken.END_ARRAY) {
                objects.add(jp.readValueAs(type));
                jp.nextToken();
            }
        } else {
            objects.add(jp.readValueAs(type));
        }
        return objects;
    }

    private List<?> readKeyedMapOf(Class<?> type, JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.getCurrentToken() == JsonToken.START_OBJECT) {
            return KeyedListDeserializer.deserializeGeneric(jp, ctxt, type);
        }
        throw new JsonMappingException("Unable to parse keyed map of " + type.getName() + ": expect start object, but got: " + jp.getCurrentToken().name());
    }
}

