/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rt.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.ser.BeanSerializer;
import org.gedcomx.rt.GedcomNamespaceManager;
import org.gedcomx.rt.SupportsExtensionAttributes;
import org.gedcomx.rt.SupportsExtensionElements;
import org.gedcomx.rt.json.HasJsonKey;
import org.gedcomx.rt.json.KeyedListSerializer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtensibleObjectSerializer
extends BeanSerializer {
    public ExtensibleObjectSerializer(BeanSerializer src) {
        super(src);
    }

    @Override
    protected void serializeFields(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        super.serializeFields(bean, jgen, provider);
        if (bean instanceof SupportsExtensionAttributes) {
            this.serializeExtensionAttributes((SupportsExtensionAttributes)bean, jgen, provider);
        }
        if (bean instanceof SupportsExtensionElements) {
            this.serializeExtensionElements((SupportsExtensionElements)bean, jgen, provider);
        }
    }

    @Override
    protected void serializeFieldsFiltered(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        super.serializeFieldsFiltered(bean, jgen, provider);
        if (bean instanceof SupportsExtensionAttributes) {
            this.serializeExtensionAttributes((SupportsExtensionAttributes)bean, jgen, provider);
        }
        if (bean instanceof SupportsExtensionElements) {
            this.serializeExtensionElements((SupportsExtensionElements)bean, jgen, provider);
        }
    }

    private void serializeExtensionAttributes(SupportsExtensionAttributes value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        Map<QName, String> extensionAttributes = value.getExtensionAttributes();
        if (extensionAttributes != null) {
            for (Map.Entry<QName, String> attr : extensionAttributes.entrySet()) {
                jgen.writeStringField(attr.getKey().getNamespaceURI() + attr.getKey().getLocalPart(), attr.getValue());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void serializeExtensionElements(SupportsExtensionElements value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        List<Object> extensionElements = value.getExtensionElements();
        if (extensionElements != null) {
            HashMap<String, ArrayList<void>> extensionProperties = new HashMap<String, ArrayList<void>>();
            for (Object object : extensionElements) {
                void var7_7;
                String name;
                if (object == null) continue;
                if (object instanceof Element) {
                    Element el = (Element)object;
                    name = GedcomNamespaceManager.nameFromQName(el.getNamespaceURI(), el.getLocalName());
                } else if (object instanceof JAXBElement) {
                    name = GedcomNamespaceManager.getJsonNameForWrapperName(((JAXBElement)object).getName());
                    if (name == null) {
                        name = GedcomNamespaceManager.nameFromQName(((JAXBElement)object).getName().getNamespaceURI(), ((JAXBElement)object).getName().getLocalPart());
                    }
                    Object t = ((JAXBElement)object).getValue();
                } else {
                    name = GedcomNamespaceManager.getJsonName(object.getClass());
                    if (name == null) {
                        throw new JsonMappingException("Unable to serialize custom element " + value + " because it's not a JAXBElement, DOM element, nor is it annotated with either @JsonElementWrapper or @XmlRootElement.");
                    }
                }
                ArrayList<void> propList = (ArrayList<void>)extensionProperties.get(name);
                if (propList == null) {
                    propList = new ArrayList<void>();
                    extensionProperties.put(name, propList);
                }
                propList.add(var7_7);
            }
            for (Map.Entry entry : extensionProperties.entrySet()) {
                if (((List)entry.getValue()).get(0) instanceof HasJsonKey) {
                    jgen.writeFieldName((String)entry.getKey());
                    KeyedListSerializer.serializeGeneric((Collection)entry.getValue(), jgen, provider);
                    continue;
                }
                jgen.writeArrayFieldStart((String)entry.getKey());
                for (Object element : (List)entry.getValue()) {
                    if (element instanceof Element) {
                        this.serializeElement((Element)element, jgen);
                        continue;
                    }
                    provider.findTypedValueSerializer(element.getClass(), true, null).serialize(element, jgen, provider);
                }
                jgen.writeEndArray();
            }
        }
    }

    private void serializeElement(Element element, JsonGenerator jgen) throws IOException {
        boolean startObjectWritten = false;
        boolean writeValue = false;
        StringBuilder value = new StringBuilder();
        block5: for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 2: {
                    if (!startObjectWritten) {
                        jgen.writeStartObject();
                        startObjectWritten = true;
                    }
                    jgen.writeStringField(child.getLocalName(), child.getNodeValue());
                    continue block5;
                }
                case 3: 
                case 4: {
                    writeValue = true;
                    value.append(child.getNodeValue());
                    continue block5;
                }
                case 1: {
                    if (!startObjectWritten) {
                        jgen.writeStartObject();
                        startObjectWritten = true;
                    }
                    jgen.writeFieldName(child.getNodeName());
                    this.serializeElement((Element)child, jgen);
                }
            }
        }
        if (startObjectWritten) {
            if (writeValue) {
                jgen.writeStringField("value", value.toString());
            }
            jgen.writeEndObject();
        } else if (writeValue) {
            jgen.writeString(value.toString());
        } else {
            jgen.writeStartObject();
            jgen.writeEndObject();
        }
    }
}

