/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rt.json;

import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.BeanDescription;
import org.codehaus.jackson.map.BeanProperty;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.Deserializers;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.Serializers;
import org.codehaus.jackson.map.TypeDeserializer;
import org.codehaus.jackson.map.TypeSerializer;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;
import org.gedcomx.rt.GedcomNamespaceManager;
import org.gedcomx.rt.json.GedcomBeanDeserializerModifier;
import org.gedcomx.rt.json.GedcomBeanSerializerModifier;
import org.gedcomx.rt.json.HasJsonKey;
import org.gedcomx.rt.json.KeyedListDeserializer;
import org.gedcomx.rt.json.KeyedListSerializer;

public class GedcomJacksonModule
extends Module {
    public static ObjectMapper createObjectMapper(Class<?> ... classes) {
        ObjectMapper mapper = new ObjectMapper();
        AnnotationIntrospector introspector = AnnotationIntrospector.pair(new JacksonAnnotationIntrospector(), new JaxbAnnotationIntrospector());
        mapper.getSerializationConfig().withAnnotationIntrospector(introspector);
        mapper.getSerializationConfig().enable(SerializationConfig.Feature.INDENT_OUTPUT);
        mapper.getSerializationConfig().setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        mapper.getDeserializationConfig().withAnnotationIntrospector(introspector);
        mapper.registerModule(new GedcomJacksonModule());
        for (Class<?> contextClass : classes) {
            GedcomNamespaceManager.registerKnownJsonType(contextClass);
        }
        return mapper;
    }

    @Override
    public String getModuleName() {
        return "gedcomx";
    }

    @Override
    public Version version() {
        return new Version(1, 0, 0, null);
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        context.addBeanSerializerModifier(new GedcomBeanSerializerModifier());
        context.addBeanDeserializerModifier(new GedcomBeanDeserializerModifier());
        context.addDeserializers(new GedcomDeserializers());
        context.addSerializers(new GedcomSerializers());
    }

    protected static class GedcomDeserializers
    extends Deserializers.None {
        protected GedcomDeserializers() {
        }

        @Override
        public JsonDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, DeserializerProvider provider, BeanDescription beanDesc, BeanProperty property, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
            if (type.getContentType() != null && HasJsonKey.class.isAssignableFrom(type.getContentType().getRawClass())) {
                return new KeyedListDeserializer(type.getContentType().getRawClass());
            }
            return super.findCollectionDeserializer(type, config, provider, beanDesc, property, elementTypeDeserializer, elementDeserializer);
        }
    }

    protected static class GedcomSerializers
    extends Serializers.None {
        protected GedcomSerializers() {
        }

        @Override
        public JsonSerializer<?> findCollectionSerializer(SerializationConfig config, CollectionType type, BeanDescription beanDesc, BeanProperty property, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
            if (type.getContentType() != null && HasJsonKey.class.isAssignableFrom(type.getContentType().getRawClass())) {
                return new KeyedListSerializer();
            }
            return super.findCollectionSerializer(config, type, beanDesc, property, elementTypeSerializer, elementValueSerializer);
        }
    }
}

