/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rt.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.gedcomx.rt.json.HasJsonKey;

public class KeyedListDeserializer
extends JsonDeserializer<List<? extends HasJsonKey>> {
    private final Class<?> itemType;

    public KeyedListDeserializer(Class<?> itemType) {
        if (itemType == null) {
            throw new NullPointerException();
        }
        this.itemType = itemType;
    }

    @Override
    public List<? extends HasJsonKey> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        return KeyedListDeserializer.deserializeGeneric(jp, ctxt, this.itemType);
    }

    static List<? extends HasJsonKey> deserializeGeneric(JsonParser jp, DeserializationContext ctxt, Class<?> itemType) throws IOException, JsonProcessingException {
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new JsonMappingException("Unable to deserialize keyed list: unexpected token: " + jp.getCurrentToken().name());
        }
        jp.nextToken();
        ArrayList<HasJsonKey> list = new ArrayList<HasJsonKey>();
        while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
            String key = jp.getCurrentName();
            jp.nextToken();
            if (jp.isExpectedStartArrayToken()) {
                JsonToken t;
                while ((t = jp.nextToken()) != JsonToken.END_ARRAY) {
                    HasJsonKey value;
                    if (t == JsonToken.VALUE_NULL) {
                        value = null;
                    } else {
                        value = (HasJsonKey)jp.readValueAs(itemType);
                        if (!"$".equals(key)) {
                            value.setJsonKey(key);
                        }
                    }
                    list.add(value);
                }
            } else {
                HasJsonKey value = (HasJsonKey)jp.readValueAs(itemType);
                if (!"$".equals(key)) {
                    value.setJsonKey(key);
                }
                list.add(value);
            }
            jp.nextToken();
        }
        return list;
    }
}

