/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rt.json;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.gedcomx.rt.json.HasJsonKey;

public class KeyedListSerializer
extends JsonSerializer<Collection<? extends HasJsonKey>> {
    public static final String JSON_DEFAULT_KEY = "$";

    @Override
    public void serialize(Collection<? extends HasJsonKey> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        KeyedListSerializer.serializeGeneric(value, jgen, provider);
    }

    static void serializeGeneric(Collection<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (value == null) {
            jgen.writeNull();
        } else {
            String jsonKey;
            jgen.writeStartObject();
            HashMap bykey = new HashMap();
            for (Object obj : value) {
                ArrayList keyedList;
                jsonKey = ((HasJsonKey)obj).getJsonKey();
                if (jsonKey == null) {
                    jsonKey = JSON_DEFAULT_KEY;
                }
                if ((keyedList = (ArrayList)bykey.get(jsonKey)) == null) {
                    keyedList = new ArrayList();
                    bykey.put(jsonKey, keyedList);
                }
                keyedList.add(obj);
                boolean unique = ((HasJsonKey)obj).isHasUniqueKey();
                if (!unique || keyedList.size() <= 1) continue;
                throw new JsonMappingException("Attempt to serialize " + obj + " failed because it's key '" + jsonKey + "' is not unique.");
            }
            for (Map.Entry entry : bykey.entrySet()) {
                boolean notUnique;
                jsonKey = (String)entry.getKey();
                jgen.writeFieldName(jsonKey);
                boolean bl = notUnique = ((List)entry.getValue()).size() != 1 || !((HasJsonKey)((List)entry.getValue()).get(0)).isHasUniqueKey();
                if (notUnique) {
                    jgen.writeStartArray();
                }
                for (Object keyed : (List)entry.getValue()) {
                    provider.findTypedValueSerializer(keyed.getClass(), true, null).serialize(keyed, jgen, provider);
                }
                if (!notUnique) continue;
                jgen.writeEndArray();
            }
            jgen.writeEndObject();
        }
    }
}

