/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.util;

import com.sun.xml.txw2.output.IndentingXMLStreamWriter;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.gedcomx.Gedcomx;
import org.gedcomx.records.RecordSet;
import org.gedcomx.util.CleanXMLStreamWriter;

public class RecordSetWriter {
    Marshaller marshaller;
    private XMLStreamWriter xmlWriter;
    private Gedcomx metadata;
    private boolean wroteRecords = false;
    private boolean wroteMetadata = false;
    private OutputStream outputStream;

    public RecordSetWriter(OutputStream outputStream) {
        this(outputStream, true);
    }

    protected RecordSetWriter(OutputStream outputStream, boolean shouldFilter) {
        try {
            this.marshaller = JAXBContext.newInstance(Gedcomx.class, RecordSet.class).createMarshaller();
            this.marshaller.setProperty("jaxb.fragment", true);
            this.outputStream = outputStream;
            this.xmlWriter = XMLOutputFactory.newFactory().createXMLStreamWriter(outputStream, "UTF-8");
            if (shouldFilter) {
                this.xmlWriter = new CleanXMLStreamWriter(this.xmlWriter);
            }
            this.xmlWriter.setDefaultNamespace("http://gedcomx.org/v1/");
            this.xmlWriter = new IndentingXMLStreamWriter(this.xmlWriter);
            this.xmlWriter.writeStartDocument();
            this.xmlWriter.writeStartElement("http://gedcomx.org/v1/", "records");
            this.xmlWriter.writeNamespace("", "http://gedcomx.org/v1/");
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        catch (PropertyException e) {
            throw new RuntimeException(e);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void writeRecord(Gedcomx record) throws JAXBException {
        this.writeRecord(record, "record");
        this.wroteRecords = true;
    }

    public synchronized void setMetadata(Gedcomx metadata) throws JAXBException {
        if (this.wroteMetadata) {
            throw new IllegalStateException("Already wrote metadata to stream. Can't change it now.");
        }
        if (this.wroteRecords) {
            this.metadata = metadata;
        } else {
            this.writeRecord(metadata, "metadata");
            this.wroteMetadata = true;
        }
    }

    private void writeRecord(Gedcomx record, String label) throws JAXBException {
        this.marshaller.marshal(new JAXBElement<Gedcomx>(new QName("http://gedcomx.org/v1/", label), Gedcomx.class, record), this.xmlWriter);
    }

    public synchronized void close() throws IOException {
        try {
            if (!this.wroteMetadata && this.metadata != null) {
                this.writeRecord(this.metadata, "metadata");
            }
            this.xmlWriter.writeEndElement();
            this.xmlWriter.close();
            this.outputStream.close();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

