/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.util.date;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public class Duration {
    private static final Pattern durationPattern = Pattern.compile("P(\\d{4}Y)?(\\d{2}M)?(\\d{2}D)?(?:T(\\d{2}H)?(\\d{2}M)?(\\d{2}S)?)?");
    private Integer year;
    private Integer month;
    private Integer day;
    private Integer hour;
    private Integer minute;
    private Integer second;

    public Duration(Integer year, Integer month, Integer day, Integer hour, Integer minute, Integer second) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
    }

    private static boolean ok(Integer number, int min, int max) {
        return number == null || number >= min && number <= max;
    }

    public Duration(String durationString) {
        Matcher m = durationPattern.matcher(durationString);
        if (!m.matches()) {
            throw new IllegalArgumentException("Illegal format for duration: " + durationString + "; must be P[yyyyY][mmM][ddD][T[hhH][mmM][ssS]]");
        }
        this.year = Duration.grabInt(m, 1);
        this.month = Duration.grabInt(m, 2);
        this.day = Duration.grabInt(m, 3);
        this.hour = Duration.grabInt(m, 4);
        this.minute = Duration.grabInt(m, 5);
        this.second = Duration.grabInt(m, 6);
    }

    private static Integer grabInt(Matcher matcher, int group) {
        if (matcher.groupCount() < group) {
            return null;
        }
        String s = matcher.group(group);
        if (s == null || s.length() == 0) {
            return null;
        }
        String numberString = s.substring(0, s.length() - 1);
        return Integer.parseInt(numberString);
    }

    public Integer getYear() {
        return this.year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public Integer getMonth() {
        return this.month;
    }

    public void setMonth(Integer month) {
        this.month = month;
    }

    public Integer getDay() {
        return this.day;
    }

    public void setDay(Integer day) {
        this.day = day;
    }

    public Integer getHour() {
        return this.hour;
    }

    public void setHour(Integer hour) {
        this.hour = hour;
    }

    public Integer getMinute() {
        return this.minute;
    }

    public void setMinute(Integer minute) {
        this.minute = minute;
    }

    public Integer getSecond() {
        return this.second;
    }

    public void setSecond(Integer second) {
        this.second = second;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("P");
        Duration.addNumber(sb, this.year, 4, "Y");
        Duration.addNumber(sb, this.month, 2, "M");
        Duration.addNumber(sb, this.day, 2, "D");
        if (this.hour != null || this.minute != null || this.second != null) {
            sb.append("T");
            Duration.addNumber(sb, this.hour, 2, "H");
            Duration.addNumber(sb, this.minute, 2, "M");
            Duration.addNumber(sb, this.second, 2, "S");
        }
        return sb.toString();
    }

    private static void addNumber(StringBuilder sb, Integer number, int digits, String suffix) {
        if (number != null) {
            sb.append(String.format("%0" + digits + "d" + suffix, number));
        }
    }

    public boolean isValid() {
        if (this.year == null && this.month == null && this.day == null && this.hour == null && this.minute == null && this.second == null) {
            return false;
        }
        return Duration.ok(this.year, 0, 9999) && Duration.ok(this.month, 0, 99) && Duration.ok(this.day, 0, 99) && Duration.ok(this.hour, 0, 99) && Duration.ok(this.minute, 0, 99) && Duration.ok(this.second, 0, 99);
    }
}

