/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.util.date;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlTransient;
import org.gedcomx.util.date.Duration;
import org.gedcomx.util.date.SimpleDate;

@XmlTransient
public class FormalDate {
    private boolean isApproximate;
    private boolean isRange;
    private SimpleDate start;
    private SimpleDate end;
    private Duration duration;
    private boolean isRecurring;
    private Integer numRepetitions;
    private static final Pattern formalDatePattern = Pattern.compile("(A|R([0-9]*)/)?([^/]*)(/([^/]*))?");

    public FormalDate(String formalDateString) {
        Matcher m = formalDatePattern.matcher(formalDateString);
        if (!m.matches()) {
            throw new IllegalArgumentException("Does not match formal date string format");
        }
        if (m.group(1) != null) {
            if (m.group(1).equals("A")) {
                this.isApproximate = true;
            } else if (m.group(1).startsWith("R")) {
                this.isRecurring = true;
                if (m.group(2) != null && m.group(2).length() > 0) {
                    this.numRepetitions = Integer.parseInt(m.group(2));
                }
            }
        }
        if (m.group(3) != null && m.group(3).length() > 0) {
            this.start = new SimpleDate(m.group(3));
        }
        if (m.group(4) != null) {
            this.isRange = true;
            if (m.group(5) != null && m.group(5).length() > 0) {
                if (m.group(5).startsWith("P")) {
                    if (this.start == null) {
                        throw new IllegalArgumentException("Error: Cannot have a duration without a starting date.");
                    }
                    this.duration = new Duration(m.group(5));
                } else {
                    this.end = new SimpleDate(m.group(5));
                }
            }
        }
    }

    public boolean isApproximate() {
        return this.isApproximate;
    }

    public void setApproximate(boolean approximate) {
        this.isApproximate = approximate;
    }

    public boolean isRange() {
        return this.isRange;
    }

    public void setRange(boolean range) {
        this.isRange = range;
    }

    public SimpleDate getStart() {
        return this.start;
    }

    public void setStart(SimpleDate start) {
        this.start = start;
    }

    public SimpleDate getEnd() {
        return this.end;
    }

    public void setEnd(SimpleDate end) {
        this.end = end;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public boolean isRecurring() {
        return this.isRecurring;
    }

    public void setRecurring(boolean recurring) {
        this.isRecurring = recurring;
    }

    public Integer getNumRepetitions() {
        return this.numRepetitions;
    }

    public void setNumRepetitions(Integer numRepetitions) {
        this.numRepetitions = numRepetitions;
    }

    public boolean isValid() {
        if (this.isRecurring) {
            return !this.isApproximate && this.start != null && this.start.isValid() && (this.end != null && this.end.isValid() || this.end == null && this.duration != null && this.duration.isValid());
        }
        if (this.numRepetitions != null) {
            return false;
        }
        if (this.start != null && !this.isRange) {
            return this.end == null && this.duration == null && this.start.isValid();
        }
        if (this.isRange) {
            if (this.start == null) {
                return this.end != null && this.end.isValid() && this.duration == null;
            }
            return !(this.end != null && this.duration != null || this.end != null && !this.end.isValid() || this.duration != null && !this.duration.isValid());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isRecurring) {
            sb.append("R");
            if (this.numRepetitions != null) {
                sb.append(this.numRepetitions);
            }
            sb.append("/");
        } else if (this.isApproximate) {
            sb.append("A");
        }
        if (this.start != null) {
            sb.append(this.start.toString());
        }
        if (this.isRange) {
            sb.append("/");
        }
        if (this.end != null) {
            sb.append(this.end.toString());
        } else if (this.duration != null) {
            sb.append(this.duration.toString());
        }
        return sb.toString();
    }
}

