/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.util.date;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public class SimpleDate {
    private int year;
    private Integer month;
    private Integer day;
    private Integer hour;
    private Integer minute;
    private Integer second;
    private boolean isUTC;
    private Integer timeZoneHours;
    private Integer timeZoneMinutes;
    private static final Pattern simpleDatePattern = Pattern.compile("((?:\\+|-)\\d{4})(?:-(\\d{2})(?:-(\\d{2})(?:T(\\d{2})(?::(\\d{2})(?::(\\d{2})?)?)?(Z|((?:\\+|-)\\d{2})(?::(\\d{2}))?)?)?)?)?");

    public SimpleDate(int year) {
        this.year = year;
    }

    public boolean isValid() {
        if (this.timeZoneMinutes != null && (this.timeZoneMinutes < 0 || this.timeZoneMinutes > 59 || this.timeZoneHours == null || this.isUTC)) {
            return false;
        }
        if (this.timeZoneHours != null && (this.timeZoneHours < -23 || this.timeZoneHours > 23 || this.isUTC)) {
            return false;
        }
        return !SimpleDate.hasProblem(this.second, 0, 59, this.minute) && !SimpleDate.hasProblem(this.minute, 0, 59, this.hour) && !SimpleDate.hasProblem(this.hour, 0, 23, this.day) && !SimpleDate.hasProblem(this.day, 1, 31, this.month) && !SimpleDate.hasProblem(this.month, 1, 12, new Integer(this.year));
    }

    private static boolean hasProblem(Integer number, Integer min, Integer max, Integer moreGeneral) {
        return number != null && (number < min || number > max || moreGeneral == null);
    }

    public SimpleDate(String simpleDateString) {
        Matcher m = simpleDatePattern.matcher(simpleDateString);
        if (!m.matches()) {
            throw new IllegalArgumentException("Malformed simple date string.  Must be (+|-)YYYY[-MM[-DD[Thh[:mm[:ss]][Z|(+|-)hh[:mm]]]]]");
        }
        this.year = SimpleDate.grabInt(m, 1);
        this.month = SimpleDate.grabInt(m, 2);
        this.day = SimpleDate.grabInt(m, 3);
        this.hour = SimpleDate.grabInt(m, 4);
        this.minute = SimpleDate.grabInt(m, 5);
        this.second = SimpleDate.grabInt(m, 6);
        if (m.groupCount() >= 7 && m.group(7) != null && m.group(7).equals("Z")) {
            this.isUTC = true;
        } else {
            this.isUTC = false;
            this.timeZoneHours = SimpleDate.grabInt(m, 8);
            this.timeZoneMinutes = SimpleDate.grabInt(m, 9);
        }
    }

    public SimpleDate(int year, Integer month, Integer day, Integer hour, Integer minute, Integer second, boolean isUTC, Integer timeZoneHours, Integer timeZoneMinutes) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.isUTC = isUTC;
        this.timeZoneHours = timeZoneHours;
        this.timeZoneMinutes = timeZoneMinutes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.year >= 0 ? "+" : "-").append(String.format("%04d", Math.abs(this.year)));
        if (this.month != null) {
            sb.append("-").append(String.format("%02d", this.month));
            if (this.day != null) {
                sb.append("-").append(String.format("%02d", this.day));
                if (this.hour != null) {
                    sb.append("T").append(String.format("%02d", this.hour));
                    if (this.minute != null) {
                        sb.append(":").append(String.format("%02d", this.minute));
                        if (this.second != null) {
                            sb.append(":").append(String.format("%02d", this.second));
                        }
                    }
                    if (this.isUTC) {
                        sb.append("Z");
                    } else if (this.timeZoneHours != null) {
                        sb.append(this.timeZoneHours >= 0 ? "+" : "-").append(String.format("%02d", Math.abs(this.timeZoneHours)));
                        if (this.timeZoneMinutes != null) {
                            sb.append(":").append(this.timeZoneMinutes);
                        }
                    }
                }
            }
        }
        return sb.toString();
    }

    private static Integer grabInt(Matcher matcher, int group) {
        if (matcher.groupCount() < group) {
            return null;
        }
        String s = matcher.group(group);
        if (s == null) {
            return null;
        }
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        return Integer.parseInt(s);
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public Integer getMonth() {
        return this.month;
    }

    public void setMonth(Integer month) {
        if (month != null && (month < 1 || month > 12)) {
            throw new IllegalArgumentException("Month must be from 1 to 12, or null if there is no month.");
        }
        this.month = month;
    }

    public Integer getDay() {
        return this.day;
    }

    public void setDay(Integer day) {
        if (day != null && (day < 1 || day > 31)) {
            throw new IllegalArgumentException("Day must be from 1 to 31, or null if there is no day");
        }
        this.day = day;
    }

    public Integer getHour() {
        return this.hour;
    }

    public void setHour(Integer hour) {
        this.hour = hour;
    }

    public Integer getMinute() {
        return this.minute;
    }

    public void setMinute(Integer minute) {
        this.minute = minute;
    }

    public Integer getSecond() {
        return this.second;
    }

    public void setSecond(Integer second) {
        this.second = second;
    }

    public boolean isUTC() {
        return this.isUTC;
    }

    public void setUTC(boolean UTC) {
        this.isUTC = UTC;
    }

    public Integer getTimeZoneHours() {
        return this.timeZoneHours;
    }

    public void setTimeZoneHours(Integer timeZoneHours) {
        this.timeZoneHours = timeZoneHours;
    }

    public Integer getTimeZoneMinutes() {
        return this.timeZoneMinutes;
    }

    public void setTimeZoneMinutes(Integer timeZoneMinutes) {
        this.timeZoneMinutes = timeZoneMinutes;
    }
}

