/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.vocab;

import java.util.ArrayList;
import java.util.List;
import org.gedcomx.common.TextValue;
import org.gedcomx.common.URI;

public class VocabElement
implements Comparable<VocabElement> {
    private String id;
    private URI uri;
    private URI subclass;
    private URI type;
    private transient String sortName;
    private List<TextValue> labels = new ArrayList<TextValue>();
    private List<TextValue> descriptions = new ArrayList<TextValue>();
    private URI sublist;
    private transient Integer position;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public URI getSubclass() {
        return this.subclass;
    }

    public void setSubclass(URI subclass) {
        this.subclass = subclass;
    }

    public URI getType() {
        return this.type;
    }

    public void setType(URI type) {
        this.type = type;
    }

    public String getSortName() {
        return this.sortName;
    }

    public void setSortName(String sortName) {
        this.sortName = sortName;
    }

    public List<TextValue> getLabels() {
        return this.labels;
    }

    public VocabElement addLabel(String label, String locale) {
        this.labels.add(new TextValue(label).lang(locale));
        return this;
    }

    public List<TextValue> getDescriptions() {
        return this.descriptions;
    }

    public VocabElement addDescription(String description, String locale) {
        this.descriptions.add(new TextValue(description).lang(locale));
        return this;
    }

    public URI getSublist() {
        return this.sublist;
    }

    public void setSublist(URI sublist) {
        this.sublist = sublist;
    }

    public Integer getPosition() {
        return this.position;
    }

    public void setPosition(Integer position) {
        this.position = position;
    }

    @Override
    public int compareTo(VocabElement o) {
        int pos = 0;
        Integer oPosition = o.getPosition();
        if (this.position != null) {
            pos = oPosition == null ? this.position : this.position - oPosition;
        } else if (oPosition != null) {
            pos = oPosition;
        }
        if (pos == 0) {
            pos = this.sortName.compareTo(o.getSortName());
        }
        if (pos == 0) {
            pos = this.type.toString().compareTo(o.getType().toString());
        }
        if (pos == 0) {
            pos = this.subclass.toString().compareTo(o.getSubclass().toString());
        }
        if (pos == 0) {
            pos = this.uri.toString().compareTo(o.getUri().toString());
        }
        return pos;
    }
}

