/*
 * Decompiled with CFR 0.152.
 */
package org.gedml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class AnselInputStreamReader
extends InputStreamReader {
    private InputStream input;
    private int pending;

    public AnselInputStreamReader(InputStream in) throws IOException {
        super(in);
        this.input = in;
        this.pending = this.input.read();
    }

    @Override
    public int read() throws IOException {
        int u;
        int b = this.pending;
        if (b < 0) {
            return b;
        }
        this.pending = this.input.read();
        if (b < 128) {
            return b;
        }
        if (this.pending > 0 && b >= 224 && b <= 255 && (u = this.convert2(b * 256 + this.pending)) > 0) {
            this.pending = this.input.read();
            return u;
        }
        return this.convert1(b);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.pending < 0) {
            return -1;
        }
        for (int i = off; i < off + len; ++i) {
            int c = this.read();
            if (c < 0) {
                return i - off;
            }
            cbuf[off + i] = (char)c;
        }
        return len;
    }

    @Override
    public String getEncoding() {
        return "ANSEL";
    }

    private int convert1(int ansel) {
        switch (ansel) {
            case 141: {
                return 8205;
            }
            case 142: {
                return 8204;
            }
            case 161: {
                return 321;
            }
            case 162: {
                return 216;
            }
            case 163: {
                return 208;
            }
            case 164: {
                return 222;
            }
            case 165: {
                return 198;
            }
            case 166: {
                return 338;
            }
            case 167: {
                return 697;
            }
            case 168: {
                return 183;
            }
            case 169: {
                return 9837;
            }
            case 170: {
                return 174;
            }
            case 171: {
                return 177;
            }
            case 172: {
                return 416;
            }
            case 173: {
                return 431;
            }
            case 174: {
                return 702;
            }
            case 176: {
                return 176;
            }
            case 177: {
                return 322;
            }
            case 178: {
                return 248;
            }
            case 179: {
                return 273;
            }
            case 180: {
                return 254;
            }
            case 181: {
                return 230;
            }
            case 182: {
                return 339;
            }
            case 183: {
                return 698;
            }
            case 184: {
                return 305;
            }
            case 185: {
                return 163;
            }
            case 186: {
                return 240;
            }
            case 188: {
                return 417;
            }
            case 189: {
                return 432;
            }
            case 192: {
                return 176;
            }
            case 193: {
                return 8467;
            }
            case 194: {
                return 8471;
            }
            case 195: {
                return 169;
            }
            case 196: {
                return 9839;
            }
            case 197: {
                return 191;
            }
            case 198: {
                return 161;
            }
            case 207: {
                return 223;
            }
            case 224: {
                return 777;
            }
            case 225: {
                return 768;
            }
            case 226: {
                return 769;
            }
            case 227: {
                return 770;
            }
            case 228: {
                return 771;
            }
            case 229: {
                return 772;
            }
            case 230: {
                return 774;
            }
            case 231: {
                return 775;
            }
            case 233: {
                return 780;
            }
            case 234: {
                return 778;
            }
            case 235: {
                return 65056;
            }
            case 236: {
                return 65057;
            }
            case 237: {
                return 789;
            }
            case 238: {
                return 779;
            }
            case 239: {
                return 784;
            }
            case 240: {
                return 807;
            }
            case 241: {
                return 808;
            }
            case 242: {
                return 803;
            }
            case 243: {
                return 804;
            }
            case 244: {
                return 805;
            }
            case 245: {
                return 819;
            }
            case 246: {
                return 818;
            }
            case 247: {
                return 806;
            }
            case 248: {
                return 796;
            }
            case 249: {
                return 814;
            }
            case 250: {
                return 65058;
            }
            case 251: {
                return 65059;
            }
            case 254: {
                return 787;
            }
            case 129: {
                return 252;
            }
            case 136: {
                return 152;
            }
            case 137: {
                return 156;
            }
            case 146: {
                return 39;
            }
            case 147: {
                return 8220;
            }
            case 148: {
                return 8221;
            }
            case 199: {
                return 223;
            }
            case 200: {
                return 8364;
            }
            case 232: {
                return 776;
            }
        }
        return 65533;
    }

    private int convert2(int ansel) {
        switch (ansel) {
            case 57409: {
                return 7842;
            }
            case 57413: {
                return 7866;
            }
            case 57417: {
                return 7880;
            }
            case 57423: {
                return 7886;
            }
            case 57429: {
                return 7910;
            }
            case 57433: {
                return 7926;
            }
            case 57441: {
                return 7843;
            }
            case 57445: {
                return 7867;
            }
            case 57449: {
                return 7881;
            }
            case 57455: {
                return 7887;
            }
            case 57461: {
                return 7911;
            }
            case 57465: {
                return 7927;
            }
            case 57665: {
                return 192;
            }
            case 57669: {
                return 200;
            }
            case 57673: {
                return 204;
            }
            case 57679: {
                return 210;
            }
            case 57685: {
                return 217;
            }
            case 57687: {
                return 7808;
            }
            case 57689: {
                return 7922;
            }
            case 57697: {
                return 224;
            }
            case 57701: {
                return 232;
            }
            case 57705: {
                return 236;
            }
            case 57711: {
                return 242;
            }
            case 57717: {
                return 249;
            }
            case 57719: {
                return 7809;
            }
            case 57721: {
                return 7923;
            }
            case 57921: {
                return 193;
            }
            case 57923: {
                return 262;
            }
            case 57925: {
                return 201;
            }
            case 57927: {
                return 500;
            }
            case 57929: {
                return 205;
            }
            case 57931: {
                return 7728;
            }
            case 57932: {
                return 313;
            }
            case 57933: {
                return 7742;
            }
            case 57934: {
                return 323;
            }
            case 57935: {
                return 211;
            }
            case 57936: {
                return 7764;
            }
            case 57938: {
                return 340;
            }
            case 57939: {
                return 346;
            }
            case 57941: {
                return 218;
            }
            case 57943: {
                return 7810;
            }
            case 57945: {
                return 221;
            }
            case 57946: {
                return 377;
            }
            case 57953: {
                return 225;
            }
            case 57955: {
                return 263;
            }
            case 57957: {
                return 233;
            }
            case 57959: {
                return 501;
            }
            case 57961: {
                return 237;
            }
            case 57963: {
                return 7729;
            }
            case 57964: {
                return 314;
            }
            case 57965: {
                return 7743;
            }
            case 57966: {
                return 324;
            }
            case 57967: {
                return 243;
            }
            case 57968: {
                return 7765;
            }
            case 57970: {
                return 341;
            }
            case 57971: {
                return 347;
            }
            case 57973: {
                return 250;
            }
            case 57975: {
                return 7811;
            }
            case 57977: {
                return 253;
            }
            case 57978: {
                return 378;
            }
            case 58021: {
                return 508;
            }
            case 58037: {
                return 509;
            }
            case 58177: {
                return 194;
            }
            case 58179: {
                return 264;
            }
            case 58181: {
                return 202;
            }
            case 58183: {
                return 284;
            }
            case 58184: {
                return 292;
            }
            case 58185: {
                return 206;
            }
            case 58186: {
                return 308;
            }
            case 58191: {
                return 212;
            }
            case 58195: {
                return 348;
            }
            case 58197: {
                return 219;
            }
            case 58199: {
                return 372;
            }
            case 58201: {
                return 374;
            }
            case 58202: {
                return 7824;
            }
            case 58209: {
                return 226;
            }
            case 58211: {
                return 265;
            }
            case 58213: {
                return 234;
            }
            case 58215: {
                return 285;
            }
            case 58216: {
                return 293;
            }
            case 58217: {
                return 238;
            }
            case 58218: {
                return 309;
            }
            case 58223: {
                return 244;
            }
            case 58227: {
                return 349;
            }
            case 58229: {
                return 251;
            }
            case 58231: {
                return 373;
            }
            case 58233: {
                return 375;
            }
            case 58234: {
                return 7825;
            }
            case 58433: {
                return 195;
            }
            case 58437: {
                return 7868;
            }
            case 58441: {
                return 296;
            }
            case 58446: {
                return 209;
            }
            case 58447: {
                return 213;
            }
            case 58453: {
                return 360;
            }
            case 58454: {
                return 7804;
            }
            case 58457: {
                return 7928;
            }
            case 58465: {
                return 227;
            }
            case 58469: {
                return 7869;
            }
            case 58473: {
                return 297;
            }
            case 58478: {
                return 241;
            }
            case 58479: {
                return 245;
            }
            case 58485: {
                return 361;
            }
            case 58486: {
                return 7805;
            }
            case 58489: {
                return 7929;
            }
            case 58689: {
                return 256;
            }
            case 58693: {
                return 274;
            }
            case 58695: {
                return 7712;
            }
            case 58697: {
                return 298;
            }
            case 58703: {
                return 332;
            }
            case 58709: {
                return 362;
            }
            case 58721: {
                return 257;
            }
            case 58725: {
                return 275;
            }
            case 58727: {
                return 7713;
            }
            case 58729: {
                return 299;
            }
            case 58735: {
                return 333;
            }
            case 58741: {
                return 363;
            }
            case 58789: {
                return 482;
            }
            case 58805: {
                return 483;
            }
            case 58945: {
                return 258;
            }
            case 58949: {
                return 276;
            }
            case 58951: {
                return 286;
            }
            case 58953: {
                return 300;
            }
            case 58959: {
                return 334;
            }
            case 58965: {
                return 364;
            }
            case 58977: {
                return 259;
            }
            case 58981: {
                return 277;
            }
            case 58983: {
                return 287;
            }
            case 58985: {
                return 301;
            }
            case 58991: {
                return 335;
            }
            case 58997: {
                return 365;
            }
            case 59202: {
                return 7682;
            }
            case 59203: {
                return 266;
            }
            case 59204: {
                return 7690;
            }
            case 59205: {
                return 278;
            }
            case 59206: {
                return 7710;
            }
            case 59207: {
                return 288;
            }
            case 59208: {
                return 7714;
            }
            case 59209: {
                return 304;
            }
            case 59213: {
                return 7744;
            }
            case 59214: {
                return 7748;
            }
            case 59216: {
                return 7766;
            }
            case 59218: {
                return 7768;
            }
            case 59219: {
                return 7776;
            }
            case 59220: {
                return 7786;
            }
            case 59223: {
                return 7814;
            }
            case 59224: {
                return 7818;
            }
            case 59225: {
                return 7822;
            }
            case 59226: {
                return 379;
            }
            case 59234: {
                return 7683;
            }
            case 59235: {
                return 267;
            }
            case 59236: {
                return 7691;
            }
            case 59237: {
                return 279;
            }
            case 59238: {
                return 7711;
            }
            case 59239: {
                return 289;
            }
            case 59240: {
                return 7715;
            }
            case 59245: {
                return 7745;
            }
            case 59246: {
                return 7749;
            }
            case 59248: {
                return 7767;
            }
            case 59250: {
                return 7769;
            }
            case 59251: {
                return 7777;
            }
            case 59252: {
                return 7787;
            }
            case 59255: {
                return 7815;
            }
            case 59256: {
                return 7819;
            }
            case 59257: {
                return 7823;
            }
            case 59258: {
                return 380;
            }
            case 59457: {
                return 196;
            }
            case 59461: {
                return 203;
            }
            case 59464: {
                return 7718;
            }
            case 59465: {
                return 207;
            }
            case 59471: {
                return 214;
            }
            case 59477: {
                return 220;
            }
            case 59479: {
                return 7812;
            }
            case 59480: {
                return 7820;
            }
            case 59481: {
                return 376;
            }
            case 59489: {
                return 228;
            }
            case 59493: {
                return 235;
            }
            case 59496: {
                return 7719;
            }
            case 59497: {
                return 239;
            }
            case 59503: {
                return 246;
            }
            case 59508: {
                return 7831;
            }
            case 59509: {
                return 252;
            }
            case 59511: {
                return 7813;
            }
            case 59512: {
                return 7821;
            }
            case 59513: {
                return 255;
            }
            case 59713: {
                return 461;
            }
            case 59715: {
                return 268;
            }
            case 59716: {
                return 270;
            }
            case 59717: {
                return 282;
            }
            case 59719: {
                return 486;
            }
            case 59721: {
                return 463;
            }
            case 59723: {
                return 488;
            }
            case 59724: {
                return 317;
            }
            case 59726: {
                return 327;
            }
            case 59727: {
                return 465;
            }
            case 59730: {
                return 344;
            }
            case 59731: {
                return 352;
            }
            case 59732: {
                return 356;
            }
            case 59733: {
                return 467;
            }
            case 59738: {
                return 381;
            }
            case 59745: {
                return 462;
            }
            case 59747: {
                return 269;
            }
            case 59748: {
                return 271;
            }
            case 59749: {
                return 283;
            }
            case 59751: {
                return 487;
            }
            case 59753: {
                return 464;
            }
            case 59754: {
                return 496;
            }
            case 59755: {
                return 489;
            }
            case 59756: {
                return 318;
            }
            case 59758: {
                return 328;
            }
            case 59759: {
                return 466;
            }
            case 59762: {
                return 345;
            }
            case 59763: {
                return 353;
            }
            case 59764: {
                return 357;
            }
            case 59765: {
                return 468;
            }
            case 59770: {
                return 382;
            }
            case 59969: {
                return 197;
            }
            case 60001: {
                return 229;
            }
            case 60021: {
                return 367;
            }
            case 60023: {
                return 7832;
            }
            case 60025: {
                return 7833;
            }
            case 60077: {
                return 366;
            }
            case 61007: {
                return 336;
            }
            case 61013: {
                return 368;
            }
            case 61039: {
                return 337;
            }
            case 61045: {
                return 369;
            }
            case 61472: {
                return 184;
            }
            case 61507: {
                return 199;
            }
            case 61508: {
                return 7696;
            }
            case 61511: {
                return 290;
            }
            case 61512: {
                return 7720;
            }
            case 61515: {
                return 310;
            }
            case 61516: {
                return 315;
            }
            case 61518: {
                return 325;
            }
            case 61522: {
                return 342;
            }
            case 61523: {
                return 350;
            }
            case 61524: {
                return 354;
            }
            case 61539: {
                return 231;
            }
            case 61540: {
                return 7697;
            }
            case 61543: {
                return 291;
            }
            case 61544: {
                return 7721;
            }
            case 61547: {
                return 311;
            }
            case 61548: {
                return 316;
            }
            case 61550: {
                return 326;
            }
            case 61554: {
                return 343;
            }
            case 61555: {
                return 351;
            }
            case 61556: {
                return 355;
            }
            case 61761: {
                return 260;
            }
            case 61765: {
                return 280;
            }
            case 61769: {
                return 302;
            }
            case 61775: {
                return 490;
            }
            case 61781: {
                return 370;
            }
            case 61793: {
                return 261;
            }
            case 61797: {
                return 281;
            }
            case 61801: {
                return 303;
            }
            case 61807: {
                return 491;
            }
            case 61813: {
                return 371;
            }
            case 62017: {
                return 7840;
            }
            case 62018: {
                return 7684;
            }
            case 62020: {
                return 7692;
            }
            case 62021: {
                return 7864;
            }
            case 62024: {
                return 7716;
            }
            case 62025: {
                return 7882;
            }
            case 62027: {
                return 7730;
            }
            case 62028: {
                return 7734;
            }
            case 62029: {
                return 7746;
            }
            case 62030: {
                return 7750;
            }
            case 62031: {
                return 7884;
            }
            case 62034: {
                return 7770;
            }
            case 62035: {
                return 7778;
            }
            case 62036: {
                return 7788;
            }
            case 62037: {
                return 7908;
            }
            case 62038: {
                return 7806;
            }
            case 62039: {
                return 7816;
            }
            case 62041: {
                return 7924;
            }
            case 62042: {
                return 7826;
            }
            case 62049: {
                return 7841;
            }
            case 62050: {
                return 7685;
            }
            case 62052: {
                return 7693;
            }
            case 62053: {
                return 7865;
            }
            case 62056: {
                return 7717;
            }
            case 62057: {
                return 7883;
            }
            case 62059: {
                return 7731;
            }
            case 62060: {
                return 7735;
            }
            case 62061: {
                return 7747;
            }
            case 62062: {
                return 7751;
            }
            case 62063: {
                return 7885;
            }
            case 62066: {
                return 7771;
            }
            case 62067: {
                return 7779;
            }
            case 62068: {
                return 7789;
            }
            case 62069: {
                return 7909;
            }
            case 62070: {
                return 7807;
            }
            case 62071: {
                return 7817;
            }
            case 62073: {
                return 7925;
            }
            case 62074: {
                return 7827;
            }
            case 62293: {
                return 7794;
            }
            case 62325: {
                return 7795;
            }
            case 62529: {
                return 7680;
            }
            case 62561: {
                return 7681;
            }
            case 63816: {
                return 7722;
            }
            case 63848: {
                return 7723;
            }
        }
        return -1;
    }
}

