/*
 * Decompiled with CFR 0.152.
 */
package org.gedml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GedcomLineParser {
    private static final Pattern pGedcomLine = Pattern.compile("^\\s*(\\d)\\s+(@([^@ ]+)@\\s+)?([a-zA-Z_0-9.]+)(\\s+@([^@ ]+)@)?(\\s(.*))?$", 32);
    private static final int LEVEL_GROUP = 1;
    private static final int ID_GROUP = 3;
    private static final int TAG_GROUP = 4;
    private static final int XREF_GROUP = 6;
    private static final int VALUE_GROUP = 8;
    private Matcher m = null;

    public boolean parse(String line) {
        this.m = pGedcomLine.matcher(line);
        return this.m.find();
    }

    public String getLevel() {
        return this.m.group(1);
    }

    public String getXRef() {
        return this.m.group(6);
    }

    public String getID() {
        return this.m.group(3);
    }

    public String getTag() {
        return this.m.group(4);
    }

    public String getValue() {
        return this.m.group(8);
    }
}

