/*
 * Decompiled with CFR 0.152.
 */
package org.gedml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;
import org.gedml.AnselInputStreamReader;
import org.gedml.GedcomLineParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class GedcomParser
implements XMLReader,
Locator {
    private static final List<String> ACCEPTED_TRUE_SAX_FEATURES = Arrays.asList("http://xml.org/sax/features/namespace-prefixes", "http://xml.org/sax/features/external-general-entities", "http://xml.org/sax/features/external-parameter-entities", "http://xml.org/sax/features/string-interning");
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private AttributesImpl emptyAttList = new AttributesImpl();
    private AttributesImpl attList = new AttributesImpl();
    private EntityResolver entityResolver = null;
    private String systemId;
    private int lineNr;

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setEntityResolver(EntityResolver er) {
        this.entityResolver = er;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setDTDHandler(DTDHandler dh) {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler = eh;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public static String readCorrectedCharsetName(InputStream is) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        return GedcomParser.readCorrectedCharsetName(in);
    }

    private static String readCorrectedCharsetName(BufferedReader in) throws IOException {
        String generatorName = null;
        String encoding = null;
        String version = null;
        for (int i = 0; i < 100; ++i) {
            String[] split;
            String line = in.readLine();
            if (line != null && (split = line.trim().split("\\s+", 3)).length == 3) {
                if (generatorName == null && split[0].equals("1") && split[1].equals("SOUR")) {
                    generatorName = split[2];
                } else if (split[0].equals("1") && (split[1].equals("CHAR") || split[1].equals("CHARACTER"))) {
                    encoding = split[2].toUpperCase();
                    line = in.readLine();
                    if (line != null && (split = line.trim().split("\\s+", 3)).length == 3 && split[0].equals("2") && split[1].equals("VERS")) {
                        version = split[2];
                    }
                }
            }
            if (generatorName != null && encoding != null) break;
        }
        in.close();
        return GedcomParser.getCorrectedCharsetName(generatorName, encoding, version);
    }

    public static String getCorrectedCharsetName(String generatorName, String encoding, String version) {
        if ("GeneWeb".equals(generatorName) && "ASCII".equals(encoding)) {
            encoding = "Cp1252";
        } else if ("Geni.com".equals(generatorName) && "UNICODE".equals(encoding)) {
            encoding = "UTF-8";
        } else if ("Geni.com".equals(generatorName) && "ANSEL".equals(encoding)) {
            encoding = "UTF-8";
        } else if ("GENJ".equals(generatorName) && "UNICODE".equals(encoding)) {
            encoding = "UTF-8";
        } else if ("ASCII".equals(encoding)) {
            if ("MacOS Roman".equals(version)) {
                encoding = "x-MacRoman";
            }
        } else if ("ATARIST_ASCII".equals(encoding)) {
            encoding = "ASCII";
        } else if ("MACROMAN".equals(encoding) || "MACINTOSH".equals(encoding)) {
            encoding = "x-MacRoman";
        } else if ("ANSI".equals(encoding) || "IBM WINDOWS".equals(encoding)) {
            encoding = "Cp1252";
        } else if ("WINDOWS-874".equals(encoding)) {
            encoding = "Cp874";
        } else if ("WINDOWS-1251".equals(encoding)) {
            encoding = "Cp1251";
        } else if ("WINDOWS-1254".equals(encoding)) {
            encoding = "Cp1254";
        } else if ("IBMPC".equals(encoding) || "IBM DOS".equals(encoding)) {
            encoding = "Cp850";
        } else if ("UNICODE".equals(encoding)) {
            encoding = "UTF-16";
        } else if ("UTF-16BE".equals(encoding)) {
            encoding = "UnicodeBigUnmarked";
        } else if (encoding == null) {
            encoding = "";
        }
        return encoding;
    }

    private BufferedReader getBufferedReader(String systemId) throws IOException, SAXException {
        int c;
        InputStream in = new URL(systemId).openStream();
        String charEncoding = GedcomParser.readCorrectedCharsetName(in);
        in.close();
        if (charEncoding.length() == 0) {
            BufferedReader br = new BufferedReader(new InputStreamReader(new URL(systemId).openStream(), "UTF-16"));
            charEncoding = GedcomParser.readCorrectedCharsetName(br);
            br.close();
            if (charEncoding.equals("UTF-16")) {
                int c2;
                InputStreamReader reader = new InputStreamReader(new URL(systemId).openStream(), "UTF-16");
                int cnt = 0;
                while ((c2 = reader.read()) != 48 && c2 != -1) {
                    ++cnt;
                }
                reader.close();
                reader = new InputStreamReader(new URL(systemId).openStream(), "UTF-16");
                for (int i = 0; i < cnt; ++i) {
                    reader.read();
                }
                return new BufferedReader(reader);
            }
        }
        if (charEncoding.length() == 0) {
            charEncoding = "ANSEL";
        }
        in = new URL(systemId).openStream();
        int cnt = 0;
        while ((c = in.read()) != 48 && c != -1) {
            ++cnt;
        }
        in.close();
        in = new URL(systemId).openStream();
        for (int i = 0; i < cnt; ++i) {
            in.read();
        }
        InputStreamReader reader = charEncoding.equals("ANSEL") ? new AnselInputStreamReader(in) : new InputStreamReader(in, charEncoding);
        return new BufferedReader(reader);
    }

    @Override
    public void parse(InputSource source) throws IOException, SAXParseException {
        this.parse(source.getSystemId());
    }

    @Override
    public void parse(String systemId) throws IOException, SAXParseException {
        this.systemId = systemId;
        int prevLevel = -1;
        this.lineNr = 0;
        Stack<String> stack = new Stack<String>();
        stack.push("GED");
        BufferedReader reader = null;
        StringBuilder buf = new StringBuilder();
        try {
            String line;
            reader = this.getBufferedReader(systemId);
            this.contentHandler.setDocumentLocator(this);
            this.contentHandler.startDocument();
            this.contentHandler.startElement("", "GED", "GED", this.emptyAttList);
            boolean goodLine = false;
            GedcomLineParser lineParser = new GedcomLineParser();
            while ((line = reader.readLine()) != null) {
                ++this.lineNr;
                buf.setLength(0);
                for (int j = 0; j < line.length(); ++j) {
                    char c = line.charAt(j);
                    if (c < ' ' && c != '\t') continue;
                    buf.append(c);
                }
                line = buf.toString();
                if (line.length() <= 0) continue;
                if (!lineParser.parse(line)) {
                    if (goodLine) {
                        this.errorHandler.error(new SAXParseException("Line does not appear to be standard @ " + this.getLineNumber() + " appending content to the last tag started." + line, this));
                        this.contentHandler.characters(line.toCharArray(), 0, line.length());
                    }
                    if (this.lineNr <= 20 || goodLine) continue;
                    break;
                }
                int thisLevel = Integer.parseInt(lineParser.getLevel());
                String tag = lineParser.getTag();
                if (thisLevel > prevLevel + 1) {
                    this.errorHandler.error(new SAXParseException("Level > prevLevel+1 @ " + this.getLineNumber(), this));
                    continue;
                }
                if (thisLevel < 0) {
                    this.errorHandler.error(new SAXParseException("Level < 0 @ " + this.getLineNumber(), this));
                    continue;
                }
                if (tag == null || tag.length() == 0) {
                    this.errorHandler.error(new SAXParseException("Tag not found @ " + this.getLineNumber(), this));
                    continue;
                }
                String iden = lineParser.getID();
                String xref = lineParser.getXRef();
                String valu = lineParser.getValue();
                while (thisLevel <= prevLevel) {
                    String endtag = (String)stack.pop();
                    this.contentHandler.endElement("", endtag, endtag);
                    --prevLevel;
                }
                this.attList.clear();
                if (iden != null && iden.length() > 0) {
                    this.attList.addAttribute("", "ID", "ID", "ID", iden);
                }
                if (xref != null && xref.length() > 0) {
                    this.attList.addAttribute("", "REF", "REF", "IDREF", xref);
                }
                this.contentHandler.startElement("", tag, tag, this.attList);
                goodLine = true;
                stack.push(tag);
                prevLevel = thisLevel;
                if (valu == null || valu.length() <= 0) continue;
                this.contentHandler.characters(valu.toCharArray(), 0, valu.length());
            }
            if (!goodLine) {
                throw new SAXParseException("no good lines found in the first 20 lines ", this);
            }
            this.contentHandler.endElement("", "GED", "GED");
            this.contentHandler.endDocument();
        }
        catch (SAXException e) {
            SAXParseException err = new SAXParseException("SAXException: " + e.getMessage(), this);
            try {
                this.errorHandler.fatalError(err);
            }
            catch (SAXException e1) {
                // empty catch block
            }
            throw err;
        }
        catch (EmptyStackException e) {
            SAXParseException err = new SAXParseException("EmptyStack: " + e.getMessage(), this);
            try {
                this.errorHandler.fatalError(err);
            }
            catch (SAXException e1) {
                // empty catch block
            }
            throw err;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Override
    public void setFeature(String s, boolean b) throws SAXNotRecognizedException {
        if (!b || !ACCEPTED_TRUE_SAX_FEATURES.contains(s)) {
            throw new SAXNotRecognizedException("Gedcom Parser does not recognize the feature '" + s + "'");
        }
    }

    @Override
    public boolean getFeature(String s) throws SAXNotRecognizedException {
        if (s.equals("http://xml.org/sax/features/namespaces")) {
            return true;
        }
        if (s.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return false;
        }
        throw new SAXNotRecognizedException("Gedcom Parser does not recognize any features");
    }

    @Override
    public void setProperty(String s, Object b) throws SAXNotRecognizedException {
        throw new SAXNotRecognizedException("Gedcom Parser does not recognize any properties");
    }

    @Override
    public Object getProperty(String s) throws SAXNotRecognizedException {
        throw new SAXNotRecognizedException("Gedcom Parser does not recognize any properties");
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public int getLineNumber() {
        return this.lineNr;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }
}

