/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.conversion.gedcom.dq55;

import java.io.IOException;
import java.util.List;
import org.folg.gedcom.model.Family;
import org.folg.gedcom.model.Gedcom;
import org.folg.gedcom.model.Person;
import org.folg.gedcom.model.Repository;
import org.folg.gedcom.model.Source;
import org.gedcomx.conversion.DefaultGedcomxConversionResult;
import org.gedcomx.conversion.GedcomxConversionResult;
import org.gedcomx.conversion.gedcom.dq55.FamilyMapper;
import org.gedcomx.conversion.gedcom.dq55.PersonMapper;
import org.gedcomx.conversion.gedcom.dq55.SourceDescriptionMapper;
import org.gedcomx.conversion.gedcom.dq55.SubmitterMapper;

public class GedcomMapper {
    private final PersonMapper personMapper = new PersonMapper();
    private final FamilyMapper familyMapper = new FamilyMapper();
    private final SubmitterMapper submitterMapper = new SubmitterMapper();
    private final SourceDescriptionMapper sourceDescriptionMapper = new SourceDescriptionMapper();

    public GedcomxConversionResult toGedcomx(Gedcom dqGedcom) throws IOException {
        return this.toGedcomx(dqGedcom, new DefaultGedcomxConversionResult());
    }

    public GedcomxConversionResult toGedcomx(Gedcom dqGedcom, GedcomxConversionResult result) throws IOException {
        this.toPersons(dqGedcom.getPeople(), result);
        this.toRelationships(dqGedcom.getFamilies(), dqGedcom, result);
        this.toSourceDescriptions(dqGedcom.getSources(), result);
        this.toOrganizations(dqGedcom.getRepositories(), result);
        this.submitterMapper.toContributor(dqGedcom.getSubmitter(), result);
        return result;
    }

    void toPersons(List<Person> dqPersons, GedcomxConversionResult result) throws IOException {
        for (Person person : dqPersons) {
            this.personMapper.toPerson(person, result);
        }
    }

    private void toRelationships(List<Family> dqFamilies, Gedcom dqGedcom, GedcomxConversionResult result) throws IOException {
        for (Family family : dqFamilies) {
            this.familyMapper.toRelationship(family, dqGedcom, result);
        }
    }

    private void toSourceDescriptions(List<Source> dqSources, GedcomxConversionResult result) throws IOException {
        for (Source dqSource : dqSources) {
            this.sourceDescriptionMapper.toSourceDescription(dqSource, result);
        }
    }

    private void toOrganizations(List<Repository> dqRepositories, GedcomxConversionResult result) throws IOException {
        for (Repository dqRepository : dqRepositories) {
            this.sourceDescriptionMapper.toOrganization(dqRepository, result);
        }
    }
}

