/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.conversion.gedcom.dq55;

import java.io.IOException;
import java.util.List;
import org.folg.gedcom.model.GedcomTag;
import org.folg.gedcom.model.Submitter;
import org.gedcomx.agent.Agent;
import org.gedcomx.conversion.GedcomxConversionResult;
import org.gedcomx.conversion.gedcom.dq55.CommonMapper;
import org.gedcomx.conversion.gedcom.dq55.ConversionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class SubmitterMapper {
    private static final Logger logger = LoggerFactory.getLogger(CommonMapper.class);

    public void toContributor(Submitter dqSubmitter, GedcomxConversionResult result) throws IOException {
        Marker submitterContext = ConversionContext.getDetachedMarker(String.format("@%s@ SUBM", dqSubmitter.getId()));
        ConversionContext.addReference(submitterContext);
        Agent gedxContributor = new Agent();
        CommonMapper.populateAgent(gedxContributor, dqSubmitter.getId(), dqSubmitter.getName(), dqSubmitter.getAddress(), dqSubmitter.getPhone(), dqSubmitter.getFax(), dqSubmitter.getEmail(), dqSubmitter.getWww());
        if (dqSubmitter.getLanguage() != null) {
            logger.warn(ConversionContext.getContext(), "LANG ({}) was ignored.", (Object)dqSubmitter.getRin());
        }
        if (dqSubmitter.getRin() != null) {
            logger.warn(ConversionContext.getContext(), "RIN ({}) was ignored.", (Object)dqSubmitter.getRin());
        }
        if (dqSubmitter.getValue() != null) {
            logger.warn(ConversionContext.getContext(), "Unexpected submitter value ({}) was ignored.", (Object)dqSubmitter.getValue());
        }
        if (dqSubmitter.getExtensions().size() > 0) {
            for (String extensionCategory : dqSubmitter.getExtensions().keySet()) {
                for (GedcomTag tag : (List)dqSubmitter.getExtension(extensionCategory)) {
                    logger.warn(ConversionContext.getContext(), "Unsupported ({}): {}", (Object)extensionCategory, (Object)tag);
                }
            }
        }
        result.setDatasetContributor(gedxContributor);
        ConversionContext.removeReference(submitterContext);
    }
}

