/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.tools;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.jar.JarFile;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.smile.SmileFactory;
import org.folg.gedcom.model.Gedcom;
import org.folg.gedcom.parser.ModelParser;
import org.gedcomx.conversion.GedcomxConversionResult;
import org.gedcomx.conversion.gedcom.dq55.GedcomMapper;
import org.gedcomx.fileformat.DefaultXMLSerialization;
import org.gedcomx.fileformat.GedcomxEntrySerializer;
import org.gedcomx.fileformat.GedcomxFile;
import org.gedcomx.fileformat.GedcomxFileEntry;
import org.gedcomx.fileformat.GedcomxOutputStream;
import org.gedcomx.fileformat.GedcomxTimeStampUtil;
import org.gedcomx.fileformat.JacksonJsonSerialization;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.xml.sax.SAXParseException;

public class Gedcom2Gedcomx {
    @Option(name="-i", aliases={"--input"}, required=false, usage="GEDCOM 5.5 input file")
    private File gedcomIn;
    @Option(name="-ix", aliases={"--inputx"}, required=false, usage="GEDCOM X input file (experimental, used for benchmarking)")
    private File gedcomxIn;
    @Option(name="-o", aliases={"--output"}, required=false, usage="GEDCOM X output file")
    private File gedxOut;
    @Option(name="-js", aliases={"--json"}, required=false, usage="Use JSON instead of XML for serialization (experimental, used for proof-of-concept)")
    private boolean json;
    @Option(name="-bs", aliases={"--bson"}, required=false, usage="Use binary JSON instead of XML for serialization (experimental, used for proof-of-concept)")
    private boolean bson;
    @Option(name="-P", aliases={"--pause"}, required=false, usage="Pause before starting the conversion process (experimental, used for profiling)")
    private boolean pause;
    @Option(name="-v", aliases={"--verbose"}, required=false, usage="Output all the warnings that are generated during the conversion.")
    private boolean verbose;
    @Option(name="-vv", aliases={"--very-verbose"}, required=false, usage="Output all the warnings and informational messages that are generated during the conversion.")
    private boolean vverbose;

    private void doMain(CmdLineParser parser) throws SAXParseException, IOException {
        boolean gedcomInIsDirectory;
        String scanPattern;
        boolean gedxIn;
        if (this.verbose) {
            System.setProperty("gedcom-log-level", "WARN");
        }
        if (this.vverbose) {
            System.setProperty("gedcom-log-level", "INFO");
        }
        if (this.pause) {
            System.out.print("Press any key to continue...");
            System.in.read();
        }
        ArrayList<File> fileList = new ArrayList<File>();
        if (this.gedcomxIn != null) {
            gedxIn = true;
            scanPattern = "(?i).*\\.gedx$";
            this.gedcomIn = this.gedcomxIn;
        } else if (this.gedcomIn != null) {
            gedxIn = false;
            scanPattern = "(?i).*\\.ged$";
        } else {
            System.err.println("Input file(s) must be specified.");
            parser.printUsage((OutputStream)System.err);
            return;
        }
        if (this.gedcomIn != null && this.gedcomIn.isDirectory() && this.gedcomIn.canRead() && this.gedcomIn.canWrite() && this.gedcomIn.canExecute()) {
            fileList.addAll(Arrays.asList(this.gedcomIn.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getAbsolutePath().matches(scanPattern);
                }
            })));
            gedcomInIsDirectory = true;
        } else {
            fileList.add(this.gedcomIn);
            gedcomInIsDirectory = false;
        }
        boolean gedxOutIsDirectory = false;
        if (this.gedxOut != null && this.gedxOut.isDirectory() && gedcomInIsDirectory && this.gedxOut.canRead() && this.gedxOut.canWrite() && this.gedxOut.canExecute()) {
            gedxOutIsDirectory = true;
        }
        for (File inFile : fileList) {
            FileOutputStream outputStream;
            File derivedGedxOut;
            String directoryPart;
            String name = inFile.getName();
            int nameLength = name.length();
            if (gedcomInIsDirectory) {
                if (gedxOutIsDirectory) {
                    directoryPart = this.gedxOut.getAbsolutePath() + File.separatorChar;
                } else {
                    directoryPart = inFile.getAbsolutePath().substring(0, inFile.getAbsolutePath().length() - nameLength);
                    if (this.gedxOut != null) {
                        System.out.println("Application output parameter (-o) ignored.");
                    }
                }
                derivedGedxOut = new File(directoryPart + name.substring(0, nameLength - 4) + ".gedx");
            } else if (this.gedxOut == null) {
                directoryPart = inFile.getAbsolutePath().substring(0, inFile.getAbsolutePath().length() - nameLength);
                derivedGedxOut = new File(directoryPart + name.substring(0, nameLength - 4) + ".gedx");
            } else {
                derivedGedxOut = this.gedxOut;
            }
            try {
                outputStream = new FileOutputStream(derivedGedxOut);
            }
            catch (IOException ex) {
                outputStream = null;
                System.err.println("Failed to create the output file: " + derivedGedxOut);
            }
            if (gedxIn) {
                this.convertXFile(inFile, outputStream);
                continue;
            }
            this.convert55File(inFile, outputStream);
        }
    }

    private void convertXFile(File inFile, OutputStream outputStream) throws SAXParseException, IOException {
        GedcomxFile gxFile = new GedcomxFile(new JarFile(inFile), new Class[0]);
        GedcomxOutputStream out = new GedcomxOutputStream(outputStream, new Class[0]);
        Map attributes = gxFile.getAttributes();
        for (Map.Entry attribute : attributes.entrySet()) {
            out.addAttribute((String)attribute.getKey(), (String)attribute.getValue());
        }
        for (GedcomxFileEntry entry : gxFile.getEntries()) {
            if (entry.getJarEntry().isDirectory() || entry.getJarEntry().getName().endsWith("MANIFEST.MF")) continue;
            Object resource = gxFile.readResource(entry);
            String contentType = entry.getContentType();
            if (contentType == null) {
                contentType = "application/x-gedcomx-v1+xml";
            }
            out.addResource(contentType, entry.getJarEntry().getName(), resource, null, entry.getAttributes());
        }
        out.close();
    }

    private void convert55File(File inFile, OutputStream outputStream) throws SAXParseException, IOException {
        ModelParser modelParser = new ModelParser();
        Gedcom gedcom = modelParser.parseGedcom(inFile);
        gedcom.createIndexes();
        if (outputStream != null) {
            GedcomMapper mapper = new GedcomMapper();
            Object serializer = this.json ? new JacksonJsonSerialization(new Class[0]) : (this.bson ? new JacksonJsonSerialization((JsonFactory)new SmileFactory()) : new DefaultXMLSerialization(new Class[0]));
            GedcomxConversionResult result = mapper.toGedcomx(gedcom);
            GedcomxOutputStream output = new GedcomxOutputStream(outputStream, (GedcomxEntrySerializer)serializer);
            output.addAttribute("User-Agent", "Gedcom To Gedcomx Java Conversion Utility/1.0");
            output.addAttribute("X-DC-conformsTo", "http://gedcomx.org/file/v1");
            output.addAttribute("X-DC-created", GedcomxTimeStampUtil.formatAsXmlUTC((Date)new Date()));
            if (result.getDatasetContributor() != null && result.getDatasetContributor().getId() != null) {
                output.addAttribute("X-DC-creator", "tree.xml#" + result.getDatasetContributor().getId());
            }
            output.addResource("tree.xml", result.getDataset(), null);
            output.close();
        }
    }

    public static void main(String[] args) throws SAXParseException, IOException {
        Gedcom2Gedcomx converter = new Gedcom2Gedcomx();
        CmdLineParser parser = new CmdLineParser((Object)converter);
        try {
            parser.parseArgument(args);
            converter.doMain(parser);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser.printUsage((OutputStream)System.err);
        }
    }
}

