/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.date;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.gedcomx.date.GedcomxDate;
import org.gedcomx.date.GedcomxDateException;
import org.gedcomx.date.GedcomxDateType;
import org.gedcomx.date.GedcomxDateUtil;

public class GedcomxDateSimple
extends GedcomxDate {
    private Integer year = null;
    private Integer month = null;
    private Integer day = null;
    private Integer hours = null;
    private Integer minutes = null;
    private Integer seconds = null;
    private Integer tzHours = null;
    private Integer tzMinutes = null;

    public GedcomxDateSimple(String date) {
        this.parseDate(date);
    }

    private void parseDate(String date) {
        int i;
        if (date.length() < 5) {
            throw new GedcomxDateException("Invalid Date: Must have at least [+-]YYYY");
        }
        int end = date.length();
        int offset = 0;
        if (date.charAt(offset) != '+' && date.charAt(offset) != '-') {
            throw new GedcomxDateException("Invalid Date: Must begin with + or -");
        }
        ++offset;
        String num = date.charAt(0) == '-' ? "-" : "";
        for (i = 0; i < 4; ++i) {
            if (!Character.isDigit(date.charAt(offset))) {
                throw new GedcomxDateException("Invalid Date: Malformed Year");
            }
            num = num + date.charAt(offset++);
        }
        this.year = Integer.valueOf(num);
        if (this.year == 0) {
            throw new GedcomxDateException("Invalid Date: Year 0000 does not exist in Anno Domini (AD) system");
        }
        if (offset == end) {
            return;
        }
        if (date.charAt(offset) == 'T') {
            this.parseTime(date.substring(offset + 1));
            return;
        }
        if (date.charAt(offset) != '-') {
            throw new GedcomxDateException("Invalid Date: Invalid Year-Month Separator");
        }
        if (end - offset < 3) {
            throw new GedcomxDateException("Invalid Date: Month must be 2 digits");
        }
        ++offset;
        num = "";
        for (i = 0; i < 2; ++i) {
            if (!Character.isDigit(date.charAt(offset))) {
                throw new GedcomxDateException("Invalid Date: Malformed Month");
            }
            num = num + date.charAt(offset++);
        }
        this.month = Integer.valueOf(num);
        if (this.month < 1 || this.month > 12) {
            throw new GedcomxDateException("Invalid Date: Month must be between 1 and 12");
        }
        if (offset == end) {
            return;
        }
        if (date.charAt(offset) == 'T') {
            this.parseTime(date.substring(offset + 1));
            return;
        }
        if (date.charAt(offset) != '-') {
            throw new GedcomxDateException("Invalid Date: Invalid Month-Day Separator");
        }
        if (end - offset < 3) {
            throw new GedcomxDateException("Invalid Date: Day must be 2 digits");
        }
        ++offset;
        num = "";
        for (i = 0; i < 2; ++i) {
            if (!Character.isDigit(date.charAt(offset))) {
                throw new GedcomxDateException("Invalid Date: Malformed Day");
            }
            num = num + date.charAt(offset++);
        }
        this.day = Integer.valueOf(num);
        if (this.day < 1) {
            throw new GedcomxDateException("Invalid Date: Day 0 does not exist");
        }
        int daysInMonth = GedcomxDateUtil.daysInMonth(this.month, this.year);
        if (this.day > daysInMonth) {
            throw new GedcomxDateException("Invalid Date: There are only " + daysInMonth + " days in Month " + this.month + " year " + this.year);
        }
        if (offset == end) {
            return;
        }
        if (date.charAt(offset) != 'T') {
            throw new GedcomxDateException("Invalid Date: +YYYY-MM-DD must have T before time");
        }
        this.parseTime(date.substring(offset + 1));
    }

    private void parseTime(String date) {
        int i;
        int offset = 0;
        int end = date.length();
        boolean flag24 = false;
        TimeZone tz = TimeZone.getDefault();
        Calendar cal = GregorianCalendar.getInstance(tz);
        int offsetInMillis = tz.getOffset(cal.getTimeInMillis());
        this.tzHours = offsetInMillis / 3600000;
        this.tzMinutes = offsetInMillis / 60000 % 60;
        if (end < 2) {
            throw new GedcomxDateException("Invalid Date: Hours must be 2 digits");
        }
        String num = "";
        for (i = 0; i < 2; ++i) {
            if (!Character.isDigit(date.charAt(offset))) {
                throw new GedcomxDateException("Invalid Date: Malformed Hours");
            }
            num = num + date.charAt(offset++);
        }
        this.hours = Integer.valueOf(num);
        if (this.hours > 24) {
            throw new GedcomxDateException("Invalid Date: Hours must be between 0 and 24");
        }
        if (this.hours == 24) {
            flag24 = true;
        }
        if (offset == end) {
            return;
        }
        if (date.charAt(offset) == '+' || date.charAt(offset) == '-' || date.charAt(offset) == 'Z') {
            this.parseTimezone(date.substring(offset));
            return;
        }
        if (date.charAt(offset) != ':') {
            throw new GedcomxDateException("Invalid Date: Invalid Hour-Minute Separator");
        }
        if (end - offset < 3) {
            throw new GedcomxDateException("Invalid Date: Minutes must be 2 digits");
        }
        ++offset;
        num = "";
        for (i = 0; i < 2; ++i) {
            if (!Character.isDigit(date.charAt(offset))) {
                throw new GedcomxDateException("Invalid Date: Malformed Minutes");
            }
            num = num + date.charAt(offset++);
        }
        this.minutes = Integer.valueOf(num);
        if (this.minutes > 59) {
            throw new GedcomxDateException("Invalid Date: Minutes must be between 0 and 59");
        }
        if (flag24 && this.minutes != 0) {
            throw new GedcomxDateException("Invalid Date: Hours of 24 requires 00 Minutes");
        }
        if (offset == end) {
            return;
        }
        if (date.charAt(offset) == '+' || date.charAt(offset) == '-' || date.charAt(offset) == 'Z') {
            this.parseTimezone(date.substring(offset));
            return;
        }
        if (date.charAt(offset) != ':') {
            throw new GedcomxDateException("Invalid Date: Invalid Minute-Second Separator");
        }
        if (end - offset < 3) {
            throw new GedcomxDateException("Invalid Date: Seconds must be 2 digits");
        }
        ++offset;
        num = "";
        for (i = 0; i < 2; ++i) {
            if (!Character.isDigit(date.charAt(offset))) {
                throw new GedcomxDateException("Invalid Date: Malformed Seconds");
            }
            num = num + date.charAt(offset++);
        }
        this.seconds = Integer.valueOf(num);
        if (this.seconds > 59) {
            throw new GedcomxDateException("Invalid Date: Seconds must be between 0 and 59");
        }
        if (flag24 && this.seconds != 0) {
            throw new GedcomxDateException("Invalid Date: Hours of 24 requires 00 Seconds");
        }
        if (offset == end) {
            return;
        }
        this.parseTimezone(date.substring(offset));
    }

    private void parseTimezone(String date) {
        int i;
        int offset = 0;
        int end = date.length();
        if (date.charAt(offset) == 'Z') {
            if (end == 1) {
                this.tzHours = 0;
                this.tzMinutes = 0;
                return;
            }
            throw new GedcomxDateException("Invalid Date: Malformed Timezone - No Characters allowed after Z");
        }
        if (end - offset < 3) {
            throw new GedcomxDateException("Invalid Date: Malformed Timezone - tzHours must be [+-] followed by 2 digits");
        }
        if (date.charAt(offset) != '+' && date.charAt(offset) != '-') {
            throw new GedcomxDateException("Invalid Date: TimeZone Hours must begin with + or -");
        }
        ++offset;
        String num = date.charAt(0) == '-' ? "-" : "";
        for (i = 0; i < 2; ++i) {
            if (!Character.isDigit(date.charAt(offset))) {
                throw new GedcomxDateException("Invalid Date: Malformed tzHours");
            }
            num = num + date.charAt(offset++);
        }
        this.tzHours = Integer.valueOf(num);
        this.tzMinutes = 0;
        if (offset == end) {
            return;
        }
        if (date.charAt(offset) != ':') {
            throw new GedcomxDateException("Invalid Date: Invalid tzHour-tzMinute Separator");
        }
        if (end - offset < 3) {
            throw new GedcomxDateException("Invalid Date: tzSecond must be 2 digits");
        }
        ++offset;
        num = "";
        for (i = 0; i < 2; ++i) {
            if (!Character.isDigit(date.charAt(offset))) {
                throw new GedcomxDateException("Invalid Date: Malformed tzMinutes");
            }
            num = num + date.charAt(offset++);
        }
        this.tzMinutes = Integer.valueOf(num);
        if (offset == end) {
            return;
        }
        throw new GedcomxDateException("Invalid Date: Malformed Timezone - No characters allowed after tzSeconds");
    }

    @Override
    public GedcomxDateType getType() {
        return GedcomxDateType.SIMPLE;
    }

    @Override
    public boolean isApproximate() {
        return false;
    }

    @Override
    public String toFormalString() {
        StringBuilder simple = new StringBuilder();
        simple.append(this.year >= 0 ? "+" : "-").append(String.format("%04d", Math.abs(this.year)));
        if (this.month != null) {
            simple.append("-").append(String.format("%02d", this.month));
        }
        if (this.day != null) {
            simple.append("-").append(String.format("%02d", this.day));
        }
        if (this.hours != null) {
            simple.append("T").append(String.format("%02d", this.hours));
            if (this.minutes != null) {
                simple.append(":").append(String.format("%02d", this.minutes));
            }
            if (this.seconds != null) {
                simple.append(":").append(String.format("%02d", this.seconds));
            }
            if (this.tzHours == 0 && this.tzMinutes == 0) {
                simple.append("Z");
            } else {
                simple.append(this.tzHours >= 0 ? "+" : "-").append(String.format("%02d", Math.abs(this.tzHours)));
                simple.append(":").append(String.format("%02d", this.tzMinutes));
            }
        }
        return simple.toString();
    }

    public Integer getYear() {
        return this.year;
    }

    public Integer getMonth() {
        return this.month;
    }

    public Integer getDay() {
        return this.day;
    }

    public Integer getHours() {
        return this.hours;
    }

    public Integer getMinutes() {
        return this.minutes;
    }

    public Integer getSeconds() {
        return this.seconds;
    }

    public Integer getTzHours() {
        return this.tzHours;
    }

    public Integer getTzMinutes() {
        return this.tzMinutes;
    }
}

