/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.date;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import org.gedcomx.date.GedcomxDate;
import org.gedcomx.date.GedcomxDateApproximate;
import org.gedcomx.date.GedcomxDateDuration;
import org.gedcomx.date.GedcomxDateException;
import org.gedcomx.date.GedcomxDateRange;
import org.gedcomx.date.GedcomxDateRecurring;
import org.gedcomx.date.GedcomxDateSimple;

public class GedcomxDateUtil {
    private GedcomxDateUtil() {
    }

    public static GedcomxDate parse(String date) {
        if (date == null || date.isEmpty()) {
            throw new GedcomxDateException("Invalid Date");
        }
        if (date.charAt(0) == 'R') {
            return new GedcomxDateRecurring(date);
        }
        if (date.contains("/")) {
            return new GedcomxDateRange(date);
        }
        if (date.charAt(0) == 'A') {
            return new GedcomxDateApproximate(date);
        }
        return new GedcomxDateSimple(date);
    }

    public static GedcomxDateDuration getDuration(GedcomxDateSimple startDate, GedcomxDateSimple endDate) {
        Date date;
        if (startDate == null || endDate == null) {
            throw new GedcomxDateException("Start and End must be simple dates");
        }
        Date start = new Date(startDate, true);
        Date end = new Date(endDate, true);
        if (end.year - start.year < 0) {
            throw new GedcomxDateException("Start Date=" + startDate.toFormalString() + " must be less than End Date=" + endDate.toFormalString());
        }
        boolean hasTime = false;
        StringBuilder duration = new StringBuilder();
        GedcomxDateUtil.zipDates(start, end);
        if (end.seconds != null) {
            while (end.seconds - start.seconds < 0) {
                date = end;
                Integer.valueOf(date.minutes - 1);
                date.minutes = date.minutes;
                date = end;
                Integer.valueOf(date.seconds + 60);
                date.seconds = date.seconds;
            }
            if (end.seconds - start.seconds > 0) {
                hasTime = true;
                duration.insert(0, 'S').insert(0, String.format("%02d", end.seconds - start.seconds));
            }
        }
        if (end.minutes != null) {
            while (end.minutes - start.minutes < 0) {
                date = end;
                Integer.valueOf(date.hours - 1);
                date.hours = date.hours;
                date = end;
                Integer.valueOf(date.minutes + 60);
                date.minutes = date.minutes;
            }
            if (end.minutes - start.minutes > 0) {
                hasTime = true;
                duration.insert(0, 'M').insert(0, String.format("%02d", end.minutes - start.minutes));
            }
        }
        if (end.hours != null) {
            while (end.hours - start.hours < 0) {
                date = end;
                Integer.valueOf(date.day - 1);
                date.day = date.day;
                date = end;
                Integer.valueOf(date.hours + 24);
                date.hours = date.hours;
            }
            if (end.hours - start.hours > 0) {
                hasTime = true;
                duration.insert(0, 'H').insert(0, String.format("%02d", end.hours - start.hours));
            }
        }
        if (hasTime) {
            duration.insert(0, 'T');
        }
        if (end.day != null) {
            while (end.day - start.day < 0) {
                date = end;
                Integer.valueOf(date.day + GedcomxDateUtil.daysInMonth(end.month == 1 ? 12 : end.month - 1, end.year));
                date.day = date.day;
                date = end;
                Integer.valueOf(date.month - 1);
                date.month = date.month;
                if (end.month >= 1) continue;
                date = end;
                Integer.valueOf(date.year - 1);
                date.year = date.year;
                date = end;
                Integer.valueOf(date.month + 12);
                date.month = date.month;
            }
            if (end.day - start.day > 0) {
                duration.insert(0, 'D').insert(0, String.format("%02d", end.day - start.day));
            }
        }
        if (end.month != null) {
            while (end.month - start.month < 0) {
                date = end;
                Integer.valueOf(date.year - 1);
                date.year = date.year;
                date = end;
                Integer.valueOf(date.month + 12);
                date.month = date.month;
            }
            if (end.month - start.month > 0) {
                duration.insert(0, 'M').insert(0, String.format("%02d", end.month - start.month));
            }
        }
        if (end.year - start.year > 0) {
            duration.insert(0, 'Y').insert(0, String.format("%04d", end.year - start.year));
        }
        String finalDuration = duration.toString();
        if (end.year - start.year < 0 || duration.toString().isEmpty()) {
            throw new GedcomxDateException("Start Date must be less than End Date");
        }
        return new GedcomxDateDuration("P" + finalDuration);
    }

    public static GedcomxDateSimple addDuration(GedcomxDateSimple startDate, GedcomxDateDuration duration) {
        if (startDate == null) {
            throw new GedcomxDateException("Invalid Start Date");
        }
        if (duration == null) {
            throw new GedcomxDateException("Invalid Duration");
        }
        LocalDateTime endLocalDateTime = LocalDateTime.of((int)startDate.getYear(), Objects.isNull(startDate.getMonth()) ? 1 : startDate.getMonth(), Objects.isNull(startDate.getDay()) ? 1 : startDate.getDay(), Objects.isNull(startDate.getHours()) ? 0 : startDate.getHours(), Objects.isNull(startDate.getMinutes()) ? 0 : startDate.getMinutes(), Objects.isNull(startDate.getSeconds()) ? 0 : startDate.getSeconds()).plusSeconds(Objects.isNull(duration.getSeconds()) ? 0L : (long)duration.getSeconds().intValue()).plusMinutes(Objects.isNull(duration.getMinutes()) ? 0L : (long)duration.getMinutes().intValue()).plusHours(Objects.isNull(duration.getHours()) ? 0L : (long)duration.getHours().intValue()).plusDays(Objects.isNull(duration.getDays()) ? 0L : (long)duration.getDays().intValue()).plusMonths(Objects.isNull(duration.getMonths()) ? 0L : (long)duration.getMonths().intValue()).plusYears(Objects.isNull(duration.getYears()) ? 0L : (long)duration.getYears().intValue());
        if (endLocalDateTime.getYear() > 9999) {
            throw new GedcomxDateException("New date out of range");
        }
        return GedcomxDateUtil.buildGedcomxDateFromLocalTimeDate(startDate, duration, endLocalDateTime);
    }

    private static GedcomxDateSimple buildGedcomxDateFromLocalTimeDate(GedcomxDateSimple startDate, GedcomxDateDuration duration, LocalDateTime endLocalDateTime) {
        Integer endMonth = null;
        Integer endDay = null;
        Integer endHours = null;
        Integer endMinutes = null;
        Integer endSeconds = null;
        boolean foundDuration = false;
        if (Objects.nonNull(startDate.getSeconds()) || Objects.nonNull(duration.getSeconds())) {
            endSeconds = endLocalDateTime.getSecond();
            foundDuration = true;
        }
        if (foundDuration || Objects.nonNull(startDate.getMinutes()) || Objects.nonNull(duration.getMinutes())) {
            endMinutes = endLocalDateTime.getMinute();
            foundDuration = true;
        }
        if (foundDuration || Objects.nonNull(startDate.getHours()) || Objects.nonNull(duration.getHours())) {
            endHours = endLocalDateTime.getHour();
            foundDuration = true;
        }
        if (foundDuration || Objects.nonNull(startDate.getDay()) || Objects.nonNull(duration.getDays())) {
            endDay = endLocalDateTime.getDayOfMonth();
            foundDuration = true;
        }
        if (foundDuration || Objects.nonNull(startDate.getMonth()) || Objects.nonNull(duration.getMonths())) {
            endMonth = endLocalDateTime.getMonthValue();
        }
        return new GedcomxDateSimple(endLocalDateTime.getYear(), endMonth, endDay, endHours, endMinutes, endSeconds, startDate.getTzHours(), startDate.getTzMinutes());
    }

    public static GedcomxDateDuration multiplyDuration(GedcomxDateDuration duration, int multiplier) {
        if (duration == null) {
            throw new GedcomxDateException("Invalid Duration");
        }
        if (multiplier <= 0) {
            throw new GedcomxDateException("Invalid Multiplier");
        }
        StringBuilder newDuration = new StringBuilder("P");
        if (duration.getYears() != null) {
            newDuration.append(duration.getYears() * multiplier).append('Y');
        }
        if (duration.getMonths() != null) {
            newDuration.append(duration.getMonths() * multiplier).append('M');
        }
        if (duration.getDays() != null) {
            newDuration.append(duration.getDays() * multiplier).append('D');
        }
        if (duration.getHours() != null || duration.getMinutes() != null || duration.getSeconds() != null) {
            newDuration.append('T');
            if (duration.getHours() != null) {
                newDuration.append(duration.getHours() * multiplier).append('H');
            }
            if (duration.getMinutes() != null) {
                newDuration.append(duration.getMinutes() * multiplier).append('M');
            }
            if (duration.getSeconds() != null) {
                newDuration.append(duration.getSeconds() * multiplier).append('S');
            }
        }
        return new GedcomxDateDuration(newDuration.toString());
    }

    public static int daysInMonth(Integer month, Integer year) {
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
            case 2: {
                boolean leapYear;
                if (year % 4 != 0) {
                    leapYear = false;
                } else if (year % 100 != 0) {
                    leapYear = true;
                } else {
                    boolean bl = leapYear = year % 400 == 0;
                }
                if (leapYear) {
                    return 29;
                }
                return 28;
            }
        }
        throw new GedcomxDateException("Unknown Month=" + month);
    }

    protected static void zipDates(Date start, Date end) {
        if (start.month == null && end.month != null) {
            start.month = 1;
        }
        if (start.month != null && end.month == null) {
            end.month = 12;
        }
        if (start.day == null && end.day != null) {
            start.day = 1;
        }
        if (start.day != null && end.day == null) {
            end.day = end.month != null && end.year != null ? Integer.valueOf(GedcomxDateUtil.daysInMonth(start.month, start.year)) : start.day;
        }
        if (start.hours == null && end.hours != null) {
            start.hours = 0;
        }
        if (start.hours != null && end.hours == null) {
            end.hours = 23;
        }
        if (start.minutes == null && end.minutes != null) {
            start.minutes = 0;
        }
        if (start.minutes != null && end.minutes == null) {
            end.minutes = 59;
        }
        if (start.seconds == null && end.seconds != null) {
            start.seconds = 0;
        }
        if (start.seconds != null && end.seconds == null) {
            end.seconds = 59;
        }
    }

    public static GedcomxDateSimple javaDateToGedcomxDateSimple(java.util.Date javaDate) {
        String formattedDate = Optional.ofNullable(javaDate).map(date -> date.toInstant().truncatedTo(ChronoUnit.SECONDS)).map(DateTimeFormatter.ISO_INSTANT::format).map(formattedString -> formattedString.startsWith("-") ? formattedString : "+" + formattedString).orElseThrow(() -> new GedcomxDateException("javaDate cannot be null"));
        return new GedcomxDateSimple(formattedDate);
    }

    public static GedcomxDateRange javaDatesToGedcomxDateRange(java.util.Date fromDate, java.util.Date toDate) {
        String fromDateFormalString = Optional.ofNullable(fromDate).map(GedcomxDateUtil::javaDateToGedcomxDateSimple).map(GedcomxDate::toFormalString).orElseThrow(() -> new GedcomxDateException("fromDate cannot be null"));
        String toDateFormalString = Optional.ofNullable(toDate).map(GedcomxDateUtil::javaDateToGedcomxDateSimple).map(GedcomxDate::toFormalString).orElse("");
        return new GedcomxDateRange(fromDateFormalString + "/" + toDateFormalString);
    }

    protected static class Date {
        public Integer year = null;
        public Integer month = null;
        public Integer day = null;
        public Integer hours = null;
        public Integer minutes = null;
        public Integer seconds = null;

        public Date() {
        }

        public Date(GedcomxDateSimple simple, boolean adjustTimezone) {
            this.year = simple.getYear();
            this.month = simple.getMonth();
            this.day = simple.getDay();
            this.hours = simple.getHours();
            this.minutes = simple.getMinutes();
            this.seconds = simple.getSeconds();
            if (adjustTimezone) {
                if (this.hours != null && simple.getTzHours() != null) {
                    this.hours = this.hours + simple.getTzHours();
                }
                if (this.minutes != null && simple.getTzMinutes() != null) {
                    this.minutes = this.minutes + simple.getTzMinutes();
                }
            }
        }
    }
}

