/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.date;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.gedcomx.date.GedcomxDate;
import org.gedcomx.date.GedcomxDateException;
import org.gedcomx.date.GedcomxDateType;

public class GedcomxDateDuration
extends GedcomxDate {
    private Integer years = null;
    private Integer months = null;
    private Integer days = null;
    private Integer hours = null;
    private Integer minutes = null;
    private Integer seconds = null;

    public GedcomxDateDuration(String str) {
        if (str == null || str.length() < 1 || str.charAt(0) != 'P') {
            throw new GedcomxDateException("Invalid Duration: Must start with P");
        }
        String duration = str.substring(1);
        if (duration.length() < 1) {
            throw new GedcomxDateException("Invalid Duration: You must have a duration value");
        }
        if (duration.contains(" ")) {
            throw new GedcomxDateException("Invalid Duration: Non normalized durations are not implemented yet");
        }
        this.parseNormalizedDuration(duration);
    }

    private void parseNormalizedDuration(String duration) {
        String currentNum = "";
        boolean inTime = false;
        HashSet<String> seen = new HashSet<String>();
        List<String> valid = Arrays.asList("Y", "Mo", "D", "T", "H", "Mi", "S");
        block8: for (char character : duration.toCharArray()) {
            if (Character.isDigit(character)) {
                currentNum = currentNum + character;
                continue;
            }
            switch (character) {
                case 'Y': {
                    if (currentNum.length() < 1) {
                        throw new GedcomxDateException("Invalid Duration: Invalid years");
                    }
                    if (seen.contains("Y")) {
                        throw new GedcomxDateException("Invalid Duration: Duplicate years");
                    }
                    if (!valid.contains("Y")) {
                        throw new GedcomxDateException("Invalid Duration: Years out of order");
                    }
                    this.years = Integer.valueOf(currentNum);
                    seen.add("Y");
                    valid = valid.subList(valid.indexOf("Y") + 1, valid.size());
                    currentNum = "";
                    continue block8;
                }
                case 'M': {
                    if (inTime) {
                        if (currentNum.length() < 1) {
                            throw new GedcomxDateException("Invalid Duration: Invalid minutes");
                        }
                        if (seen.contains("Mi")) {
                            throw new GedcomxDateException("Invalid Duration: Duplicate minutes");
                        }
                        if (!valid.contains("Mi")) {
                            throw new GedcomxDateException("Invalid Duration: Minutes out of order");
                        }
                        this.minutes = Integer.valueOf(currentNum);
                        seen.add("Mi");
                        valid = valid.subList(valid.indexOf("Mi") + 1, valid.size());
                        currentNum = "";
                        continue block8;
                    }
                    if (currentNum.length() < 1) {
                        throw new GedcomxDateException("Invalid Duration: Invalid months");
                    }
                    if (seen.contains("Mo")) {
                        throw new GedcomxDateException("Invalid Duration: Duplicate months");
                    }
                    if (!valid.contains("Mo")) {
                        throw new GedcomxDateException("Invalid Duration: Months out of order");
                    }
                    this.months = Integer.valueOf(currentNum);
                    seen.add("Mo");
                    valid = valid.subList(valid.indexOf("Mo") + 1, valid.size());
                    currentNum = "";
                    continue block8;
                }
                case 'D': {
                    if (currentNum.length() < 1) {
                        throw new GedcomxDateException("Invalid Duration: Invalid days");
                    }
                    if (seen.contains("D")) {
                        throw new GedcomxDateException("Invalid Duration: Duplicate days");
                    }
                    if (!valid.contains("D")) {
                        throw new GedcomxDateException("Invalid Duration: Days out of order");
                    }
                    this.days = Integer.valueOf(currentNum);
                    seen.add("D");
                    valid = valid.subList(valid.indexOf("D") + 1, valid.size());
                    currentNum = "";
                    continue block8;
                }
                case 'H': {
                    if (!inTime) {
                        throw new GedcomxDateException("Invalid Duration: Missing T before hours");
                    }
                    if (currentNum.length() < 1) {
                        throw new GedcomxDateException("Invalid Duration: Invalid hours");
                    }
                    if (seen.contains("H")) {
                        throw new GedcomxDateException("Invalid Duration: Duplicate hours");
                    }
                    if (!valid.contains("H")) {
                        throw new GedcomxDateException("Invalid Duration: Hours out of order");
                    }
                    this.hours = Integer.valueOf(currentNum);
                    seen.add("H");
                    valid = valid.subList(valid.indexOf("H") + 1, valid.size());
                    currentNum = "";
                    continue block8;
                }
                case 'S': {
                    if (!inTime) {
                        throw new GedcomxDateException("Invalid Duration: Missing T before seconds");
                    }
                    if (currentNum.length() < 1) {
                        throw new GedcomxDateException("Invalid Duration: Invalid seconds");
                    }
                    if (seen.contains("S")) {
                        throw new GedcomxDateException("Invalid Duration: Duplicate seconds");
                    }
                    this.seconds = Integer.valueOf(currentNum);
                    seen.add("S");
                    valid = new ArrayList<String>();
                    currentNum = "";
                    continue block8;
                }
                case 'T': {
                    if (seen.contains("T")) {
                        throw new GedcomxDateException("Invalid Duration: Duplicate T");
                    }
                    inTime = true;
                    seen.add("T");
                    valid = valid.subList(valid.indexOf("T") + 1, valid.size());
                    continue block8;
                }
                default: {
                    throw new GedcomxDateException("Invalid Duration: Unknown letter " + character);
                }
            }
        }
        if (!currentNum.equals("")) {
            throw new GedcomxDateException("Invalid Duration: No letter after " + currentNum);
        }
    }

    @Override
    public GedcomxDateType getType() {
        return GedcomxDateType.DURATION;
    }

    @Override
    public boolean isApproximate() {
        return false;
    }

    @Override
    public String toFormalString() {
        StringBuilder duration = new StringBuilder("P");
        if (this.years != null) {
            duration.append(this.years).append('Y');
        }
        if (this.months != null) {
            duration.append(this.months).append('M');
        }
        if (this.days != null) {
            duration.append(this.days).append('D');
        }
        if (this.hours != null || this.minutes != null || this.seconds != null) {
            duration.append('T');
            if (this.hours != null) {
                duration.append(this.hours).append('H');
            }
            if (this.minutes != null) {
                duration.append(this.minutes).append('M');
            }
            if (this.seconds != null) {
                duration.append(this.seconds).append('S');
            }
        }
        return duration.toString();
    }

    public Integer getYears() {
        return this.years;
    }

    public Integer getMonths() {
        return this.months;
    }

    public Integer getDays() {
        return this.days;
    }

    public Integer getHours() {
        return this.hours;
    }

    public Integer getMinutes() {
        return this.minutes;
    }

    public Integer getSeconds() {
        return this.seconds;
    }
}

