/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.date;

import java.time.DateTimeException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.gedcomx.date.GedcomxDate;
import org.gedcomx.date.GedcomxDateApproximate;
import org.gedcomx.date.GedcomxDateDuration;
import org.gedcomx.date.GedcomxDateException;
import org.gedcomx.date.GedcomxDateRange;
import org.gedcomx.date.GedcomxDateRecurring;
import org.gedcomx.date.GedcomxDateSimple;

public class GedcomxDateUtil {
    private GedcomxDateUtil() {
    }

    public static GedcomxDate parse(String date) {
        if (date == null || date.isEmpty()) {
            throw new GedcomxDateException("Invalid Date");
        }
        GedcomxDate retVal = date.charAt(0) == 'R' ? new GedcomxDateRecurring(date) : (date.contains("/") ? new GedcomxDateRange(date) : (date.charAt(0) == 'A' ? new GedcomxDateApproximate(date) : new GedcomxDateSimple(date)));
        return retVal;
    }

    public static GedcomxDateDuration getDuration(GedcomxDateSimple startDate, GedcomxDateSimple endDate) {
        if (startDate == null || endDate == null) {
            throw new GedcomxDateException("Start and End must be simple dates");
        }
        LocalDateTime start = GedcomxDateUtil.getMinLocalDateTime(startDate);
        LocalDateTime end = GedcomxDateUtil.getMaxLocalDateTime(endDate);
        Period p = Period.between(start.toLocalDate(), end.toLocalDate());
        Duration d = Duration.between(start.toLocalTime(), end.toLocalTime());
        if (d.isNegative()) {
            p = p.minusDays(1L);
            d = d.plusDays(1L);
        }
        if (p.isNegative() || p.isZero() && d.isNegative()) {
            throw new GedcomxDateException(String.format("Start Date=%s must be less than End Date=%s", startDate.toFormalString(), endDate.toFormalString()));
        }
        String finalDuration = GedcomxDateUtil.createDurationStringFromJavaTimeParts(p, d);
        if ("P".equals(finalDuration)) {
            throw new GedcomxDateException("The start and end are equal yielding no duration.");
        }
        return new GedcomxDateDuration(finalDuration);
    }

    private static String createDurationStringFromJavaTimeParts(Period p, Duration d) {
        StringBuilder duration = new StringBuilder("P");
        if (!p.isZero()) {
            if (p.getYears() > 0) {
                duration.append(p.getYears()).append('Y');
            }
            if (p.getMonths() > 0) {
                duration.append(p.getMonths()).append('M');
            }
            if (p.getDays() > 0) {
                duration.append(p.getDays()).append('D');
            }
        }
        if (!d.isZero()) {
            duration.append('T');
            if (d.toHours() > 0L) {
                duration.append(d.toHours()).append('H');
            }
            if (d.toMinutes() % 60L > 0L) {
                duration.append(d.toMinutes() % 60L).append('M');
            }
            if (d.toMillis() / 1000L % 60L > 0L) {
                duration.append(d.toMillis() / 1000L % 60L).append('S');
            }
        }
        return duration.toString();
    }

    private static LocalDateTime getMinLocalDateTime(GedcomxDateSimple startDate) {
        return LocalDateTime.of(Objects.isNull(startDate.getYear()) ? -9999 : startDate.getYear(), Objects.isNull(startDate.getMonth()) ? 1 : startDate.getMonth(), Objects.isNull(startDate.getDay()) ? 1 : startDate.getDay(), Objects.isNull(startDate.getHours()) ? 0 : startDate.getHours(), Objects.isNull(startDate.getMinutes()) ? 0 : startDate.getMinutes(), Objects.isNull(startDate.getSeconds()) ? 0 : startDate.getSeconds());
    }

    private static LocalDateTime getMaxLocalDateTime(GedcomxDateSimple endDate) {
        int endMonth;
        int endYear = Objects.isNull(endDate.getYear()) ? 9999 : endDate.getYear();
        LocalDateTime end = LocalDateTime.of(endYear, endMonth = Objects.isNull(endDate.getMonth()) ? 12 : endDate.getMonth(), Objects.isNull(endDate.getDay()) ? YearMonth.of(endYear, endMonth).lengthOfMonth() : endDate.getDay().intValue(), Objects.isNull(endDate.getHours()) ? 23 : endDate.getHours(), Objects.isNull(endDate.getMinutes()) ? 59 : endDate.getMinutes(), Objects.isNull(endDate.getSeconds()) ? 59 : endDate.getSeconds());
        if (end.getSecond() == 59) {
            end = end.plusSeconds(1L);
        }
        return end;
    }

    public static GedcomxDateSimple addDuration(GedcomxDateSimple startDate, GedcomxDateDuration duration) {
        if (startDate == null) {
            throw new GedcomxDateException("Invalid Start Date");
        }
        if (duration == null) {
            throw new GedcomxDateException("Invalid Duration");
        }
        LocalDateTime endLocalDateTime = GedcomxDateUtil.getMinLocalDateTime(startDate).plusSeconds(Objects.isNull(duration.getSeconds()) ? 0L : (long)duration.getSeconds().intValue()).plusMinutes(Objects.isNull(duration.getMinutes()) ? 0L : (long)duration.getMinutes().intValue()).plusHours(Objects.isNull(duration.getHours()) ? 0L : (long)duration.getHours().intValue()).plusDays(Objects.isNull(duration.getDays()) ? 0L : (long)duration.getDays().intValue()).plusMonths(Objects.isNull(duration.getMonths()) ? 0L : (long)duration.getMonths().intValue()).plusYears(Objects.isNull(duration.getYears()) ? 0L : (long)duration.getYears().intValue());
        if (endLocalDateTime.getYear() > 9999) {
            throw new GedcomxDateException("New date out of range");
        }
        return GedcomxDateUtil.buildGedcomxDateFromLocalTimeDate(startDate, duration, endLocalDateTime);
    }

    private static GedcomxDateSimple buildGedcomxDateFromLocalTimeDate(GedcomxDateSimple startDate, GedcomxDateDuration duration, LocalDateTime endLocalDateTime) {
        Integer endMonth = null;
        Integer endDay = null;
        Integer endHours = null;
        Integer endMinutes = null;
        Integer endSeconds = null;
        boolean foundDuration = false;
        if (Objects.nonNull(startDate.getSeconds()) || Objects.nonNull(duration.getSeconds())) {
            endSeconds = endLocalDateTime.getSecond();
            foundDuration = true;
        }
        if (foundDuration || Objects.nonNull(startDate.getMinutes()) || Objects.nonNull(duration.getMinutes())) {
            endMinutes = endLocalDateTime.getMinute();
            foundDuration = true;
        }
        if (foundDuration || Objects.nonNull(startDate.getHours()) || Objects.nonNull(duration.getHours())) {
            endHours = endLocalDateTime.getHour();
            foundDuration = true;
        }
        if (foundDuration || Objects.nonNull(startDate.getDay()) || Objects.nonNull(duration.getDays())) {
            endDay = endLocalDateTime.getDayOfMonth();
            foundDuration = true;
        }
        if (foundDuration || Objects.nonNull(startDate.getMonth()) || Objects.nonNull(duration.getMonths())) {
            endMonth = endLocalDateTime.getMonthValue();
        }
        return new GedcomxDateSimple(endLocalDateTime.getYear(), endMonth, endDay, endHours, endMinutes, endSeconds, startDate.getTzHours(), startDate.getTzMinutes());
    }

    public static GedcomxDateDuration multiplyDuration(GedcomxDateDuration duration, int multiplier) {
        if (duration == null) {
            throw new GedcomxDateException("Invalid Duration");
        }
        if (multiplier <= 0) {
            throw new GedcomxDateException("Invalid Multiplier");
        }
        StringBuilder newDuration = new StringBuilder("P");
        if (duration.getYears() != null) {
            newDuration.append(duration.getYears() * multiplier).append('Y');
        }
        if (duration.getMonths() != null) {
            newDuration.append(duration.getMonths() * multiplier).append('M');
        }
        if (duration.getDays() != null) {
            newDuration.append(duration.getDays() * multiplier).append('D');
        }
        if (duration.getHours() != null || duration.getMinutes() != null || duration.getSeconds() != null) {
            newDuration.append('T');
            if (duration.getHours() != null) {
                newDuration.append(duration.getHours() * multiplier).append('H');
            }
            if (duration.getMinutes() != null) {
                newDuration.append(duration.getMinutes() * multiplier).append('M');
            }
            if (duration.getSeconds() != null) {
                newDuration.append(duration.getSeconds() * multiplier).append('S');
            }
        }
        return new GedcomxDateDuration(newDuration.toString());
    }

    @Deprecated
    public static int daysInMonth(Integer month, Integer year) {
        try {
            return YearMonth.of((int)year, month).lengthOfMonth();
        }
        catch (DateTimeException e) {
            throw new GedcomxDateException(e.getMessage(), e);
        }
    }

    public static GedcomxDateSimple javaDateToGedcomxDateSimple(Date javaDate) {
        String formattedDate = Optional.ofNullable(javaDate).map(date -> date.toInstant().truncatedTo(ChronoUnit.SECONDS)).map(DateTimeFormatter.ISO_INSTANT::format).map(formattedString -> formattedString.startsWith("-") ? formattedString : "+" + formattedString).orElseThrow(() -> new GedcomxDateException("javaDate cannot be null"));
        return new GedcomxDateSimple(formattedDate);
    }

    public static GedcomxDateRange javaDatesToGedcomxDateRange(Date fromDate, Date toDate) {
        String fromDateFormalString = Optional.ofNullable(fromDate).map(GedcomxDateUtil::javaDateToGedcomxDateSimple).map(GedcomxDate::toFormalString).orElseThrow(() -> new GedcomxDateException("fromDate cannot be null"));
        String toDateFormalString = Optional.ofNullable(toDate).map(GedcomxDateUtil::javaDateToGedcomxDateSimple).map(GedcomxDate::toFormalString).orElse("");
        return new GedcomxDateRange(fromDateFormalString + "/" + toDateFormalString);
    }
}

