/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.date;

import org.gedcomx.date.GedcomxDate;
import org.gedcomx.date.GedcomxDateException;
import org.gedcomx.date.GedcomxDateSimple;
import org.gedcomx.date.GedcomxDateType;

public class GedcomxDateApproximate
extends GedcomxDate {
    private GedcomxDateSimple simpleDate;

    public GedcomxDateApproximate(String date) {
        if (date == null || date.length() < 1 || date.charAt(0) != 'A') {
            throw new GedcomxDateException("Invalid Approximate Date: Must start with A");
        }
        this.simpleDate = new GedcomxDateSimple(date.substring(1));
    }

    public GedcomxDateSimple getSimpleDate() {
        return this.simpleDate;
    }

    @Override
    public GedcomxDateType getType() {
        return GedcomxDateType.APPROXIMATE;
    }

    @Override
    public boolean isApproximate() {
        return true;
    }

    @Override
    public String toFormalString() {
        return "A" + this.simpleDate.toFormalString();
    }

    public Integer getYear() {
        return this.simpleDate.getYear();
    }

    public Integer getMonth() {
        return this.simpleDate.getMonth();
    }

    public Integer getDay() {
        return this.simpleDate.getDay();
    }

    public Integer getHours() {
        return this.simpleDate.getHours();
    }

    public Integer getMinutes() {
        return this.simpleDate.getMinutes();
    }

    public Integer getSeconds() {
        return this.simpleDate.getSeconds();
    }

    public Integer getTzHours() {
        return this.simpleDate.getTzHours();
    }

    public Integer getTzMinutes() {
        return this.simpleDate.getTzMinutes();
    }
}

