/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.conclusion;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.XmlQNameEnumUtil;
import org.codehaus.enunciate.json.JsonName;
import org.codehaus.enunciate.qname.XmlQNameEnumRef;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gedcomx.common.Attribution;
import org.gedcomx.common.EvidenceReference;
import org.gedcomx.common.Note;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.Date;
import org.gedcomx.conclusion.Document;
import org.gedcomx.conclusion.EventRole;
import org.gedcomx.conclusion.HasDateAndPlace;
import org.gedcomx.conclusion.Identifier;
import org.gedcomx.conclusion.PlaceReference;
import org.gedcomx.conclusion.Subject;
import org.gedcomx.links.Link;
import org.gedcomx.rt.GedcomxModelVisitor;
import org.gedcomx.rt.json.JsonElementWrapper;
import org.gedcomx.source.SourceDescription;
import org.gedcomx.source.SourceReference;
import org.gedcomx.types.ConfidenceLevel;
import org.gedcomx.types.EventType;

@XmlRootElement
@JsonElementWrapper(name="events")
@XmlType(name="Event", propOrder={"date", "place", "roles"})
@Facet(name="https://familysearch.org/tree#UNSUPPORTED")
public class Event
extends Subject
implements HasDateAndPlace {
    private URI type;
    private Date date;
    private PlaceReference place;
    private List<EventRole> roles;

    public Event() {
    }

    public Event(EventType EventType2) {
        this.setKnownType(EventType2);
    }

    public Event(EventType EventType2, Date date, PlaceReference place) {
        this.setKnownType(EventType2);
        this.setDate(date);
        this.setPlace(place);
    }

    @Override
    public Event id(String id) {
        return (Event)super.id(id);
    }

    @Override
    public Event link(String rel, URI href) {
        return (Event)super.link(rel, href);
    }

    @Override
    public Event link(Link link) {
        return (Event)super.link(link);
    }

    @Override
    public Event lang(String lang) {
        return (Event)super.lang(lang);
    }

    @Override
    public Event confidence(URI confidence) {
        return (Event)super.confidence(confidence);
    }

    @Override
    public Event confidence(ConfidenceLevel confidence) {
        return (Event)super.confidence(confidence);
    }

    @Override
    public Event source(SourceReference sourceReference) {
        return (Event)super.source(sourceReference);
    }

    @Override
    public Event source(SourceDescription source) {
        return (Event)super.source(source);
    }

    @Override
    public Event note(Note note) {
        return (Event)super.note(note);
    }

    @Override
    public Event analysis(ResourceReference analysis) {
        return (Event)super.analysis(analysis);
    }

    @Override
    public Event attribution(Attribution attribution) {
        return (Event)super.attribution(attribution);
    }

    @Override
    public Event analysis(Document analysis) {
        return (Event)super.analysis(analysis);
    }

    @Override
    public Event analysis(URI analysis) {
        return (Event)super.analysis(analysis);
    }

    @Override
    public Event extracted(Boolean extracted) {
        return (Event)super.extracted(extracted);
    }

    @Override
    public Event identifier(Identifier identifier) {
        return (Event)super.identifier(identifier);
    }

    @Override
    public Event evidence(EvidenceReference evidence) {
        return (Event)super.evidence(evidence);
    }

    @Override
    public Event sortKey(String sortKey) {
        return (Event)super.sortKey(sortKey);
    }

    public Event evidence(Event evidence) {
        if (evidence.getId() == null) {
            throw new IllegalArgumentException("Unable to add event as evidence: no id.");
        }
        return (Event)super.evidence(new EvidenceReference(URI.create("#" + evidence.getId())));
    }

    @Override
    public Event media(SourceReference media) {
        return (Event)super.media(media);
    }

    @Override
    public Event media(SourceDescription media) {
        return (Event)super.media(media);
    }

    @XmlAttribute
    @XmlQNameEnumRef(value=EventType.class)
    public URI getType() {
        return this.type;
    }

    public void setType(URI type) {
        this.type = type;
    }

    public Event type(URI type) {
        this.setType(type);
        return this;
    }

    public Event type(EventType type) {
        this.setKnownType(type);
        return this;
    }

    @XmlTransient
    @JsonIgnore
    public EventType getKnownType() {
        return this.getType() == null ? null : EventType.fromQNameURI(this.getType());
    }

    @JsonIgnore
    public void setKnownType(EventType knownType) {
        this.setType(knownType == null ? null : URI.create(XmlQNameEnumUtil.toURIValue((Enum)knownType)));
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    public Event date(Date date) {
        this.setDate(date);
        return this;
    }

    @Override
    public PlaceReference getPlace() {
        return this.place;
    }

    @Override
    public void setPlace(PlaceReference place) {
        this.place = place;
    }

    public Event place(PlaceReference place) {
        this.setPlace(place);
        return this;
    }

    @XmlElement(name="role")
    @JsonProperty(value="roles")
    @JsonName(value="roles")
    public List<EventRole> getRoles() {
        return this.roles;
    }

    public void setRoles(List<EventRole> roles) {
        this.roles = roles;
    }

    public Event role(EventRole role) {
        this.addRole(role);
        return this;
    }

    public void addRole(EventRole role) {
        if (role != null) {
            if (this.roles == null) {
                this.roles = new LinkedList<EventRole>();
            }
            this.roles.add(role);
        }
    }

    public void accept(GedcomxModelVisitor visitor) {
        visitor.visitEvent(this);
    }

    public void embed(Event event) {
        this.type = this.type == null ? event.type : this.type;
        this.date = this.date == null ? event.date : this.date;
        PlaceReference placeReference = this.place = this.place == null ? event.place : this.place;
        if (event.roles != null) {
            this.roles = this.roles == null ? new ArrayList() : this.roles;
            this.roles.addAll(event.roles);
        }
        super.embed(event);
    }
}

