/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.conclusion;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.XmlQNameEnumUtil;
import org.codehaus.enunciate.json.JsonName;
import org.codehaus.enunciate.qname.XmlQNameEnumRef;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gedcomx.common.Attribution;
import org.gedcomx.common.Note;
import org.gedcomx.common.Qualifier;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.Conclusion;
import org.gedcomx.conclusion.Date;
import org.gedcomx.conclusion.Document;
import org.gedcomx.conclusion.HasDateAndPlace;
import org.gedcomx.conclusion.PlaceReference;
import org.gedcomx.links.Link;
import org.gedcomx.records.Field;
import org.gedcomx.records.HasFields;
import org.gedcomx.rt.GedcomxModelVisitor;
import org.gedcomx.rt.json.JsonElementWrapper;
import org.gedcomx.source.SourceDescription;
import org.gedcomx.source.SourceReference;
import org.gedcomx.types.ConfidenceLevel;
import org.gedcomx.types.FactType;

@XmlType(name="Fact", propOrder={"date", "place", "value", "qualifiers", "fields"})
@XmlRootElement
@JsonElementWrapper(name="facts")
public class Fact
extends Conclusion
implements HasDateAndPlace,
HasFields {
    private URI type;
    private Date date;
    private PlaceReference place;
    private String value;
    private List<Qualifier> qualifiers;
    private List<Field> fields;
    private Boolean primary;

    public Fact() {
    }

    public Fact(FactType factType, String value) {
        this.setKnownType(factType);
        this.setValue(value);
    }

    public Fact(FactType factType, String date, String place) {
        this(factType, new Date().original(date), new PlaceReference().original(place), null);
    }

    public Fact(FactType factType, Date date, PlaceReference place) {
        this(factType, date, place, null);
    }

    public Fact(FactType factType, Date date, PlaceReference place, String value) {
        this.setKnownType(factType);
        this.setDate(date);
        this.setPlace(place);
        this.setValue(value);
    }

    @Override
    public Fact id(String id) {
        return (Fact)super.id(id);
    }

    @Override
    public Fact link(String rel, URI href) {
        return (Fact)super.link(rel, href);
    }

    @Override
    public Fact link(Link link) {
        return (Fact)super.link(link);
    }

    @Override
    public Fact lang(String lang) {
        return (Fact)super.lang(lang);
    }

    @Override
    public Fact confidence(URI confidence) {
        return (Fact)super.confidence(confidence);
    }

    @Override
    public Fact confidence(ConfidenceLevel confidence) {
        return (Fact)super.confidence(confidence);
    }

    @Override
    public Fact source(SourceReference sourceReference) {
        return (Fact)super.source(sourceReference);
    }

    @Override
    public Fact source(SourceDescription source) {
        return (Fact)super.source(source);
    }

    @Override
    public Fact note(Note note) {
        return (Fact)super.note(note);
    }

    @Override
    public Fact attribution(Attribution attribution) {
        return (Fact)super.attribution(attribution);
    }

    @Override
    public Fact analysis(ResourceReference analysis) {
        return (Fact)super.analysis(analysis);
    }

    @Override
    public Fact analysis(Document analysis) {
        return (Fact)super.analysis(analysis);
    }

    @Override
    public Fact analysis(URI analysis) {
        return (Fact)super.analysis(analysis);
    }

    @Override
    public Fact sortKey(String sortKey) {
        return (Fact)super.sortKey(sortKey);
    }

    @XmlAttribute
    @XmlQNameEnumRef(value=FactType.class)
    public URI getType() {
        return this.type;
    }

    public void setType(URI type) {
        this.type = type;
    }

    public Fact type(URI type) {
        this.setType(type);
        return this;
    }

    public Fact type(FactType type) {
        this.setKnownType(type);
        return this;
    }

    @XmlTransient
    @JsonIgnore
    public FactType getKnownType() {
        return this.getType() == null ? null : FactType.fromQNameURI(this.getType());
    }

    @JsonIgnore
    public void setKnownType(FactType knownType) {
        this.setType(knownType == null ? null : URI.create(XmlQNameEnumUtil.toURIValue((Enum)knownType)));
    }

    @XmlAttribute
    @Facet(name="http://record.gedcomx.org/")
    public Boolean getPrimary() {
        return this.primary;
    }

    public void setPrimary(Boolean primary) {
        this.primary = primary;
    }

    public Fact primary(Boolean primary) {
        this.setPrimary(primary);
        return this;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    public Fact date(Date date) {
        this.setDate(date);
        return this;
    }

    @Override
    public PlaceReference getPlace() {
        return this.place;
    }

    @Override
    public void setPlace(PlaceReference place) {
        this.place = place;
    }

    public Fact place(PlaceReference place) {
        this.setPlace(place);
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Fact value(String value) {
        this.setValue(value);
        return this;
    }

    @XmlElement(name="qualifier")
    @JsonName(value="qualifiers")
    @JsonProperty(value="qualifiers")
    @Facet(name="https://familysearch.org/tree#UNSUPPORTED")
    public List<Qualifier> getQualifiers() {
        return this.qualifiers;
    }

    @JsonProperty(value="qualifiers")
    public void setQualifiers(List<Qualifier> qualifiers) {
        this.qualifiers = qualifiers;
    }

    public Fact qualifier(Qualifier qualifier) {
        this.addQualifier(qualifier);
        return this;
    }

    public void addQualifier(Qualifier qualifier) {
        if (this.qualifiers == null) {
            this.qualifiers = new ArrayList<Qualifier>();
        }
        this.qualifiers.add(qualifier);
    }

    @Override
    @XmlElement(name="field")
    @JsonProperty(value="fields")
    @JsonName(value="fields")
    @Facet(name="http://record.gedcomx.org/")
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    @JsonProperty(value="fields")
    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public Fact field(Field field) {
        this.addField(field);
        return this;
    }

    public void addField(Field field) {
        if (field != null) {
            if (this.fields == null) {
                this.fields = new LinkedList<Field>();
            }
            this.fields.add(field);
        }
    }

    @Override
    public String toString() {
        return "type=" + (Object)((Object)this.getKnownType()) + ",value=" + this.getValue() + ",date=" + this.getDate() + ",place=" + this.getPlace();
    }

    public void accept(GedcomxModelVisitor visitor) {
        visitor.visitFact(this);
    }
}

