/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.conclusion;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.json.JsonName;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gedcomx.common.Attribution;
import org.gedcomx.common.EvidenceReference;
import org.gedcomx.common.Note;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.DisplayProperties;
import org.gedcomx.conclusion.Document;
import org.gedcomx.conclusion.Fact;
import org.gedcomx.conclusion.Gender;
import org.gedcomx.conclusion.HasFacts;
import org.gedcomx.conclusion.Identifier;
import org.gedcomx.conclusion.Name;
import org.gedcomx.conclusion.NameForm;
import org.gedcomx.conclusion.Subject;
import org.gedcomx.links.Link;
import org.gedcomx.records.Field;
import org.gedcomx.records.HasFields;
import org.gedcomx.rt.GedcomxModelVisitor;
import org.gedcomx.rt.json.JsonElementWrapper;
import org.gedcomx.source.SourceDescription;
import org.gedcomx.source.SourceReference;
import org.gedcomx.types.ConfidenceLevel;
import org.gedcomx.types.FactType;
import org.gedcomx.types.GenderType;
import org.gedcomx.types.NameType;

@XmlRootElement
@JsonElementWrapper(name="persons")
@XmlType(name="Person", propOrder={"private", "living", "principal", "gender", "names", "facts", "fields", "displayExtension"})
public class Person
extends Subject
implements HasFacts,
HasFields {
    private Boolean isPrivate;
    private Boolean living;
    private Boolean principal;
    private Gender gender;
    private List<Name> names;
    private List<Fact> facts;
    private List<Field> fields;
    private DisplayProperties display;

    @Override
    public Person id(String id) {
        return (Person)super.id(id);
    }

    @Override
    public Person link(String rel, URI href) {
        return (Person)super.link(rel, href);
    }

    @Override
    public Person link(Link link) {
        return (Person)super.link(link);
    }

    @Override
    public Person lang(String lang) {
        return (Person)super.lang(lang);
    }

    @Override
    public Person confidence(URI confidence) {
        return (Person)super.confidence(confidence);
    }

    @Override
    public Person confidence(ConfidenceLevel confidence) {
        return (Person)super.confidence(confidence);
    }

    @Override
    public Person source(SourceReference sourceReference) {
        return (Person)super.source(sourceReference);
    }

    @Override
    public Person source(SourceDescription source) {
        return (Person)super.source(source);
    }

    @Override
    public Person note(Note note) {
        return (Person)super.note(note);
    }

    @Override
    public Person analysis(ResourceReference analysis) {
        return (Person)super.analysis(analysis);
    }

    @Override
    public Person attribution(Attribution attribution) {
        return (Person)super.attribution(attribution);
    }

    @Override
    public Person analysis(Document analysis) {
        return (Person)super.analysis(analysis);
    }

    @Override
    public Person analysis(URI analysis) {
        return (Person)super.analysis(analysis);
    }

    @Override
    public Person extracted(Boolean extracted) {
        return (Person)super.extracted(extracted);
    }

    @Override
    public Person identifier(Identifier identifier) {
        return (Person)super.identifier(identifier);
    }

    @Override
    public Person evidence(EvidenceReference evidence) {
        return (Person)super.evidence(evidence);
    }

    public Person evidence(Person evidence) {
        if (evidence.getId() == null) {
            throw new IllegalArgumentException("Unable to add person as evidence: no id.");
        }
        return (Person)super.evidence(new EvidenceReference(URI.create("#" + evidence.getId())));
    }

    @XmlTransient
    @JsonIgnore
    public List<EvidenceReference> getPersonaReferences() {
        return this.getEvidence();
    }

    @JsonIgnore
    public void setPersonaReferences(List<EvidenceReference> refs) {
        this.setEvidence(refs);
    }

    public Subject personaReference(EvidenceReference persona) {
        this.addEvidence(persona);
        return this;
    }

    public void addPersona(EvidenceReference personaRef) {
        this.addEvidence(personaRef);
    }

    @Override
    public Person media(SourceReference media) {
        return (Person)super.media(media);
    }

    @Override
    public Person media(SourceDescription media) {
        return (Person)super.media(media);
    }

    @Override
    public Person sortKey(String sortKey) {
        return (Person)super.sortKey(sortKey);
    }

    @XmlAttribute
    public Boolean getPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(Boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    @Facet(name="https://familysearch.org/tree#READ_ONLY")
    public Boolean getLiving() {
        return this.living;
    }

    public void setLiving(Boolean living) {
        this.living = living;
    }

    public Person living(Boolean living) {
        this.setLiving(living);
        return this;
    }

    @XmlAttribute
    @Facet(name="http://record.gedcomx.org/")
    public Boolean getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    public Person principal(Boolean principal) {
        this.setPrincipal(principal);
        return this;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public Person gender(Gender gender) {
        this.setGender(gender);
        return this;
    }

    public Person gender(GenderType gender) {
        this.setGender(new Gender().type(gender));
        return this;
    }

    @XmlElement(name="name")
    @JsonProperty(value="names")
    @JsonName(value="names")
    public List<Name> getNames() {
        return this.names;
    }

    @XmlTransient
    @JsonIgnore
    public Name getName() {
        return this.names != null && this.names.size() > 0 ? this.names.get(0) : null;
    }

    @JsonIgnore
    public Name getFirstNameOfType(NameType type) {
        if (this.names == null) {
            return null;
        }
        for (Name name : this.names) {
            if (!type.equals((Object)name.getKnownType())) continue;
            return name;
        }
        return null;
    }

    @JsonProperty(value="names")
    public void setNames(List<Name> names) {
        this.names = names;
    }

    public Person name(Name name) {
        this.addName(name);
        return this;
    }

    public Person name(String name) {
        this.addName(new Name().nameForm(new NameForm().fullText(name)));
        return this;
    }

    public void addName(Name name) {
        if (name != null) {
            if (this.names == null) {
                this.names = new LinkedList<Name>();
            }
            this.names.add(name);
        }
    }

    @Override
    @XmlElement(name="fact")
    @JsonProperty(value="facts")
    @JsonName(value="facts")
    public List<Fact> getFacts() {
        return this.facts;
    }

    @JsonIgnore
    public Fact getFirstFactOfType(FactType type) {
        if (this.facts == null) {
            return null;
        }
        for (Fact fact : this.facts) {
            if (!type.equals((Object)fact.getKnownType())) continue;
            return fact;
        }
        return null;
    }

    @JsonIgnore
    public List<Fact> getFacts(FactType factType) {
        ArrayList<Fact> factsToReturn = new ArrayList<Fact>();
        if (this.facts != null && factType != null) {
            for (Fact fact : this.facts) {
                if (fact.getKnownType() == null || !fact.getKnownType().equals((Object)factType)) continue;
                factsToReturn.add(fact);
            }
        }
        return factsToReturn;
    }

    @Override
    @JsonProperty(value="facts")
    public void setFacts(List<Fact> facts) {
        this.facts = facts;
    }

    public Person fact(Fact fact) {
        this.addFact(fact);
        return this;
    }

    public void addFact(Fact fact) {
        if (fact != null) {
            if (this.facts == null) {
                this.facts = new ArrayList<Fact>();
            }
            this.facts.add(fact);
        }
    }

    @XmlElement(name="display")
    @JsonProperty(value="display")
    @Facet(name="http://rs.gedcomx.org/")
    public DisplayProperties getDisplayExtension() {
        return this.display;
    }

    @JsonProperty(value="display")
    public void setDisplayExtension(DisplayProperties display) {
        this.display = display;
    }

    public Person displayExtension(DisplayProperties display) {
        this.setDisplayExtension(display);
        return this;
    }

    private boolean isReferencedPerson(ResourceReference personReference) {
        if (personReference != null && personReference.getResource() != null) {
            String uri = personReference.getResource().toString();
            if (!uri.startsWith("#")) {
                throw new IllegalArgumentException("Must use local references to persons that are included in a GedcomX document.");
            }
            if (this.getId() != null && personReference.getResource().toString().equals("#" + this.getId())) {
                return true;
            }
        }
        return false;
    }

    public void accept(GedcomxModelVisitor visitor) {
        visitor.visitPerson(this);
    }

    @Override
    @XmlElement(name="field")
    @JsonProperty(value="fields")
    @JsonName(value="fields")
    @Facet(name="http://record.gedcomx.org/")
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    @JsonProperty(value="fields")
    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public Person field(Field field) {
        this.addField(field);
        return this;
    }

    public void addField(Field field) {
        if (field != null) {
            if (this.fields == null) {
                this.fields = new LinkedList<Field>();
            }
            this.fields.add(field);
        }
    }

    public void embed(Person person) {
        this.isPrivate = this.isPrivate == null ? person.isPrivate : this.isPrivate;
        this.living = this.living == null ? person.living : this.living;
        this.principal = this.principal == null ? person.principal : this.principal;
        Gender gender = this.gender = this.gender == null ? person.gender : this.gender;
        if (this.display != null && person.display != null) {
            this.display.embed(person.display);
        } else if (person.display != null) {
            this.display = person.display;
        }
        if (person.names != null) {
            this.names = this.names == null ? new ArrayList() : this.names;
            this.names.addAll(person.names);
        }
        if (person.facts != null) {
            this.facts = this.facts == null ? new ArrayList() : this.facts;
            this.facts.addAll(person.facts);
        }
        if (person.fields != null) {
            this.fields = this.fields == null ? new ArrayList() : this.fields;
            this.fields.addAll(person.fields);
        }
        super.embed(person);
    }

    @Override
    public String toString() {
        if (this.names != null && this.names.size() > 0) {
            return this.getId() + ": " + this.names.get(0).toString();
        }
        return super.toString();
    }
}

