/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.conclusion;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.XmlQNameEnumUtil;
import org.codehaus.enunciate.json.JsonName;
import org.codehaus.enunciate.qname.XmlQNameEnumRef;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gedcomx.common.Attribution;
import org.gedcomx.common.EvidenceReference;
import org.gedcomx.common.Note;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.Document;
import org.gedcomx.conclusion.Fact;
import org.gedcomx.conclusion.HasFacts;
import org.gedcomx.conclusion.Identifier;
import org.gedcomx.conclusion.Person;
import org.gedcomx.conclusion.Subject;
import org.gedcomx.links.Link;
import org.gedcomx.records.Field;
import org.gedcomx.records.HasFields;
import org.gedcomx.rt.GedcomxModelVisitor;
import org.gedcomx.rt.RDFRange;
import org.gedcomx.rt.RDFSubPropertyOf;
import org.gedcomx.rt.json.JsonElementWrapper;
import org.gedcomx.source.SourceDescription;
import org.gedcomx.source.SourceReference;
import org.gedcomx.types.ConfidenceLevel;
import org.gedcomx.types.RelationshipType;

@XmlRootElement
@JsonElementWrapper(name="relationships")
@XmlType(name="Relationship", propOrder={"person1", "person2", "facts", "fields"})
public class Relationship
extends Subject
implements HasFacts,
HasFields {
    private URI type;
    private ResourceReference person1;
    private ResourceReference person2;
    private List<Fact> facts;
    private List<Field> fields;

    @Override
    public Relationship id(String id) {
        return (Relationship)super.id(id);
    }

    @Override
    public Relationship link(String rel, URI href) {
        return (Relationship)super.link(rel, href);
    }

    @Override
    public Relationship link(Link link) {
        return (Relationship)super.link(link);
    }

    @Override
    public Relationship lang(String lang) {
        return (Relationship)super.lang(lang);
    }

    @Override
    public Relationship confidence(URI confidence) {
        return (Relationship)super.confidence(confidence);
    }

    @Override
    public Relationship confidence(ConfidenceLevel confidence) {
        return (Relationship)super.confidence(confidence);
    }

    @Override
    public Relationship source(SourceReference sourceReference) {
        return (Relationship)super.source(sourceReference);
    }

    @Override
    public Relationship source(SourceDescription source) {
        return (Relationship)super.source(source);
    }

    @Override
    public Relationship note(Note note) {
        return (Relationship)super.note(note);
    }

    @Override
    public Relationship analysis(ResourceReference analysis) {
        return (Relationship)super.analysis(analysis);
    }

    @Override
    public Relationship attribution(Attribution attribution) {
        return (Relationship)super.attribution(attribution);
    }

    @Override
    public Relationship analysis(Document analysis) {
        return (Relationship)super.analysis(analysis);
    }

    @Override
    public Relationship analysis(URI analysis) {
        return (Relationship)super.analysis(analysis);
    }

    @Override
    public Relationship extracted(Boolean extracted) {
        return (Relationship)super.extracted(extracted);
    }

    @Override
    public Relationship identifier(Identifier identifier) {
        return (Relationship)super.identifier(identifier);
    }

    @Override
    public Relationship evidence(EvidenceReference evidence) {
        return (Relationship)super.evidence(evidence);
    }

    public Relationship evidence(Relationship evidence) {
        if (evidence.getId() == null) {
            throw new IllegalArgumentException("Unable to add relationship as evidence: no id.");
        }
        return (Relationship)super.evidence(new EvidenceReference(URI.create("#" + evidence.getId())));
    }

    @Override
    public Relationship media(SourceReference media) {
        return (Relationship)super.media(media);
    }

    @Override
    public Relationship media(SourceDescription media) {
        return (Relationship)super.media(media);
    }

    @Override
    public Relationship sortKey(String sortKey) {
        return (Relationship)super.sortKey(sortKey);
    }

    @XmlAttribute
    @XmlQNameEnumRef(value=RelationshipType.class)
    public URI getType() {
        return this.type;
    }

    public void setType(URI type) {
        this.type = type;
    }

    public Relationship type(URI type) {
        this.setType(type);
        return this;
    }

    public Relationship type(RelationshipType type) {
        this.setKnownType(type);
        return this;
    }

    @XmlTransient
    @JsonIgnore
    public RelationshipType getKnownType() {
        return this.getType() == null ? null : RelationshipType.fromQNameURI(this.getType());
    }

    @JsonIgnore
    public void setKnownType(RelationshipType type) {
        this.setType(type == null ? null : URI.create(XmlQNameEnumUtil.toURIValue((Enum)type)));
    }

    @RDFRange(value={Person.class})
    @RDFSubPropertyOf(value={"http://purl.org/dc/terms/hasPart"})
    public ResourceReference getPerson1() {
        return this.person1;
    }

    public void setPerson1(ResourceReference person1) {
        this.person1 = person1;
    }

    public Relationship person1(ResourceReference person1) {
        this.setPerson1(person1);
        return this;
    }

    public Relationship person1(Person person1) {
        if (person1.getId() == null) {
            throw new IllegalStateException("Cannot reference person1: no id.");
        }
        this.setPerson1(new ResourceReference(URI.create("#" + person1.getId())));
        return this;
    }

    @RDFRange(value={Person.class})
    @RDFSubPropertyOf(value={"http://purl.org/dc/terms/hasPart"})
    public ResourceReference getPerson2() {
        return this.person2;
    }

    public void setPerson2(ResourceReference person2) {
        this.person2 = person2;
    }

    public Relationship person2(ResourceReference person2) {
        this.setPerson2(person2);
        return this;
    }

    public Relationship person2(Person person2) {
        if (person2.getId() == null) {
            throw new IllegalStateException("Cannot reference person2: no id.");
        }
        this.setPerson2(new ResourceReference(URI.create("#" + person2.getId())));
        return this;
    }

    @Override
    @XmlElement(name="fact")
    @JsonProperty(value="facts")
    @JsonName(value="facts")
    public List<Fact> getFacts() {
        return this.facts;
    }

    @Override
    @JsonProperty(value="facts")
    public void setFacts(List<Fact> facts) {
        this.facts = facts;
    }

    public Relationship fact(Fact fact) {
        this.addFact(fact);
        return this;
    }

    public void addFact(Fact fact) {
        if (fact != null) {
            if (this.facts == null) {
                this.facts = new ArrayList<Fact>();
            }
            this.facts.add(fact);
        }
    }

    @Override
    @XmlElement(name="field")
    @JsonProperty(value="fields")
    @JsonName(value="fields")
    @Facet(name="http://record.gedcomx.org/")
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    @JsonProperty(value="fields")
    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public Relationship field(Field field) {
        this.addField(field);
        return this;
    }

    public void addField(Field field) {
        if (field != null) {
            if (this.fields == null) {
                this.fields = new LinkedList<Field>();
            }
            this.fields.add(field);
        }
    }

    public void accept(GedcomxModelVisitor visitor) {
        visitor.visitRelationship(this);
    }

    public void embed(Relationship relationship) {
        if (relationship.facts != null) {
            this.facts = this.facts == null ? new ArrayList() : this.facts;
            this.facts.addAll(relationship.facts);
        }
        if (relationship.fields != null) {
            this.fields = this.fields == null ? new ArrayList() : this.fields;
            this.fields.addAll(relationship.fields);
        }
        super.embed(relationship);
    }
}

