/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.conclusion;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.json.JsonName;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gedcomx.common.Attributable;
import org.gedcomx.common.Attribution;
import org.gedcomx.common.EvidenceReference;
import org.gedcomx.common.Note;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.Conclusion;
import org.gedcomx.conclusion.Document;
import org.gedcomx.conclusion.Identifier;
import org.gedcomx.links.Link;
import org.gedcomx.source.SourceDescription;
import org.gedcomx.source.SourceReference;
import org.gedcomx.types.ConfidenceLevel;
import org.gedcomx.types.IdentifierType;

@XmlType(name="Subject", propOrder={"evidence", "media", "identifiers"})
public abstract class Subject
extends Conclusion
implements Attributable {
    private Boolean extracted;
    private List<Identifier> identifiers;
    private List<SourceReference> media;
    private List<EvidenceReference> evidence;

    @Override
    public Subject id(String id) {
        return (Subject)super.id(id);
    }

    @Override
    public Subject link(String rel, URI href) {
        return (Subject)super.link(rel, href);
    }

    @Override
    public Subject link(Link link) {
        return (Subject)super.link(link);
    }

    @Override
    public Subject lang(String lang) {
        return (Subject)super.lang(lang);
    }

    @Override
    public Subject confidence(URI confidence) {
        return (Subject)super.confidence(confidence);
    }

    @Override
    public Subject confidence(ConfidenceLevel confidence) {
        return (Subject)super.confidence(confidence);
    }

    @Override
    public Subject source(SourceReference sourceReference) {
        return (Subject)super.source(sourceReference);
    }

    @Override
    public Subject source(SourceDescription source) {
        return (Subject)super.source(source);
    }

    @Override
    public Subject note(Note note) {
        return (Subject)super.note(note);
    }

    @Override
    public Subject attribution(Attribution attribution) {
        return (Subject)super.attribution(attribution);
    }

    @Override
    public Subject analysis(ResourceReference analysis) {
        return (Subject)super.analysis(analysis);
    }

    @Override
    public Subject analysis(URI analysis) {
        return (Subject)super.analysis(analysis);
    }

    @Override
    public Subject analysis(Document analysis) {
        return (Subject)super.analysis(analysis);
    }

    @Override
    public Subject sortKey(String sortKey) {
        return (Subject)super.sortKey(sortKey);
    }

    @XmlAttribute
    @Facet(name="https://familysearch.org/tree#UNSUPPORTED")
    public Boolean getExtracted() {
        return this.extracted;
    }

    public void setExtracted(Boolean extracted) {
        this.extracted = extracted;
    }

    public Subject extracted(Boolean extracted) {
        this.setExtracted(extracted);
        return this;
    }

    @XmlTransient
    @JsonIgnore
    public URI getPersistentId() {
        URI identifier = null;
        if (this.identifiers != null) {
            for (Identifier id : this.identifiers) {
                if (!IdentifierType.Persistent.equals((Object)id.getKnownType())) continue;
                identifier = id.getValue();
                break;
            }
        }
        return identifier;
    }

    @JsonIgnore
    public void setPersistentId(URI persistentId) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        Iterator<Identifier> it = this.identifiers.iterator();
        while (it.hasNext()) {
            if (!IdentifierType.Persistent.equals((Object)it.next().getKnownType())) continue;
            it.remove();
        }
        Identifier identifier = new Identifier();
        identifier.setKnownType(IdentifierType.Persistent);
        identifier.setValue(persistentId);
        this.identifiers.add(identifier);
    }

    @XmlElement(name="identifier")
    @JsonProperty(value="identifiers")
    @JsonName(value="identifiers")
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    @JsonProperty(value="identifiers")
    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    public Subject identifier(Identifier identifier) {
        this.addIdentifier(identifier);
        return this;
    }

    public void addIdentifier(Identifier identifier) {
        if (identifier != null) {
            if (this.identifiers == null) {
                this.identifiers = new LinkedList<Identifier>();
            }
            this.identifiers.add(identifier);
        }
    }

    public List<EvidenceReference> getEvidence() {
        return this.evidence;
    }

    public void setEvidence(List<EvidenceReference> evidence) {
        this.evidence = evidence;
    }

    public Subject evidence(EvidenceReference evidence) {
        this.addEvidence(evidence);
        return this;
    }

    public void addEvidence(EvidenceReference evidenceRef) {
        if (evidenceRef != null) {
            if (this.evidence == null) {
                this.evidence = new LinkedList<EvidenceReference>();
            }
            this.evidence.add(evidenceRef);
        }
    }

    public List<SourceReference> getMedia() {
        return this.media;
    }

    public void setMedia(List<SourceReference> media) {
        this.media = media;
    }

    public Subject media(SourceReference media) {
        this.addMedia(media);
        return this;
    }

    public Subject media(SourceDescription media) {
        this.addMedia(new SourceReference().description(media));
        return this;
    }

    public void addMedia(SourceReference mediaRef) {
        if (mediaRef != null) {
            if (this.media == null) {
                this.media = new LinkedList<SourceReference>();
            }
            this.media.add(mediaRef);
        }
    }

    protected void embed(Subject subject) {
        Boolean bl = this.extracted = this.extracted == null ? subject.extracted : this.extracted;
        if (subject.identifiers != null) {
            this.identifiers = this.identifiers == null ? new ArrayList() : this.identifiers;
            this.identifiers.addAll(subject.identifiers);
        }
        if (subject.media != null) {
            this.media = this.media == null ? new ArrayList() : this.media;
            this.media.addAll(subject.media);
        }
        if (subject.evidence != null) {
            this.evidence = this.evidence == null ? new ArrayList() : this.evidence;
            this.evidence.addAll(subject.evidence);
        }
        super.embed(subject);
    }
}

