/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.util;

import java.util.List;
import org.gedcomx.Gedcomx;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.conclusion.Fact;
import org.gedcomx.conclusion.Identifier;
import org.gedcomx.conclusion.NameForm;
import org.gedcomx.conclusion.NamePart;
import org.gedcomx.conclusion.Person;
import org.gedcomx.conclusion.Relationship;
import org.gedcomx.records.Field;
import org.gedcomx.records.FieldValue;
import org.gedcomx.records.RecordSet;
import org.gedcomx.source.SourceDescription;
import org.gedcomx.source.SourceReference;
import org.gedcomx.util.DocMap;
import org.gedcomx.util.FieldMap;

public class DocCheck {
    public static String checkDocument(Gedcomx doc) {
        StringBuilder errors = new StringBuilder();
        DocMap docMap = new DocMap(doc);
        if (docMap.getMainSourceDescription() == null) {
            errors.append("Error 1: Missing main source description reference. Each GedcomX document should have a SourceDescription describing what the document is about, and 'description' should reference it.\n");
        }
        if (doc.getSourceDescriptions() != null) {
            for (SourceDescription sourceDescription : doc.getSourceDescriptions()) {
                if (sourceDescription.getComponentOf() != null && docMap.getSourceDescription(sourceDescription.getComponentOf()) == null) {
                    errors.append("Error 2: ").append(DocCheck.getSourceDescriptionName(sourceDescription)).append(" has componentOf that references ").append(DocCheck.getSourceReferenceName(sourceDescription.getComponentOf())).append(" but it cannot be found in the document.\n");
                }
                if (sourceDescription.getSources() == null) continue;
                DocCheck.checkSources(errors, "Error 3: " + DocCheck.getSourceDescriptionName(sourceDescription), sourceDescription.getSources(), null, sourceDescription.getFields(), docMap);
            }
        }
        if (doc.getRelationships() != null) {
            for (Relationship relationship : doc.getRelationships()) {
                boolean foundPerson = false;
                for (ResourceReference ref : new ResourceReference[]{relationship.getPerson1(), relationship.getPerson2()}) {
                    if (ref == null) continue;
                    if (ref.getResource() == null && ref.getResourceId() != null) {
                        errors.append("Error 4: ResourceId without resource URI in relationship. Must specify always resource URI, even if optional resourceId is included.\n");
                        continue;
                    }
                    Person person = docMap.getPerson(ref);
                    if (person == null) {
                        if (ref.getResource() == null || !ref.getResource().toString().startsWith("#")) continue;
                        errors.append("Error 5: Local person id '").append(ref.getResource().toString()).append("' not found.\n");
                        continue;
                    }
                    foundPerson = true;
                    if (ref.getResource().toString().startsWith("#")) continue;
                    errors.append("Warning 6: Relationship should use local id (").append(person.getId() != null ? "'#" + person.getId() + "'" : "though the person does not have one").append(") for person instead of full URI ").append(ref.getResource().toString()).append("\n");
                }
                if (!foundPerson) {
                    errors.append("Error 7: A relationship failed to reference anyone inside the document. At least one person must be in the document.\n");
                }
                DocCheck.checkSources(errors, "Error 8: relationship", relationship.getSources(), relationship.getFacts(), relationship.getFields(), docMap);
                DocCheck.checkSources(errors, "Error 9: relationship (media)", relationship.getMedia(), null, null, docMap);
            }
        }
        if (doc.getPersons() != null) {
            for (Person person : doc.getPersons()) {
                String personString = DocCheck.getPersonString(person);
                DocCheck.checkSources(errors, "Error 10: " + personString, person.getSources(), person.getFacts(), person.getFields(), docMap);
                DocCheck.checkSources(errors, "Error 11: " + personString + " (media)", person.getMedia(), null, null, docMap);
                if (person.getGender() == null) continue;
                DocCheck.checkSources(errors, "Error 12: " + personString + " (gender)", person.getGender().getSources(), null, person.getGender().getFields(), docMap);
            }
        }
        return errors.length() == 0 ? null : errors.toString();
    }

    private static String getPersonString(Person person) {
        NameForm nameForm;
        if (person.getId() != null) {
            return "Person #" + person.getId();
        }
        if (person.getIdentifiers() != null) {
            for (Identifier identifier : person.getIdentifiers()) {
                if (identifier.getValue() == null) continue;
                return "Person " + identifier.getValue().toString();
            }
        }
        if (person.getName() != null && (nameForm = person.getName().getNameForm()) != null) {
            if (nameForm.getFullText() != null) {
                return nameForm.getFullText();
            }
            if (nameForm.getParts() != null) {
                StringBuilder fullName = new StringBuilder();
                boolean isFirst = true;
                for (NamePart namePart : nameForm.getParts()) {
                    if (namePart.getValue() != null && namePart.getValue().length() > 0) {
                        fullName.append(namePart.getValue());
                    }
                    if (isFirst) {
                        isFirst = false;
                        continue;
                    }
                    fullName.append(" ");
                }
                if (fullName.length() > 0) {
                    return fullName.toString();
                }
            }
        }
        return "<Unidentified Person>";
    }

    private static void checkSources(StringBuilder errors, String whereReferencedFrom, List<SourceReference> sources, List<Fact> facts, List<Field> fields, DocMap docMap) {
        if (sources != null) {
            for (SourceReference source : sources) {
                SourceDescription sd = docMap.getSourceDescription(source);
                if (sd != null) continue;
                errors.append("Could not find referenced source ").append(DocCheck.getSourceReferenceName(source)).append(" from ").append(whereReferencedFrom).append("\n");
            }
        }
        if (facts != null) {
            for (Fact fact : facts) {
                DocCheck.checkSources(errors, whereReferencedFrom + " (fact)", fact.getSources(), null, fact.getFields(), docMap);
                if (fact.getPlace() == null || fact.getPlace().getDescriptionRef() == null || !fact.getPlace().getDescriptionRef().toString().startsWith("#") || docMap.getPlaceDescription(fact.getPlace().getDescriptionRef()) != null) continue;
                errors.append("Could not find referenced place ").append(fact.getPlace().getDescriptionRef().toString()).append("\n");
            }
        }
        if (fields != null) {
            for (Field field : fields) {
                if (field.getValues() == null) continue;
                for (FieldValue fieldValue : field.getValues()) {
                    DocCheck.checkSources(errors, whereReferencedFrom + " (field value)", fieldValue.getSources(), null, null, docMap);
                }
            }
        }
    }

    private static String getSourceReferenceName(SourceReference sourceReference) {
        if (sourceReference == null) {
            return "<null>";
        }
        if (sourceReference.getDescriptionRef() == null) {
            return "<no description ref>";
        }
        return sourceReference.getDescriptionRef().toString();
    }

    private static String getSourceDescriptionName(SourceDescription sd) {
        if (sd.getId() != null && sd.getId().length() > 0) {
            return "SourceDescription with id=" + sd.getId();
        }
        if (sd.getAbout() != null) {
            return "SourceDescription with about=" + sd.getAbout().toString();
        }
        if (sd.getIdentifiers() != null) {
            for (Identifier identifier : sd.getIdentifiers()) {
                if (identifier.getValue() == null) continue;
                return "SourceDescription for URI " + identifier.getValue().toString();
            }
        }
        if (sd.getTitle() != null) {
            return "SourceDescription with title " + sd.getTitle().getValue();
        }
        if (sd.getCitation() != null) {
            return "SourceDescription with citation " + sd.getCitation().getValue();
        }
        return "SourceDescription with no identifiers, title or citation";
    }

    public static String checkDocument(Gedcomx doc, Gedcomx collection) {
        FieldMap fieldMap = new FieldMap(doc, collection);
        StringBuilder errors = new StringBuilder();
        DocCheck.addIfNeeded(errors, DocCheck.checkDocument(doc));
        DocCheck.checkFields(errors, "Fields", FieldMap.getAllFields(doc), fieldMap);
        return errors.length() == 0 ? null : errors.toString();
    }

    private static void checkFields(StringBuilder errors, String context, List<Field> fields, FieldMap fieldMap) {
        if (fields != null) {
            for (Field field : fields) {
                if (field.getValues() == null) continue;
                for (FieldValue fieldValue : field.getValues()) {
                    if (fieldValue.getLabelId() == null || fieldMap.getFieldValueDescriptor(fieldValue.getLabelId()) != null) continue;
                    errors.append("Error 13: ").append(context).append(": Field with labelId '").append(fieldValue.getLabelId()).append("' had no FieldValueDescriptor\n");
                }
            }
        }
    }

    public static String checkRecordSet(RecordSet records, Gedcomx collection) {
        Gedcomx metadata;
        StringBuilder errors = new StringBuilder();
        Gedcomx gedcomx = metadata = collection == null ? records.getMetadata() : collection;
        if (metadata != null) {
            DocCheck.addIfNeeded(errors, DocCheck.checkDocument(metadata));
        }
        if (records.getRecords() != null) {
            for (Gedcomx record : records.getRecords()) {
                DocCheck.addIfNeeded(errors, metadata == null ? DocCheck.checkDocument(record) : DocCheck.checkDocument(record, metadata));
            }
        }
        return errors.length() == 0 ? null : errors.toString();
    }

    private static void addIfNeeded(StringBuilder errors, String result) {
        if (result != null) {
            errors.append(result);
        }
    }
}

