/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.util;

import java.io.IOException;
import java.io.OutputStream;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.gedcomx.Gedcomx;
import org.gedcomx.rt.json.GedcomJacksonModule;

public class JsonRecordSetWriter {
    private OutputStream outputStream;
    private ObjectMapper objectMapper;
    private long numOfRecords = 0L;
    public static final String ID_STR = "id";
    public static final String METADATA_STR = "metadata";
    public static final String RECORDS_STR = "records";

    public JsonRecordSetWriter(OutputStream outputStream, Gedcomx metadata) {
        try {
            this.outputStream = outputStream;
            this.objectMapper = GedcomJacksonModule.createObjectMapper((Class[])new Class[0]);
            this.objectMapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
            this.objectMapper.configure(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, false);
            outputStream.write("{\n".getBytes());
            this.writeLabel(outputStream, METADATA_STR);
            this.objectMapper.writeValue(outputStream, (Object)metadata);
            outputStream.write(",\n".getBytes());
            this.writeLabel(outputStream, RECORDS_STR);
            outputStream.write(" [\n".getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeLabel(OutputStream outputStream, String label) throws IOException {
        outputStream.write(34);
        outputStream.write(label.getBytes());
        outputStream.write("\":".getBytes());
    }

    public void writeRecord(Gedcomx record) throws IOException {
        if (this.numOfRecords > 0L) {
            this.outputStream.write(44);
        }
        this.objectMapper.writeValue(this.outputStream, (Object)record);
        ++this.numOfRecords;
    }

    public void close() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.write("]\n}".getBytes());
            this.outputStream.close();
        }
    }

    public long getNumOfRecords() {
        return this.numOfRecords;
    }
}

