/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webcohesion.enunciate.metadata.Facet;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.gedcomx.agent.Agent;
import org.gedcomx.common.Attribution;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.Document;
import org.gedcomx.conclusion.Event;
import org.gedcomx.conclusion.FamilyView;
import org.gedcomx.conclusion.Person;
import org.gedcomx.conclusion.PlaceDescription;
import org.gedcomx.conclusion.Relationship;
import org.gedcomx.links.HypermediaEnabledData;
import org.gedcomx.links.Link;
import org.gedcomx.records.Collection;
import org.gedcomx.records.Field;
import org.gedcomx.records.RecordDescriptor;
import org.gedcomx.rt.GedcomxModelVisitor;
import org.gedcomx.rt.MediaTypeDefinition;
import org.gedcomx.rt.Model;
import org.gedcomx.rt.json.JsonElementWrapper;
import org.gedcomx.source.SourceDescription;
import org.gedcomx.types.RelationshipType;

@MediaTypeDefinition(name="GEDCOM X", description="The GEDCOM X data formats define the serialization formats of the GEDCOM X conceptual model.", version="1.0", xmlMediaType="application/x-gedcomx-v1+xml", jsonMediaType="application/x-gedcomx-v1+json", models={@Model(id="gx", namespace="http://gedcomx.org/v1/", label="GEDCOM X Model", description="The core model for all GEDCOM X data types and elements."), @Model(id="types", namespace="http://gedcomx.org/", label="GEDCOM X Types", description="The types model contains all of the types and constrained vocabulary for GEDCOM X data.")})
@XmlRootElement
@JsonElementWrapper(name="gedcomx")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@XmlType(name="Gedcomx", propOrder={"attribution", "persons", "relationships", "sourceDescriptions", "agents", "events", "places", "documents", "collections", "fields", "recordDescriptors"})
public class Gedcomx
extends HypermediaEnabledData {
    private String lang;
    private URI descriptionRef;
    private Attribution attribution;
    private List<Person> persons;
    private List<Relationship> relationships;
    private List<SourceDescription> sourceDescriptions;
    private List<Agent> agents;
    private List<Event> events;
    private List<PlaceDescription> places;
    private List<Document> documents;
    private List<Collection> collections;
    private List<Field> fields;
    private List<RecordDescriptor> recordDescriptors;

    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Gedcomx lang(String lang) {
        this.setLang(lang);
        return this;
    }

    @XmlAttribute(name="description")
    @JsonProperty(value="description")
    @Facet(value="http://record.gedcomx.org/")
    public URI getDescriptionRef() {
        return this.descriptionRef;
    }

    @JsonProperty(value="description")
    public void setDescriptionRef(URI descriptionRef) {
        this.descriptionRef = descriptionRef;
    }

    public Gedcomx descriptionRef(URI descriptionRef) {
        this.setDescriptionRef(descriptionRef);
        return this;
    }

    public Attribution getAttribution() {
        return this.attribution;
    }

    public void setAttribution(Attribution attribution) {
        this.attribution = attribution;
    }

    public Gedcomx attribution(Attribution attribution) {
        this.setAttribution(attribution);
        return this;
    }

    @XmlTransient
    @JsonIgnore
    public Person getPerson() {
        return this.persons != null && this.persons.size() > 0 ? this.persons.get(0) : null;
    }

    @XmlElement(name="person")
    @JsonProperty(value="persons")
    public List<Person> getPersons() {
        return this.persons;
    }

    @JsonProperty(value="persons")
    public void setPersons(List<Person> persons) {
        this.persons = persons;
    }

    public Gedcomx person(Person person) {
        this.addPerson(person);
        return this;
    }

    public void addPerson(Person person) {
        if (person != null) {
            if (this.persons == null) {
                this.persons = new LinkedList<Person>();
            }
            this.persons.add(person);
        }
    }

    @XmlTransient
    @JsonIgnore
    public List<Relationship> getCoupleRelationships() {
        ArrayList<Relationship> filtered = null;
        if (this.relationships != null) {
            filtered = new ArrayList<Relationship>();
            for (Relationship relationship : this.relationships) {
                if (relationship.getKnownType() != RelationshipType.Couple) continue;
                filtered.add(relationship);
            }
        }
        return filtered;
    }

    @XmlTransient
    @JsonIgnore
    public List<Relationship> getParentChildRelationships() {
        ArrayList<Relationship> filtered = null;
        if (this.relationships != null) {
            filtered = new ArrayList<Relationship>();
            for (Relationship relationship : this.relationships) {
                if (relationship.getKnownType() != RelationshipType.ParentChild) continue;
                filtered.add(relationship);
            }
        }
        return filtered;
    }

    public Relationship findCoupleRelationship(FamilyView family) {
        return family == null ? null : this.findCoupleRelationship(family.getParent1(), family.getParent2());
    }

    public Relationship findCoupleRelationship(ResourceReference person1, ResourceReference person2) {
        if (this.getRelationships() != null) {
            for (Relationship relationship : this.getRelationships()) {
                if (relationship.getKnownType() != RelationshipType.Couple || !Gedcomx.samePerson(person1, relationship.getPerson1()) || !Gedcomx.samePerson(person2, relationship.getPerson2())) continue;
                return relationship;
            }
        }
        return null;
    }

    public Relationship findParentChildRelationship(ResourceReference parent, ResourceReference child) {
        if (parent != null && child != null && this.getRelationships() != null && parent.getResource() != null && child.getResource() != null) {
            for (Relationship relationship : this.getRelationships()) {
                if (!relationship.getKnownType().equals(RelationshipType.ParentChild) || !Gedcomx.samePerson(relationship.getPerson1(), parent) || !Gedcomx.samePerson(relationship.getPerson2(), child)) continue;
                return relationship;
            }
        }
        return null;
    }

    protected static boolean samePerson(ResourceReference ref1, ResourceReference ref2) {
        return ref1 == ref2 || ref1 != null && ref1.getResource() != null && ref2 != null && ref2.getResource() != null && ref1.getResource().equals(ref2.getResource());
    }

    @XmlElement(name="relationship")
    @JsonProperty(value="relationships")
    public List<Relationship> getRelationships() {
        return this.relationships;
    }

    @JsonProperty(value="relationships")
    public void setRelationships(List<Relationship> relationships) {
        this.relationships = relationships;
    }

    public Gedcomx relationship(Relationship relationship) {
        this.addRelationship(relationship);
        return this;
    }

    public void addRelationship(Relationship relationship) {
        if (relationship != null) {
            if (this.relationships == null) {
                this.relationships = new LinkedList<Relationship>();
            }
            this.relationships.add(relationship);
        }
    }

    @XmlTransient
    @JsonIgnore
    public SourceDescription getSourceDescription() {
        return this.sourceDescriptions != null && this.sourceDescriptions.size() > 0 ? this.sourceDescriptions.get(0) : null;
    }

    public SourceDescription getSourceDescription(URI resourceType) {
        if (this.sourceDescriptions != null && this.sourceDescriptions.size() > 0) {
            for (SourceDescription sourceDescription : this.sourceDescriptions) {
                if (!sourceDescription.getResourceType().equals(resourceType)) continue;
                return sourceDescription;
            }
        }
        return null;
    }

    @XmlElement(name="sourceDescription")
    @JsonProperty(value="sourceDescriptions")
    public List<SourceDescription> getSourceDescriptions() {
        return this.sourceDescriptions;
    }

    @JsonProperty(value="sourceDescriptions")
    public void setSourceDescriptions(List<SourceDescription> sourceDescriptions) {
        this.sourceDescriptions = sourceDescriptions;
    }

    public Gedcomx sourceDescription(SourceDescription sourceDescription) {
        this.addSourceDescription(sourceDescription);
        return this;
    }

    public void addSourceDescription(SourceDescription sourceDescription) {
        if (sourceDescription != null) {
            if (this.sourceDescriptions == null) {
                this.sourceDescriptions = new LinkedList<SourceDescription>();
            }
            this.sourceDescriptions.add(sourceDescription);
        }
    }

    @XmlElement(name="agent")
    @JsonProperty(value="agents")
    public List<Agent> getAgents() {
        return this.agents;
    }

    @JsonProperty(value="agents")
    public void setAgents(List<Agent> agents) {
        this.agents = agents;
    }

    public Gedcomx agent(Agent agent) {
        this.addAgent(agent);
        return this;
    }

    public void addAgent(Agent agent) {
        if (agent != null) {
            if (this.agents == null) {
                this.agents = new LinkedList<Agent>();
            }
            this.agents.add(agent);
        }
    }

    @XmlElement(name="event")
    @JsonProperty(value="events")
    public List<Event> getEvents() {
        return this.events;
    }

    @JsonProperty(value="events")
    public void setEvents(List<Event> events) {
        this.events = events;
    }

    public Gedcomx event(Event event) {
        this.addEvent(event);
        return this;
    }

    public void addEvent(Event event) {
        if (event != null) {
            if (this.events == null) {
                this.events = new LinkedList<Event>();
            }
            this.events.add(event);
        }
    }

    @XmlElement(name="place")
    @JsonProperty(value="places")
    public List<PlaceDescription> getPlaces() {
        return this.places;
    }

    @JsonProperty(value="places")
    public void setPlaces(List<PlaceDescription> places) {
        this.places = places;
    }

    public Gedcomx place(PlaceDescription place) {
        this.addPlace(place);
        return this;
    }

    public void addPlace(PlaceDescription place) {
        if (place != null) {
            if (this.places == null) {
                this.places = new LinkedList<PlaceDescription>();
            }
            this.places.add(place);
        }
    }

    @XmlElement(name="document")
    @JsonProperty(value="documents")
    public List<Document> getDocuments() {
        return this.documents;
    }

    @JsonProperty(value="documents")
    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    public Gedcomx document(Document document) {
        this.addDocument(document);
        return this;
    }

    public void addDocument(Document document) {
        if (document != null) {
            if (this.documents == null) {
                this.documents = new LinkedList<Document>();
            }
            this.documents.add(document);
        }
    }

    @XmlElement(name="collection")
    @JsonProperty(value="collections")
    @Facet(value="http://record.gedcomx.org/")
    public List<Collection> getCollections() {
        return this.collections;
    }

    @JsonProperty(value="collections")
    public void setCollections(List<Collection> collections) {
        this.collections = collections;
    }

    public Gedcomx collection(Collection collection) {
        this.addCollection(collection);
        return this;
    }

    public void addCollection(Collection collection) {
        if (collection != null) {
            if (this.collections == null) {
                this.collections = new LinkedList<Collection>();
            }
            this.collections.add(collection);
        }
    }

    @XmlElement(name="field")
    @JsonProperty(value="fields")
    @Facet(value="http://record.gedcomx.org/")
    public List<Field> getFields() {
        return this.fields;
    }

    @JsonProperty(value="fields")
    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public Gedcomx field(Field field) {
        this.addField(field);
        return this;
    }

    public void addField(Field field) {
        if (field != null) {
            if (this.fields == null) {
                this.fields = new LinkedList<Field>();
            }
            this.fields.add(field);
        }
    }

    @XmlElement(name="recordDescriptor")
    @JsonProperty(value="recordDescriptors")
    @Facet(value="http://record.gedcomx.org/")
    public List<RecordDescriptor> getRecordDescriptors() {
        return this.recordDescriptors;
    }

    @JsonProperty(value="recordDescriptors")
    public void setRecordDescriptors(List<RecordDescriptor> recordDescriptors) {
        this.recordDescriptors = recordDescriptors;
    }

    public Gedcomx recordDescriptor(RecordDescriptor recordDescriptor) {
        this.addRecordDescriptor(recordDescriptor);
        return this;
    }

    public void addRecordDescriptor(RecordDescriptor recordDescriptor) {
        if (recordDescriptor != null) {
            if (this.recordDescriptors == null) {
                this.recordDescriptors = new LinkedList<RecordDescriptor>();
            }
            this.recordDescriptors.add(recordDescriptor);
        }
    }

    public void accept(GedcomxModelVisitor visitor) {
        visitor.visitGedcomx(this);
    }

    public void embed(Gedcomx gedcomx) {
        List<RecordDescriptor> list;
        List<Field> list2;
        List<Collection> list3;
        List<Document> list4;
        List<PlaceDescription> list5;
        List<Event> list6;
        List<Agent> agents;
        List<SourceDescription> sourceDescriptions;
        List<Relationship> list7;
        List<Person> persons;
        List<Link> links = gedcomx.getLinks();
        if (links != null) {
            for (Link link : links) {
                boolean found = false;
                if (link.getRel() != null && this.getLinks() != null) {
                    for (Link link2 : this.getLinks()) {
                        if (!link.getRel().equals(link2.getRel())) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                this.addLink(link);
            }
        }
        if ((persons = gedcomx.getPersons()) != null) {
            for (Person person : persons) {
                boolean found = false;
                if (person.getId() != null && this.getPersons() != null) {
                    for (Person person2 : this.getPersons()) {
                        if (!person.getId().equals(person2.getId())) continue;
                        person2.embed(person);
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                this.addPerson(person);
            }
        }
        if ((list7 = gedcomx.getRelationships()) != null) {
            for (Relationship relationship : list7) {
                boolean bl = false;
                if (relationship.getId() != null && this.getRelationships() != null) {
                    for (Relationship relationship2 : this.getRelationships()) {
                        if (!relationship.getId().equals(relationship2.getId())) continue;
                        relationship2.embed(relationship);
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                this.addRelationship(relationship);
            }
        }
        if ((sourceDescriptions = gedcomx.getSourceDescriptions()) != null) {
            for (SourceDescription sourceDescription : sourceDescriptions) {
                boolean bl = false;
                if (sourceDescription.getId() != null && this.getSourceDescriptions() != null) {
                    for (SourceDescription sourceDescription2 : this.getSourceDescriptions()) {
                        if (!sourceDescription.getId().equals(sourceDescription2.getId())) continue;
                        sourceDescription2.embed(sourceDescription);
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                this.addSourceDescription(sourceDescription);
            }
        }
        if ((agents = gedcomx.getAgents()) != null) {
            for (Agent agent : agents) {
                boolean bl = false;
                if (agent.getId() != null && this.getAgents() != null) {
                    for (Agent agent2 : this.getAgents()) {
                        if (!agent.getId().equals(agent2.getId())) continue;
                        agent2.embed(agent);
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                this.addAgent(agent);
            }
        }
        if ((list6 = gedcomx.getEvents()) != null) {
            for (Event event : list6) {
                boolean bl = false;
                if (event.getId() != null && this.getEvents() != null) {
                    for (Event event2 : this.getEvents()) {
                        if (!event.getId().equals(event2.getId())) continue;
                        event2.embed(event);
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                this.addEvent(event);
            }
        }
        if ((list5 = gedcomx.getPlaces()) != null) {
            for (PlaceDescription placeDescription : list5) {
                boolean bl = false;
                if (placeDescription.getId() != null && this.getPlaces() != null) {
                    for (PlaceDescription placeDescription2 : this.getPlaces()) {
                        if (!placeDescription.getId().equals(placeDescription2.getId())) continue;
                        placeDescription2.embed(placeDescription);
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                this.addPlace(placeDescription);
            }
        }
        if ((list4 = gedcomx.getDocuments()) != null) {
            for (Document document : list4) {
                boolean bl = false;
                if (document.getId() != null && this.getDocuments() != null) {
                    for (Document document2 : this.getDocuments()) {
                        if (!document.getId().equals(document2.getId())) continue;
                        document2.embed(document);
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                this.addDocument(document);
            }
        }
        if ((list3 = gedcomx.getCollections()) != null) {
            for (Collection collection : list3) {
                boolean bl = false;
                if (collection.getId() != null && this.getCollections() != null) {
                    for (Collection collection2 : this.getCollections()) {
                        if (!collection.getId().equals(collection2.getId())) continue;
                        collection2.embed(collection);
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                this.addCollection(collection);
            }
        }
        if ((list2 = gedcomx.getFields()) != null) {
            for (Field field : list2) {
                boolean bl = false;
                if (field.getId() != null && this.getFields() != null) {
                    for (Field target : this.getFields()) {
                        if (!field.getId().equals(target.getId())) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                this.addField(field);
            }
        }
        if ((list = gedcomx.getRecordDescriptors()) != null) {
            for (RecordDescriptor recordDescriptor : list) {
                boolean bl = false;
                if (recordDescriptor.getId() != null && this.getRecordDescriptors() != null) {
                    for (RecordDescriptor target : this.getRecordDescriptors()) {
                        if (!recordDescriptor.getId().equals(target.getId())) continue;
                        target.embed(recordDescriptor);
                        bl = true;
                        break;
                    }
                }
                if (bl) continue;
                this.addRecordDescriptor(recordDescriptor);
            }
        }
    }
}

