/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.webcohesion.enunciate.metadata.Facet;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.gedcomx.common.Attributable;
import org.gedcomx.common.Attribution;
import org.gedcomx.common.HasText;
import org.gedcomx.common.URI;
import org.gedcomx.links.HypermediaEnabledData;
import org.gedcomx.links.Link;
import org.gedcomx.rt.GedcomxModelVisitor;
import org.gedcomx.rt.json.JsonElementWrapper;

@XmlRootElement
@JsonElementWrapper(name="notes")
@XmlType(name="Note", propOrder={"subject", "text", "attribution"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Note
extends HypermediaEnabledData
implements Attributable,
HasText {
    private String lang;
    private String subject;
    private String text;
    private Attribution attribution;

    @Override
    public Note id(String id) {
        return (Note)super.id(id);
    }

    @Override
    public Note extensionElement(Object element) {
        return (Note)super.extensionElement(element);
    }

    @Override
    public Note link(String rel, URI href) {
        return (Note)super.link(rel, href);
    }

    @Override
    public Note link(Link link) {
        return (Note)super.link(link);
    }

    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    @Facet(value="https://familysearch.org/tree#UNSUPPORTED")
    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Note lang(String lang) {
        this.lang = lang;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String text) {
        this.subject = text;
    }

    public Note subject(String text) {
        this.subject = text;
        return this;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    public Note text(String text) {
        this.text = text;
        return this;
    }

    @Override
    public Attribution getAttribution() {
        return this.attribution;
    }

    @Override
    public void setAttribution(Attribution attribution) {
        this.attribution = attribution;
    }

    public Note attribution(Attribution attribution) {
        this.attribution = attribution;
        return this;
    }

    @Override
    public String toString() {
        return "Note{subject=" + this.getTextBrief(this.subject) + ", text=" + this.getTextBrief(this.text) + ", attribution=" + this.attribution + '}';
    }

    private String getTextBrief(String text) {
        if (text != null) {
            int substrLen = 40;
            if (text.length() > 40) {
                return text.substring(0, 40) + "...";
            }
            return text;
        }
        return null;
    }

    public void accept(GedcomxModelVisitor visitor) {
        visitor.visitNote(this);
    }
}

