/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.links;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webcohesion.enunciate.metadata.Facet;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.gedcomx.common.ExtensibleData;
import org.gedcomx.common.URI;
import org.gedcomx.links.Link;
import org.gedcomx.links.SupportsLinks;

@XmlType(name="HypermediaEnabledData")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class HypermediaEnabledData
extends ExtensibleData
implements SupportsLinks {
    private List<Link> links;

    @Override
    @XmlElement(name="link")
    @JsonProperty(value="links")
    @Facet(value="http://rs.gedcomx.org/")
    public List<Link> getLinks() {
        return this.links;
    }

    @Override
    @JsonProperty(value="links")
    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public HypermediaEnabledData link(Link link) {
        this.addLink(link);
        return this;
    }

    public HypermediaEnabledData link(String rel, URI href) {
        this.addLink(rel, href);
        return this;
    }

    @Override
    public void addLink(Link link) {
        if (this.links == null) {
            this.setLinks(new ArrayList<Link>());
        }
        this.links.add(link);
    }

    @Override
    public void addLink(String rel, URI href) {
        this.addLink(new Link(rel, href));
    }

    @Override
    public void addTemplatedLink(String rel, String template) {
        Link link = new Link();
        link.setRel(rel);
        link.setTemplate(template);
        this.addLink(link);
    }

    @Override
    public Link getLink(String rel) {
        List<Link> links = this.getLinks(rel);
        Link link = null;
        if (!links.isEmpty()) {
            link = links.get(0);
        }
        return link;
    }

    @Override
    public List<Link> getLinks(String rel) {
        ArrayList<Link> links = new ArrayList<Link>();
        if (this.links != null) {
            for (Link link : this.getLinks()) {
                if (!rel.equals(link.getRel())) continue;
                links.add(link);
            }
        }
        return links;
    }

    protected void embed(HypermediaEnabledData data) {
        super.embed(data);
    }
}

