/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.links;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.webcohesion.enunciate.metadata.Facet;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.gedcomx.common.URI;
import org.gedcomx.rt.json.HasJsonKey;
import org.gedcomx.rt.json.JsonElementWrapper;

@XmlRootElement
@XmlType(name="Link", propOrder={"rel", "href", "template", "title", "type", "accept", "allow", "hreflang"})
@JsonElementWrapper(name="links")
@Facet(value="http://rs.gedcomx.org/")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Link
implements HasJsonKey {
    public static final Set<String> NON_UNIQUE_RELS = new TreeSet<String>(Arrays.asList("alternate", "bookmark", "related", "item"));
    private String rel;
    private URI href;
    private String template;
    private String type;
    private String accept;
    private String allow;
    private String hreflang;
    private String title;
    private Integer count;
    private Integer offset;
    private Integer results;

    public Link(String rel, URI href) {
        this.rel = rel;
        this.href = href;
    }

    public Link() {
    }

    @XmlTransient
    @JsonIgnore
    public boolean isHasUniqueKey() {
        return this.rel != null && !NON_UNIQUE_RELS.contains(this.rel);
    }

    @XmlAttribute
    @JsonIgnore
    public String getRel() {
        return this.rel;
    }

    @JsonIgnore
    public void setRel(String rel) {
        this.rel = rel;
    }

    public Link rel(String rel) {
        this.setRel(rel);
        return this;
    }

    @XmlTransient
    @JsonIgnore
    public String getJsonKey() {
        return this.getRel();
    }

    @JsonIgnore
    public void setJsonKey(String jsonKey) {
        this.setRel(jsonKey);
    }

    @XmlAttribute
    @XmlSchemaType(name="anyURI", namespace="http://www.w3.org/2001/XMLSchema")
    public URI getHref() {
        return this.href;
    }

    public void setHref(URI href) {
        this.href = href;
    }

    public Link href(URI href) {
        this.setHref(href);
        return this;
    }

    @XmlAttribute
    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public Link template(String template) {
        this.setTemplate(template);
        return this;
    }

    @XmlAttribute
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Link type(String type) {
        this.setType(type);
        return this;
    }

    @XmlAttribute
    public String getAccept() {
        return this.accept;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public Link accept(String accept) {
        this.setAccept(accept);
        return this;
    }

    @XmlAttribute
    public String getAllow() {
        return this.allow;
    }

    public void setAllow(String allow) {
        this.allow = allow;
    }

    public Link allow(String allow) {
        this.setAllow(allow);
        return this;
    }

    @XmlAttribute
    public String getHreflang() {
        return this.hreflang;
    }

    public void setHreflang(String hreflang) {
        this.hreflang = hreflang;
    }

    public Link hreflang(String hreflang) {
        this.setHreflang(hreflang);
        return this;
    }

    @XmlAttribute
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Link title(String title) {
        this.setTitle(title);
        return this;
    }

    @XmlAttribute
    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Link count(Integer count) {
        this.setCount(count);
        return this;
    }

    @XmlAttribute
    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Link offset(Integer offset) {
        this.setOffset(offset);
        return this;
    }

    @XmlAttribute
    public Integer getResults() {
        return this.results;
    }

    public void setResults(Integer results) {
        this.results = results;
    }

    public Link results(Integer results) {
        this.setResults(results);
        return this;
    }

    @XmlTransient
    @JsonIgnore
    public String getHttpHeaderValue() {
        StringBuilder builder = new StringBuilder("<");
        if (this.href != null) {
            builder.append(this.href.toString());
        }
        builder.append(">");
        if (this.rel != null) {
            builder.append("; rel=\"").append(this.rel).append("\"");
        }
        if (this.template != null) {
            builder.append("; template=\"").append(this.template).append("\"");
        }
        if (this.type != null) {
            builder.append("; type=\"").append(this.type).append("\"");
        }
        if (this.accept != null) {
            builder.append("; accept=\"").append(this.accept).append("\"");
        }
        if (this.allow != null) {
            builder.append("; allow=\"").append(this.allow).append("\"");
        }
        if (this.hreflang != null) {
            builder.append("; hreflang=\"").append(this.hreflang).append("\"");
        }
        if (this.title != null) {
            builder.append("; title=\"").append(this.title).append("\"");
        }
        if (this.count != null) {
            builder.append("; count=\"").append(this.title).append("\"");
        }
        if (this.offset != null) {
            builder.append("; offset=\"").append(this.title).append("\"");
        }
        if (this.results != null) {
            builder.append("; results=\"").append(this.title).append("\"");
        }
        return builder.toString();
    }

    public String toString() {
        return this.getHttpHeaderValue();
    }
}

