/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.util;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class CleanXMLStreamWriter
implements XMLStreamWriter {
    private final XMLStreamWriter writer;
    public static final char REPLACEMENT_CHARACTER = '\ufffd';

    public CleanXMLStreamWriter(XMLStreamWriter writer) {
        if (null == writer) {
            throw new IllegalArgumentException("null");
        }
        this.writer = writer;
    }

    protected static String escapeCharacters(String string) {
        int size;
        char[] copy = null;
        boolean copied = false;
        for (int i = 0; i < string.length(); i += size) {
            int codePoint = string.codePointAt(i);
            size = Character.charCount(codePoint);
            if (CleanXMLStreamWriter.isLegalXmlCodePoint(codePoint)) continue;
            if (!copied) {
                copy = string.toCharArray();
                copied = true;
            }
            for (int j = 0; j < size; ++j) {
                copy[i + j] = 65533;
            }
        }
        return copied ? new String(copy) : string;
    }

    @Override
    public void writeStartElement(String s) throws XMLStreamException {
        this.writer.writeStartElement(s);
    }

    @Override
    public void writeStartElement(String s, String s1) throws XMLStreamException {
        this.writer.writeStartElement(s, s1);
    }

    @Override
    public void writeStartElement(String s, String s1, String s2) throws XMLStreamException {
        this.writer.writeStartElement(s, s1, s2);
    }

    @Override
    public void writeEmptyElement(String s, String s1) throws XMLStreamException {
        this.writer.writeEmptyElement(s, s1);
    }

    @Override
    public void writeEmptyElement(String s, String s1, String s2) throws XMLStreamException {
        this.writer.writeEmptyElement(s, s1, s2);
    }

    @Override
    public void writeEmptyElement(String s) throws XMLStreamException {
        this.writer.writeEmptyElement(s);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.writer.writeEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.writer.writeEndDocument();
    }

    @Override
    public void close() throws XMLStreamException {
        this.writer.close();
    }

    @Override
    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(localName, CleanXMLStreamWriter.escapeCharacters(value));
    }

    @Override
    public void writeAttribute(String prefix, String namespaceUri, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(prefix, namespaceUri, localName, CleanXMLStreamWriter.escapeCharacters(value));
    }

    @Override
    public void writeAttribute(String namespaceUri, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(namespaceUri, localName, CleanXMLStreamWriter.escapeCharacters(value));
    }

    @Override
    public void writeNamespace(String s, String s1) throws XMLStreamException {
        this.writer.writeNamespace(s, s1);
    }

    @Override
    public void writeDefaultNamespace(String s) throws XMLStreamException {
        this.writer.writeDefaultNamespace(s);
    }

    @Override
    public void writeComment(String s) throws XMLStreamException {
        this.writer.writeComment(s);
    }

    @Override
    public void writeProcessingInstruction(String s) throws XMLStreamException {
        this.writer.writeProcessingInstruction(s);
    }

    @Override
    public void writeProcessingInstruction(String s, String s1) throws XMLStreamException {
        this.writer.writeProcessingInstruction(s, s1);
    }

    @Override
    public void writeCData(String s) throws XMLStreamException {
        this.writer.writeCData(CleanXMLStreamWriter.escapeCharacters(s));
    }

    @Override
    public void writeDTD(String s) throws XMLStreamException {
        this.writer.writeDTD(s);
    }

    @Override
    public void writeEntityRef(String s) throws XMLStreamException {
        this.writer.writeEntityRef(s);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.writer.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String s) throws XMLStreamException {
        this.writer.writeStartDocument(s);
    }

    @Override
    public void writeStartDocument(String s, String s1) throws XMLStreamException {
        this.writer.writeStartDocument(s, s1);
    }

    @Override
    public void writeCharacters(String s) throws XMLStreamException {
        this.writer.writeCharacters(CleanXMLStreamWriter.escapeCharacters(s));
    }

    @Override
    public void writeCharacters(char[] chars, int start, int len) throws XMLStreamException {
        this.writer.writeCharacters(CleanXMLStreamWriter.escapeCharacters(new String(chars, start, len)));
    }

    @Override
    public String getPrefix(String s) throws XMLStreamException {
        return this.writer.getPrefix(s);
    }

    @Override
    public void setPrefix(String s, String s1) throws XMLStreamException {
        this.writer.setPrefix(s, s1);
    }

    @Override
    public void setDefaultNamespace(String s) throws XMLStreamException {
        this.writer.setDefaultNamespace(s);
    }

    @Override
    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.writer.setNamespaceContext(namespaceContext);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }

    @Override
    public Object getProperty(String s) throws IllegalArgumentException {
        return this.writer.getProperty(s);
    }

    protected static boolean isLegalXmlCodePoint(int c) {
        return c >= 32 && c <= 55295 || c >= 57344 && c <= 65533 || c >= 65536 && c <= 0x10FFFF || c == 9 || c == 10 || c == 13;
    }
}

