/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.gedcomx.Gedcomx;
import org.gedcomx.rt.json.GedcomJacksonModule;
import org.gedcomx.util.RecordSetIterator;

public class JsonRecordSetIterator
implements RecordSetIterator {
    private InputStream inputStream;
    private Gedcomx nextRecord;
    private Gedcomx metadata;
    private ObjectMapper objectMapper;
    private String id;
    private boolean noMoreRecords = false;

    public JsonRecordSetIterator(String filename) throws IOException {
        this(new FileInputStream(filename), filename.toLowerCase().endsWith(".gz"));
    }

    public JsonRecordSetIterator(InputStream inputStream, boolean isGzipped) throws IOException {
        this(isGzipped ? new GZIPInputStream(inputStream) : inputStream);
    }

    public JsonRecordSetIterator(InputStream inputStream) throws IOException {
        this.inputStream = new BufferedInputStream(inputStream);
        this.objectMapper = GedcomJacksonModule.createObjectMapper((Class[])new Class[0]);
        int character = inputStream.read();
        assert (character == 123);
        this.noMoreRecords = false;
        this.readUntil(inputStream, "records");
        this.readUntilChar(inputStream, '[');
        this.prepareNext();
    }

    private void readUntil(InputStream inputStream, String untilLabel) throws IOException {
        String name;
        while (!(name = this.getName(inputStream)).equals(untilLabel) && !name.equals(untilLabel)) {
            if (name.equals("metadata")) {
                this.readMetadata(inputStream);
                continue;
            }
            if (!name.equals("id")) continue;
            this.id = this.getName(inputStream, false);
        }
    }

    private void readMetadata(InputStream inputStream) throws IOException {
        byte[] object = this.getObjectAsBytes(inputStream);
        this.metadata = (Gedcomx)this.objectMapper.readValue(object, Gedcomx.class);
    }

    private byte[] getObjectAsBytes(InputStream inputStream) throws IOException {
        int character;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int openingBraces = 0;
        int closingBraces = 0;
        boolean firstTime = true;
        while ((character = inputStream.read()) >= 0) {
            if (character == 44 && firstTime) {
                firstTime = false;
                continue;
            }
            firstTime = false;
            bos.write(character);
            if (character == 123) {
                ++openingBraces;
            } else if (character == 125) {
                ++closingBraces;
            }
            if (openingBraces <= 0 || openingBraces != closingBraces) continue;
            break;
        }
        return bos.toByteArray();
    }

    private String getName(InputStream inputStream) throws IOException {
        return this.getName(inputStream, true);
    }

    private String getName(InputStream inputStream, boolean consumeColon) throws IOException {
        int character;
        StringBuilder name = new StringBuilder();
        this.readUntilChar(inputStream, '\"');
        while ((character = inputStream.read()) != 34) {
            name.append((char)character);
        }
        if (consumeColon) {
            this.readUntilChar(inputStream, ':');
        }
        return name.toString();
    }

    private void readUntilChar(InputStream inputStream, char c) throws IOException {
        int character;
        while ((character = inputStream.read()) != c) {
            if (character >= 0) continue;
            this.close();
            break;
        }
    }

    @Override
    public synchronized boolean hasNext() {
        return this.nextRecord != null;
    }

    private synchronized void prepareNext() throws IOException {
        int character;
        if (this.noMoreRecords) {
            this.nextRecord = null;
            return;
        }
        byte[] object = this.getObjectAsBytes(this.inputStream);
        this.nextRecord = (Gedcomx)this.objectMapper.readValue(object, Gedcomx.class);
        while ((character = this.inputStream.read()) != 44) {
            if (character != 93) continue;
            this.noMoreRecords = true;
            break;
        }
    }

    @Override
    public synchronized Gedcomx next() {
        try {
            if (this.nextRecord == null) {
                return null;
            }
            Gedcomx record = this.nextRecord;
            this.prepareNext();
            return record;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized Gedcomx getMetadata() {
        if (this.metadata == null) {
            try {
                this.readUntil(this.inputStream, "metadata");
                this.readMetadata(this.inputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.metadata;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                this.inputStream = null;
            }
            finally {
                this.inputStream = null;
            }
        }
    }

    public String getId() throws IOException {
        if (this.id == null) {
            this.readUntil(this.inputStream, "id");
            this.id = this.getName(this.inputStream, false);
        }
        return this.id;
    }
}

