/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.conclusion;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webcohesion.enunciate.metadata.ClientName;
import com.webcohesion.enunciate.metadata.Facet;
import com.webcohesion.enunciate.metadata.qname.XmlQNameEnumRef;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.gedcomx.common.ExtensibleData;
import org.gedcomx.common.TextValue;
import org.gedcomx.common.URI;
import org.gedcomx.date.GedcomxDate;
import org.gedcomx.records.Field;
import org.gedcomx.records.HasFields;
import org.gedcomx.rt.GedcomxModelVisitor;
import org.gedcomx.types.ConfidenceLevel;

@ClientName(value="DateInfo")
@XmlType(name="Date", propOrder={"original", "formal", "normalizedExtensions", "fields"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Date
extends ExtensibleData
implements HasFields {
    private String original;
    private String formal;
    private URI confidence;
    private List<TextValue> normalized;
    private List<Field> fields;

    @Override
    public Date id(String id) {
        return (Date)super.id(id);
    }

    @Override
    public Date extensionElement(Object element) {
        return (Date)super.extensionElement(element);
    }

    public String getOriginal() {
        return this.original;
    }

    public void setOriginal(String original) {
        this.original = original;
    }

    public Date original(String original) {
        this.setOriginal(original);
        return this;
    }

    public String getFormal() {
        return this.formal;
    }

    public void setFormal(String formal) {
        this.formal = formal;
    }

    @XmlTransient
    @JsonIgnore
    public void setFormalDate(GedcomxDate formal) {
        if (formal != null) {
            this.setFormal(formal.toFormalString());
        }
    }

    public Date formal(String formal) {
        this.setFormal(formal);
        return this;
    }

    public Date formal(GedcomxDate formal) {
        return this.formal(formal.toFormalString());
    }

    @XmlAttribute
    @XmlQNameEnumRef(value=ConfidenceLevel.class)
    public URI getConfidence() {
        return this.confidence;
    }

    public void setConfidence(URI confidence) {
        this.confidence = confidence;
    }

    public Date confidence(URI confidence) {
        this.setConfidence(confidence);
        return this;
    }

    public Date confidence(ConfidenceLevel confidence) {
        this.setKnownConfidenceLevel(confidence);
        return this;
    }

    @XmlTransient
    @JsonIgnore
    public ConfidenceLevel getKnownConfidenceLevel() {
        return this.getConfidence() == null ? null : ConfidenceLevel.fromQNameURI(this.getConfidence());
    }

    @JsonIgnore
    public void setKnownConfidenceLevel(ConfidenceLevel level) {
        this.setConfidence(level == null ? null : level.toQNameURI());
    }

    public Stream<TextValue> normalizedExtensions() {
        return this.normalized == null ? Stream.empty() : this.normalized.stream();
    }

    @XmlElement(name="normalized")
    @JsonProperty(value="normalized")
    @Facet(value="http://rs.gedcomx.org/")
    public List<TextValue> getNormalizedExtensions() {
        return this.normalized;
    }

    @JsonProperty(value="normalized")
    public void setNormalizedExtensions(List<TextValue> normalized) {
        this.normalized = normalized;
    }

    public void addNormalizedExtension(TextValue normalizedExtension) {
        if (normalizedExtension != null) {
            if (this.normalized == null) {
                this.normalized = new LinkedList<TextValue>();
            }
            this.normalized.add(normalizedExtension);
        }
    }

    @Override
    @XmlElement(name="field")
    @JsonProperty(value="fields")
    @Facet(value="http://record.gedcomx.org/")
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    @JsonProperty(value="fields")
    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public Date field(Field field) {
        this.addField(field);
        return this;
    }

    public void addField(Field field) {
        if (field != null) {
            if (this.fields == null) {
                this.fields = new LinkedList<Field>();
            }
            this.fields.add(field);
        }
    }

    @Override
    public String toString() {
        return "Date{original='" + this.original + '\'' + ", formal=" + this.formal + '}';
    }

    public void accept(GedcomxModelVisitor visitor) {
        visitor.visitDate(this);
    }
}

