/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.gedcomx.Gedcomx;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.TextValue;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.Fact;
import org.gedcomx.conclusion.Name;
import org.gedcomx.conclusion.NameForm;
import org.gedcomx.conclusion.NamePart;
import org.gedcomx.conclusion.Person;
import org.gedcomx.conclusion.Relationship;
import org.gedcomx.records.Field;
import org.gedcomx.records.FieldDescriptor;
import org.gedcomx.records.FieldValue;
import org.gedcomx.records.FieldValueDescriptor;
import org.gedcomx.records.RecordDescriptor;
import org.gedcomx.source.Coverage;
import org.gedcomx.source.SourceDescription;
import org.gedcomx.types.RecordType;
import org.gedcomx.util.DocMap;
import org.gedcomx.util.LocaleUtil;

public class FieldMap {
    private DocMap collectionDocMap;
    private DocMap recordDocMap;
    private RecordDescriptor recordDescriptor;
    private boolean isCensus;
    private Map<String, FieldValueDescriptor> labelFieldValueDescriptorMap;
    private Map<String, List<String>> labelValueMap;
    private Map<Person, Map<String, List<String>>> personLabelValueMap;

    public FieldMap(Gedcomx record, Gedcomx collection) {
        this(new DocMap(record), new DocMap(collection));
    }

    public FieldMap(DocMap recordDocMap, DocMap collectionDocMap) {
        this.collectionDocMap = collectionDocMap;
        this.recordDocMap = recordDocMap;
        this.recordDescriptor = FieldMap.getRecordDescriptor(collectionDocMap, recordDocMap);
        this.labelFieldValueDescriptorMap = FieldMap.getLabelFieldValueDescriptorMap(this.recordDescriptor);
        this.isCensus = FieldMap.isCensus(recordDocMap);
        if (this.isCensus) {
            this.personLabelValueMap = FieldMap.getPersonLabelValueMap(recordDocMap.getDocument());
        } else {
            this.labelValueMap = FieldMap.getLabelValuesMap(FieldMap.getAllFields(recordDocMap.getDocument()));
        }
    }

    public DocMap getCollectionDocMap() {
        return this.collectionDocMap;
    }

    public DocMap getRecordDocMap() {
        return this.recordDocMap;
    }

    public Gedcomx getCollection() {
        return this.collectionDocMap.getDocument();
    }

    public Gedcomx getRecord() {
        return this.collectionDocMap.getDocument();
    }

    public String getDisplayLabel(String labelId, String language) {
        FieldValueDescriptor fieldValueDescriptor;
        if (this.labelFieldValueDescriptorMap != null && (fieldValueDescriptor = this.labelFieldValueDescriptorMap.get(labelId)) != null && fieldValueDescriptor.getDisplayLabels() != null) {
            TextValue bestValue = LocaleUtil.findClosestLocale(fieldValueDescriptor.getDisplayLabels(), new Locale(language));
            return bestValue == null ? null : bestValue.getValue();
        }
        return null;
    }

    public List<String> getValues(String labelId) {
        if (this.isCensus) {
            throw new IllegalArgumentException("Can't call getValues(labelId) on census collection. Use getValues(person, labelId) instead.");
        }
        return this.labelValueMap.get(labelId);
    }

    public List<String> getValues(Person person, String labelId) {
        if (!this.isCensus) {
            throw new IllegalArgumentException("Can't call getValues(person, labelId) on non-census collection");
        }
        Map<String, List<String>> labelValueMap = this.personLabelValueMap.get(person);
        return labelValueMap == null ? null : labelValueMap.get(labelId);
    }

    public FieldValueDescriptor getFieldValueDescriptor(String labelId) {
        return this.labelFieldValueDescriptorMap == null ? null : this.labelFieldValueDescriptorMap.get(labelId);
    }

    private static Map<Person, Map<String, List<String>>> getPersonLabelValueMap(Gedcomx record) {
        Map<Person, List<Field>> personFieldMap = FieldMap.getPersonFieldMap(record);
        LinkedHashMap<Person, Map<String, List<String>>> personMap = new LinkedHashMap<Person, Map<String, List<String>>>();
        for (Person person : personFieldMap.keySet()) {
            personMap.put(person, FieldMap.getLabelValuesMap(personFieldMap.get(person)));
        }
        return personMap;
    }

    public Map<String, List<String>> getPersonLabelValueMap(Person person) {
        if (!this.isCensus) {
            throw new IllegalArgumentException("Can't call getPersonLabelValueMap(person) on non-census collection");
        }
        return this.personLabelValueMap.get(person);
    }

    public Map<String, List<String>> getLabelValueMap() {
        if (this.isCensus) {
            throw new IllegalArgumentException("Can't call getLabelValueMap() on census collection. Use getPersonLabelValueMap(person), and use person=null for record-level values.");
        }
        return this.labelValueMap;
    }

    public Map<String, FieldValueDescriptor> getLabelFieldValueDescriptorMap() {
        return this.labelFieldValueDescriptorMap;
    }

    public RecordDescriptor getRecordDescriptor() {
        return this.recordDescriptor;
    }

    public static RecordDescriptor getRecordDescriptor(DocMap collectionDocMap, DocMap recordDocMap) {
        int pos;
        String uri;
        ResourceReference ref = recordDocMap.getMainSourceDescription().getDescriptorRef();
        if (ref != null && ref.getResource() != null && (uri = ref.getResource().toString()) != null && (pos = uri.indexOf("#")) > 0) {
            return collectionDocMap.getRecordDescriptor(uri.substring(pos + 1));
        }
        return null;
    }

    public static Map<String, FieldValueDescriptor> getLabelFieldValueDescriptorMap(RecordDescriptor recordDescriptor) {
        if (recordDescriptor != null && recordDescriptor.getFields() != null) {
            LinkedHashMap<String, FieldValueDescriptor> map = new LinkedHashMap<String, FieldValueDescriptor>();
            for (FieldDescriptor fieldDescriptor : recordDescriptor.getFields()) {
                if (fieldDescriptor.getValues() == null) continue;
                for (FieldValueDescriptor fieldValueDescriptor : fieldDescriptor.getValues()) {
                    if (map.get(fieldValueDescriptor.getLabelId()) != null) {
                        throw new IllegalStateException("Multiple field value descriptors for label id '" + fieldValueDescriptor.getLabelId() + "'");
                    }
                    map.put(fieldValueDescriptor.getLabelId(), fieldValueDescriptor);
                }
            }
            return map;
        }
        return null;
    }

    public static Map<Person, List<Field>> getPersonFieldMap(Gedcomx record) {
        LinkedHashMap<Person, List<Field>> personFieldsMap = new LinkedHashMap<Person, List<Field>>();
        FieldMap.addFields(record.getFields(), null, personFieldsMap);
        if (record.getPersons() != null) {
            for (Person person : record.getPersons()) {
                FieldMap.addFields(person.getFields(), person, personFieldsMap);
                if (person.getGender() != null) {
                    FieldMap.addFields(person.getGender().getFields(), person, personFieldsMap);
                }
                if (person.getNames() != null) {
                    for (Name name : person.getNames()) {
                        if (name.getNameForms() == null) continue;
                        for (NameForm nameForm : name.getNameForms()) {
                            FieldMap.addFields(nameForm.getFields(), person, personFieldsMap);
                            if (nameForm.getParts() == null) continue;
                            for (NamePart namePart : nameForm.getParts()) {
                                FieldMap.addFields(namePart.getFields(), person, personFieldsMap);
                            }
                        }
                    }
                }
                if (person.getFacts() == null) continue;
                for (Fact fact : person.getFacts()) {
                    FieldMap.addFields(fact.getFields(), person, personFieldsMap);
                    if (fact.getDate() != null) {
                        FieldMap.addFields(fact.getDate().getFields(), person, personFieldsMap);
                    }
                    if (fact.getPlace() == null) continue;
                    FieldMap.addFields(fact.getPlace().getFields(), person, personFieldsMap);
                }
            }
        }
        return personFieldsMap;
    }

    public static List<Field> getAllFields(Gedcomx record) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Map<Person, List<Field>> personFieldMap = FieldMap.getPersonFieldMap(record);
        if (record.getPersons() != null) {
            for (Person person : record.getPersons()) {
                FieldMap.addFields(personFieldMap.get(person), fields);
            }
        }
        if (record.getRelationships() != null) {
            for (Relationship relationship : record.getRelationships()) {
                FieldMap.addFields(relationship.getFields(), fields);
                if (relationship.getFacts() == null) continue;
                for (Fact fact : relationship.getFacts()) {
                    FieldMap.addFields(fact.getFields(), fields);
                    if (fact.getDate() != null) {
                        FieldMap.addFields(fact.getFields(), fields);
                    }
                    if (fact.getPlace() == null) continue;
                    FieldMap.addFields(fact.getFields(), fields);
                }
            }
        }
        if (record.getSourceDescriptions() != null) {
            for (SourceDescription sourceDescription : record.getSourceDescriptions()) {
                FieldMap.addFields(sourceDescription.getFields(), fields);
            }
        }
        FieldMap.addFields(personFieldMap.get(null), fields);
        return fields;
    }

    public static Map<String, List<String>> getLabelValuesMap(List<Field> fields) {
        LinkedHashMap<String, List<String>> labelValueMap = new LinkedHashMap<String, List<String>>();
        if (fields != null) {
            for (Field field : fields) {
                if (field.getValues() == null) continue;
                for (FieldValue fieldValue : field.getValues()) {
                    ArrayList<String> values = (ArrayList<String>)labelValueMap.get(fieldValue.getLabelId());
                    if (values == null) {
                        values = new ArrayList<String>();
                        labelValueMap.put(fieldValue.getLabelId(), values);
                    }
                    values.add(fieldValue.getText());
                }
            }
        }
        return labelValueMap;
    }

    private static void addFields(List<Field> listToAdd, Person person, Map<Person, List<Field>> personFieldMap) {
        if (listToAdd != null) {
            List<Field> fieldList = personFieldMap.get(person);
            if (fieldList == null) {
                fieldList = new ArrayList<Field>();
                personFieldMap.put(person, fieldList);
            }
            fieldList.addAll(listToAdd);
        }
    }

    private static void addFields(List<Field> listToAdd, List<Field> allFields) {
        if (listToAdd != null) {
            allFields.addAll(listToAdd);
        }
    }

    public static boolean isCensus(Gedcomx record) {
        URI descriptionRef = record.getDescriptionRef();
        if (descriptionRef != null) {
            for (SourceDescription sourceDescription : record.getSourceDescriptions()) {
                if (!("#" + sourceDescription.getId()).equals(descriptionRef.toString())) continue;
                return FieldMap.isCensus(sourceDescription);
            }
        }
        return false;
    }

    public static boolean isCensus(DocMap recordDocMap) {
        return FieldMap.isCensus(recordDocMap.getMainSourceDescription());
    }

    public static boolean isCensus(SourceDescription sourceDescription) {
        if (sourceDescription != null && sourceDescription.getCoverage() != null) {
            for (Coverage coverage : sourceDescription.getCoverage()) {
                if (coverage.getKnownRecordType() != RecordType.Census) continue;
                return true;
            }
        }
        return false;
    }
}

