/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.agent;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.gedcomx.agent.Address;
import org.gedcomx.agent.OnlineAccount;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.TextValue;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.Identifier;
import org.gedcomx.links.HypermediaEnabledData;
import org.gedcomx.links.Link;
import org.gedcomx.rt.GedcomxModelVisitor;
import org.gedcomx.rt.json.JsonElementWrapper;

@XmlRootElement
@XmlType(name="Agent")
@JsonElementWrapper(name="agents")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Agent
extends HypermediaEnabledData {
    private List<TextValue> names;
    private List<Identifier> identifiers;
    private ResourceReference homepage;
    private ResourceReference openid;
    private List<OnlineAccount> accounts;
    private List<ResourceReference> emails;
    private List<ResourceReference> phones;
    private List<Address> addresses;

    @Override
    public Agent id(String id) {
        return (Agent)super.id(id);
    }

    @Override
    public Agent extensionElement(Object element) {
        return (Agent)super.extensionElement(element);
    }

    @Override
    public Agent link(String rel, URI href) {
        return (Agent)super.link(rel, href);
    }

    @Override
    public Agent link(Link link) {
        return (Agent)super.link(link);
    }

    @XmlTransient
    @com.fasterxml.jackson.annotation.JsonIgnore
    @JsonIgnore
    public TextValue getName() {
        return this.names == null || this.names.isEmpty() ? null : this.names.get(0);
    }

    @XmlElement(name="name")
    @JsonProperty(value="names")
    @org.codehaus.jackson.annotate.JsonProperty(value="names")
    public List<TextValue> getNames() {
        return this.names;
    }

    @JsonProperty(value="names")
    @org.codehaus.jackson.annotate.JsonProperty(value="names")
    public void setNames(List<TextValue> names) {
        this.names = names;
    }

    public Agent name(TextValue name) {
        this.addName(name);
        return this;
    }

    public Agent name(String name) {
        return this.name(new TextValue(name));
    }

    public void addName(TextValue name) {
        if (this.names == null) {
            this.names = new ArrayList<TextValue>();
        }
        this.names.add(name);
    }

    @XmlElement(name="identifier")
    @JsonProperty(value="identifiers")
    @org.codehaus.jackson.annotate.JsonProperty(value="identifiers")
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    @JsonProperty(value="identifiers")
    @org.codehaus.jackson.annotate.JsonProperty(value="identifiers")
    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    public Agent identifier(Identifier identifier) {
        this.addIdentifier(identifier);
        return this;
    }

    public void addIdentifier(Identifier identifier) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.add(identifier);
    }

    public ResourceReference getHomepage() {
        return this.homepage;
    }

    public void setHomepage(ResourceReference homepage) {
        this.homepage = homepage;
    }

    public Agent homepage(ResourceReference homepage) {
        this.homepage = homepage;
        return this;
    }

    public Agent homepage(URI homepage) {
        return this.homepage(new ResourceReference(homepage));
    }

    public ResourceReference getOpenid() {
        return this.openid;
    }

    public void setOpenid(ResourceReference openid) {
        this.openid = openid;
    }

    public Agent openid(ResourceReference openid) {
        this.openid = openid;
        return this;
    }

    public Agent openid(URI openid) {
        return this.openid(new ResourceReference(openid));
    }

    @XmlElement(name="account")
    @JsonProperty(value="accounts")
    @org.codehaus.jackson.annotate.JsonProperty(value="accounts")
    public List<OnlineAccount> getAccounts() {
        return this.accounts;
    }

    @JsonProperty(value="accounts")
    @org.codehaus.jackson.annotate.JsonProperty(value="accounts")
    public void setAccounts(List<OnlineAccount> accounts) {
        this.accounts = accounts;
    }

    public Agent account(OnlineAccount account) {
        this.addAccount(account);
        return this;
    }

    public void addAccount(OnlineAccount account) {
        if (this.accounts == null) {
            this.accounts = new ArrayList<OnlineAccount>();
        }
        this.accounts.add(account);
    }

    @XmlElement(name="email")
    @JsonProperty(value="emails")
    @org.codehaus.jackson.annotate.JsonProperty(value="emails")
    public List<ResourceReference> getEmails() {
        return this.emails;
    }

    @JsonProperty(value="emails")
    @org.codehaus.jackson.annotate.JsonProperty(value="emails")
    public void setEmails(List<ResourceReference> emails) {
        this.emails = emails;
    }

    public Agent email(ResourceReference email) {
        this.addEmail(email);
        return this;
    }

    public Agent email(URI email) {
        return this.email(new ResourceReference(email));
    }

    public Agent email(String email) {
        return this.email(URI.create("mailto:" + email));
    }

    public void addEmail(ResourceReference email) {
        if (this.emails == null) {
            this.emails = new ArrayList<ResourceReference>();
        }
        this.emails.add(email);
    }

    @XmlElement(name="phone")
    @JsonProperty(value="phones")
    @org.codehaus.jackson.annotate.JsonProperty(value="phones")
    public List<ResourceReference> getPhones() {
        return this.phones;
    }

    @JsonProperty(value="phones")
    @org.codehaus.jackson.annotate.JsonProperty(value="phones")
    public void setPhones(List<ResourceReference> phones) {
        this.phones = phones;
    }

    public Agent phone(ResourceReference phone) {
        this.addPhone(phone);
        return this;
    }

    public Agent phone(URI phone) {
        return this.phone(new ResourceReference(phone));
    }

    public Agent phone(String phone) {
        return this.phone(URI.create("tel:" + phone));
    }

    public void addPhone(ResourceReference phone) {
        if (this.phones == null) {
            this.phones = new ArrayList<ResourceReference>();
        }
        this.phones.add(phone);
    }

    @XmlElement(name="address")
    @JsonProperty(value="addresses")
    @org.codehaus.jackson.annotate.JsonProperty(value="addresses")
    public List<Address> getAddresses() {
        return this.addresses;
    }

    @JsonProperty(value="addresses")
    @org.codehaus.jackson.annotate.JsonProperty(value="addresses")
    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public Agent address(Address address) {
        this.addAddress(address);
        return this;
    }

    public void addAddress(Address address) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<Address>();
        }
        this.addresses.add(address);
    }

    public void accept(GedcomxModelVisitor visitor) {
        visitor.visitAgent(this);
    }

    public void embed(Agent agent) {
        if (agent.names != null) {
            this.names = this.names == null ? new ArrayList() : this.names;
            this.names.addAll(agent.names);
        }
        if (agent.identifiers != null) {
            this.identifiers = this.identifiers == null ? new ArrayList() : this.identifiers;
            this.identifiers.addAll(agent.identifiers);
        }
        if (agent.accounts != null) {
            this.accounts = this.accounts == null ? new ArrayList() : this.accounts;
            this.accounts.addAll(agent.accounts);
        }
        if (agent.emails != null) {
            this.emails = this.emails == null ? new ArrayList() : this.emails;
            this.emails.addAll(agent.emails);
        }
        if (agent.phones != null) {
            this.phones = this.phones == null ? new ArrayList() : this.phones;
            this.phones.addAll(agent.phones);
        }
        if (agent.addresses != null) {
            this.addresses = this.addresses == null ? new ArrayList() : this.addresses;
            this.addresses.addAll(agent.addresses);
        }
        this.homepage = this.homepage == null ? agent.homepage : this.homepage;
        this.openid = this.openid == null ? agent.openid : this.openid;
        super.embed(agent);
    }
}

