/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.source;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webcohesion.enunciate.metadata.Facet;
import com.webcohesion.enunciate.metadata.Facets;
import com.webcohesion.enunciate.metadata.qname.XmlQNameEnumRef;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.gedcomx.agent.Agent;
import org.gedcomx.common.Attributable;
import org.gedcomx.common.Attribution;
import org.gedcomx.common.HasNotes;
import org.gedcomx.common.Note;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.TextValue;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.Identifier;
import org.gedcomx.links.HypermediaEnabledData;
import org.gedcomx.links.Link;
import org.gedcomx.records.Field;
import org.gedcomx.records.HasFields;
import org.gedcomx.rt.GedcomxModelVisitor;
import org.gedcomx.rt.json.JsonElementWrapper;
import org.gedcomx.source.Coverage;
import org.gedcomx.source.ReferencesSources;
import org.gedcomx.source.SourceCitation;
import org.gedcomx.source.SourceReference;
import org.gedcomx.types.IdentifierType;
import org.gedcomx.types.ResourceStatusType;
import org.gedcomx.types.ResourceType;

@XmlRootElement
@XmlType(name="SourceDescription", propOrder={"citations", "mediator", "sources", "analysis", "componentOf", "titles", "titleLabel", "notes", "attribution", "descriptions", "identifiers", "created", "modified", "coverage", "rights", "fields", "repository", "descriptorRef", "replacedBy", "replaces", "statuses"})
@JsonElementWrapper(name="sourceDescriptions")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SourceDescription
extends HypermediaEnabledData
implements Attributable,
HasNotes,
HasFields,
ReferencesSources {
    private String lang;
    private List<SourceCitation> citations;
    private String mediaType;
    private URI about;
    private ResourceReference mediator;
    private List<SourceReference> sources;
    private ResourceReference analysis;
    private SourceReference componentOf;
    private List<TextValue> titles;
    private TextValue titleLabel;
    private List<Note> notes;
    private Attribution attribution;
    private URI resourceType;
    private List<URI> rights;
    private String sortKey;
    private List<TextValue> descriptions;
    private List<Identifier> identifiers;
    private Date created;
    private Date modified;
    private List<Coverage> coverage;
    private List<Field> fields;
    private ResourceReference repository;
    private ResourceReference descriptorRef;
    private URI replacedBy;
    private List<URI> replaces;
    private String version;
    private List<URI> statuses;

    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public SourceDescription lang(String lang) {
        this.setLang(lang);
        return this;
    }

    @Override
    public SourceDescription id(String id) {
        return (SourceDescription)super.id(id);
    }

    @Override
    public SourceDescription extensionElement(Object element) {
        return (SourceDescription)super.extensionElement(element);
    }

    @Override
    public SourceDescription link(String rel, URI href) {
        return (SourceDescription)super.link(rel, href);
    }

    @Override
    public SourceDescription link(Link link) {
        return (SourceDescription)super.link(link);
    }

    @XmlAttribute
    @XmlQNameEnumRef(value=ResourceType.class)
    public URI getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(URI resourceType) {
        this.resourceType = resourceType;
    }

    public SourceDescription resourceType(URI resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public SourceDescription resourceType(ResourceType resourceType) {
        this.setKnownType(resourceType);
        return this;
    }

    @XmlTransient
    @com.fasterxml.jackson.annotation.JsonIgnore
    @JsonIgnore
    public ResourceType getKnownType() {
        return this.getResourceType() == null ? null : ResourceType.fromQNameURI(this.getResourceType());
    }

    @com.fasterxml.jackson.annotation.JsonIgnore
    @JsonIgnore
    public void setKnownType(ResourceType type) {
        this.setResourceType(type == null ? null : type.toQNameURI());
    }

    @XmlElement(name="rights")
    @JsonProperty(value="rights")
    @org.codehaus.jackson.annotate.JsonProperty(value="rights")
    public List<URI> getRights() {
        return this.rights;
    }

    @JsonProperty(value="rights")
    @org.codehaus.jackson.annotate.JsonProperty(value="rights")
    public void setRights(List<URI> rights) {
        this.rights = rights;
    }

    public SourceDescription rights(URI rights) {
        this.addRights(rights);
        return this;
    }

    public void addRights(URI rights) {
        if (rights != null) {
            if (this.rights == null) {
                this.rights = new LinkedList<URI>();
            }
            this.rights.add(rights);
        }
    }

    @XmlTransient
    @com.fasterxml.jackson.annotation.JsonIgnore
    @JsonIgnore
    public SourceCitation getCitation() {
        return this.citations == null || this.citations.isEmpty() ? null : this.citations.get(0);
    }

    @XmlElement(name="citation")
    @JsonProperty(value="citations")
    @org.codehaus.jackson.annotate.JsonProperty(value="citations")
    public List<SourceCitation> getCitations() {
        return this.citations;
    }

    @JsonProperty(value="citations")
    @org.codehaus.jackson.annotate.JsonProperty(value="citations")
    public void setCitations(List<SourceCitation> citations) {
        this.citations = citations;
    }

    public SourceDescription citation(SourceCitation citation) {
        this.addCitation(citation);
        return this;
    }

    public SourceDescription citation(String citation) {
        this.addCitation(new SourceCitation().value(citation));
        return this;
    }

    public void addCitation(SourceCitation citation) {
        if (citation != null) {
            if (this.citations == null) {
                this.citations = new LinkedList<SourceCitation>();
            }
            this.citations.add(citation);
        }
    }

    @XmlAttribute
    public String getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public SourceDescription mediaType(String mediaType) {
        this.setMediaType(mediaType);
        return this;
    }

    @XmlAttribute
    @XmlSchemaType(name="anyURI", namespace="http://www.w3.org/2001/XMLSchema")
    public URI getAbout() {
        return this.about;
    }

    public void setAbout(URI about) {
        this.about = about;
    }

    public SourceDescription about(URI about) {
        this.setAbout(about);
        return this;
    }

    public ResourceReference getMediator() {
        return this.mediator;
    }

    public void setMediator(ResourceReference mediator) {
        this.mediator = mediator;
    }

    public SourceDescription mediator(ResourceReference mediator) {
        this.setMediator(mediator);
        return this;
    }

    @XmlTransient
    @com.fasterxml.jackson.annotation.JsonIgnore
    @JsonIgnore
    public void setMediatorURI(URI mediator) {
        this.mediator = mediator != null ? new ResourceReference(mediator) : null;
    }

    @Override
    @XmlElement(name="source")
    @JsonProperty(value="sources")
    @org.codehaus.jackson.annotate.JsonProperty(value="sources")
    public List<SourceReference> getSources() {
        return this.sources;
    }

    @Override
    @JsonProperty(value="sources")
    @org.codehaus.jackson.annotate.JsonProperty(value="sources")
    public void setSources(List<SourceReference> sources) {
        this.sources = sources;
    }

    public SourceDescription source(SourceReference source) {
        if (this.sources == null) {
            this.sources = new ArrayList<SourceReference>();
        }
        this.sources.add(source);
        return this;
    }

    public ResourceReference getAnalysis() {
        return this.analysis;
    }

    public void setAnalysis(ResourceReference analysis) {
        this.analysis = analysis;
    }

    public SourceDescription analysis(ResourceReference analysis) {
        this.setAnalysis(analysis);
        return this;
    }

    public SourceReference getComponentOf() {
        return this.componentOf;
    }

    public void setComponentOf(SourceReference componentOf) {
        this.componentOf = componentOf;
    }

    public SourceDescription componentOf(SourceReference componentOf) {
        this.setComponentOf(componentOf);
        return this;
    }

    public SourceDescription componentOf(SourceDescription componentOf) {
        this.setComponentOf(new SourceReference().description(componentOf));
        return this;
    }

    @XmlTransient
    @com.fasterxml.jackson.annotation.JsonIgnore
    @JsonIgnore
    public TextValue getTitle() {
        return this.titles == null || this.titles.isEmpty() ? null : this.titles.get(0);
    }

    @XmlElement(name="title")
    @JsonProperty(value="titles")
    @org.codehaus.jackson.annotate.JsonProperty(value="titles")
    public List<TextValue> getTitles() {
        return this.titles;
    }

    @JsonProperty(value="titles")
    @org.codehaus.jackson.annotate.JsonProperty(value="titles")
    public void setTitles(List<TextValue> titles) {
        this.titles = titles;
    }

    public SourceDescription title(TextValue title) {
        if (this.titles == null) {
            this.titles = new ArrayList<TextValue>();
        }
        this.titles.add(title);
        return this;
    }

    public SourceDescription title(String title) {
        return this.title(new TextValue(title));
    }

    @Facets(value={@Facet(value="http://record.gedcomx.org/"), @Facet(value="http://rs.gedcomx.org/")})
    public TextValue getTitleLabel() {
        return this.titleLabel;
    }

    public void setTitleLabel(TextValue titleLabel) {
        this.titleLabel = titleLabel;
    }

    public SourceDescription titleLabel(TextValue titleLabel) {
        this.setTitleLabel(titleLabel);
        return this;
    }

    @Override
    @XmlElement(name="note")
    @JsonProperty(value="notes")
    @org.codehaus.jackson.annotate.JsonProperty(value="notes")
    public List<Note> getNotes() {
        return this.notes;
    }

    @Override
    @JsonProperty(value="notes")
    @org.codehaus.jackson.annotate.JsonProperty(value="notes")
    public void setNotes(List<Note> notes) {
        this.notes = notes;
    }

    public SourceDescription note(Note note) {
        if (this.notes == null) {
            this.notes = new ArrayList<Note>();
        }
        this.notes.add(note);
        return this;
    }

    @Override
    public Attribution getAttribution() {
        return this.attribution;
    }

    @Override
    public void setAttribution(Attribution attribution) {
        this.attribution = attribution;
    }

    public SourceDescription attribution(Attribution attribution) {
        this.setAttribution(attribution);
        return this;
    }

    public void accept(GedcomxModelVisitor visitor) {
        visitor.visitSourceDescription(this);
    }

    @XmlTransient
    @com.fasterxml.jackson.annotation.JsonIgnore
    @JsonIgnore
    public URI getPersistentId() {
        URI identifier = null;
        if (this.identifiers != null) {
            for (Identifier id : this.identifiers) {
                if (!IdentifierType.Persistent.equals(id.getKnownType())) continue;
                identifier = id.getValue();
                break;
            }
        }
        return identifier;
    }

    @com.fasterxml.jackson.annotation.JsonIgnore
    @JsonIgnore
    public void setPersistentId(URI persistentId) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        Iterator<Identifier> it = this.identifiers.iterator();
        while (it.hasNext()) {
            if (!IdentifierType.Persistent.equals(it.next().getKnownType())) continue;
            it.remove();
        }
        Identifier identifier = new Identifier();
        identifier.setKnownType(IdentifierType.Persistent);
        identifier.setValue(persistentId);
        this.identifiers.add(identifier);
    }

    public URI getReplacedBy() {
        return this.replacedBy;
    }

    public void setReplacedBy(URI replacedBy) {
        this.replacedBy = replacedBy;
    }

    @XmlElement(name="replaces")
    @JsonProperty(value="replaces")
    @org.codehaus.jackson.annotate.JsonProperty(value="replaces")
    public List<URI> getReplaces() {
        return this.replaces;
    }

    @JsonProperty(value="replaces")
    @org.codehaus.jackson.annotate.JsonProperty(value="replaces")
    public void setReplaces(List<URI> replaces) {
        this.replaces = replaces;
    }

    @XmlElement(name="status")
    @JsonProperty(value="statuses")
    @org.codehaus.jackson.annotate.JsonProperty(value="statuses")
    public List<URI> getStatuses() {
        return this.statuses;
    }

    @JsonProperty(value="statuses")
    @org.codehaus.jackson.annotate.JsonProperty(value="statuses")
    public void setStatuses(List<URI> statuses) {
        this.statuses = statuses;
    }

    public void addKnownStatus(ResourceStatusType status) {
        if (status != null) {
            this.addStatus(status.toQNameURI());
        }
    }

    public void addStatus(URI status) {
        if (status != null) {
            if (this.statuses == null) {
                this.statuses = new ArrayList<URI>();
            }
            if (!this.statuses.contains(status)) {
                this.statuses.add(status);
            }
        }
    }

    @XmlElement(name="identifier")
    @JsonProperty(value="identifiers")
    @org.codehaus.jackson.annotate.JsonProperty(value="identifiers")
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    @JsonProperty(value="identifiers")
    @org.codehaus.jackson.annotate.JsonProperty(value="identifiers")
    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    public SourceDescription identifier(Identifier identifier) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.add(identifier);
        return this;
    }

    @Facet(value="http://record.gedcomx.org/")
    @XmlAttribute
    public String getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    public SourceDescription sortKey(String sortKey) {
        this.setSortKey(sortKey);
        return this;
    }

    @XmlElement(name="description")
    @JsonProperty(value="descriptions")
    @org.codehaus.jackson.annotate.JsonProperty(value="descriptions")
    @Facet(value="http://record.gedcomx.org/")
    public List<TextValue> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<TextValue> descriptions) {
        this.descriptions = descriptions;
    }

    public SourceDescription description(TextValue description) {
        if (this.descriptions == null) {
            this.descriptions = new ArrayList<TextValue>();
        }
        this.descriptions.add(description);
        return this;
    }

    public SourceDescription description(String description) {
        return this.description(new TextValue(description));
    }

    @Facet(value="http://record.gedcomx.org/")
    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public SourceDescription created(Date created) {
        this.setCreated(created);
        return this;
    }

    @Facet(value="http://record.gedcomx.org/")
    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public SourceDescription modified(Date modified) {
        this.setModified(modified);
        return this;
    }

    @Facet(value="http://record.gedcomx.org/")
    public List<Coverage> getCoverage() {
        return this.coverage;
    }

    public void setCoverage(List<Coverage> coverage) {
        this.coverage = coverage;
    }

    public SourceDescription coverage(Coverage coverage) {
        if (this.coverage == null) {
            this.coverage = new ArrayList<Coverage>();
        }
        this.coverage.add(coverage);
        return this;
    }

    @Override
    @XmlElement(name="field")
    @JsonProperty(value="fields")
    @org.codehaus.jackson.annotate.JsonProperty(value="fields")
    @Facet(value="http://record.gedcomx.org/")
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    @JsonProperty(value="fields")
    @org.codehaus.jackson.annotate.JsonProperty(value="fields")
    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public SourceDescription field(Field field) {
        this.addField(field);
        return this;
    }

    public void addField(Field field) {
        if (field != null) {
            if (this.fields == null) {
                this.fields = new LinkedList<Field>();
            }
            this.fields.add(field);
        }
    }

    @Facet(value="http://record.gedcomx.org/")
    public ResourceReference getRepository() {
        return this.repository;
    }

    public void setRepository(ResourceReference repository) {
        this.repository = repository;
    }

    public SourceDescription repository(Agent repository) {
        return this.repository(new ResourceReference(URI.create("#" + repository.getId())));
    }

    public SourceDescription repository(ResourceReference repository) {
        this.setRepository(repository);
        return this;
    }

    @XmlElement(name="descriptor")
    @JsonProperty(value="descriptor")
    @org.codehaus.jackson.annotate.JsonProperty(value="descriptor")
    @Facet(value="http://record.gedcomx.org/")
    public ResourceReference getDescriptorRef() {
        return this.descriptorRef;
    }

    @JsonProperty(value="descriptor")
    @org.codehaus.jackson.annotate.JsonProperty(value="descriptor")
    public void setDescriptorRef(ResourceReference descriptorRef) {
        this.descriptorRef = descriptorRef;
    }

    public SourceDescription descriptorRef(ResourceReference descriptorRef) {
        this.setDescriptorRef(descriptorRef);
        return this;
    }

    @XmlAttribute
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public SourceDescription version(String version) {
        this.setVersion(version);
        return this;
    }

    public void embed(SourceDescription description) {
        if (description.citations != null) {
            this.citations = this.citations == null ? new ArrayList() : this.citations;
            this.citations.addAll(description.citations);
        }
        this.mediaType = this.mediaType == null ? description.mediaType : this.mediaType;
        this.about = this.about == null ? description.about : this.about;
        ResourceReference resourceReference = this.mediator = this.mediator == null ? description.mediator : this.mediator;
        if (description.sources != null) {
            this.sources = this.sources == null ? new ArrayList() : this.sources;
            this.sources.addAll(description.sources);
        }
        this.analysis = this.analysis == null ? description.analysis : this.analysis;
        SourceReference sourceReference = this.componentOf = this.componentOf == null ? description.componentOf : this.componentOf;
        if (description.titles != null) {
            this.titles = this.titles == null ? new ArrayList() : this.titles;
            this.titles.addAll(description.titles);
        }
        if (description.notes != null) {
            this.notes = this.notes == null ? new ArrayList() : this.notes;
            this.notes.addAll(description.notes);
        }
        this.attribution = this.attribution == null ? description.attribution : this.attribution;
        this.resourceType = this.resourceType == null ? description.resourceType : this.resourceType;
        String string = this.sortKey = this.sortKey == null ? description.sortKey : this.sortKey;
        if (description.descriptions != null) {
            this.descriptions = this.descriptions == null ? new ArrayList() : this.descriptions;
            this.descriptions.addAll(description.descriptions);
        }
        if (description.rights != null) {
            this.rights = this.rights == null ? new ArrayList() : this.rights;
            this.rights.addAll(description.rights);
        }
        if (description.identifiers != null) {
            this.identifiers = this.identifiers == null ? new ArrayList() : this.identifiers;
            this.identifiers.addAll(description.identifiers);
        }
        this.created = this.created == null ? description.created : this.created;
        this.modified = this.modified == null ? description.modified : this.modified;
        Date date = this.modified = this.modified == null ? description.modified : this.modified;
        if (description.coverage != null) {
            this.coverage = this.coverage == null ? new ArrayList() : this.coverage;
            this.coverage.addAll(description.coverage);
        }
        if (description.fields != null) {
            this.fields = this.fields == null ? new ArrayList() : this.fields;
            this.fields.addAll(description.fields);
        }
        this.repository = this.repository == null ? description.repository : this.repository;
        this.descriptorRef = this.descriptorRef == null ? description.descriptorRef : this.descriptorRef;
        super.embed(description);
    }

    @Override
    public String toString() {
        return this.getId() + ": " + this.resourceType;
    }
}

