/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.source;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.gedcomx.common.Attributable;
import org.gedcomx.common.Attribution;
import org.gedcomx.common.Qualifier;
import org.gedcomx.common.URI;
import org.gedcomx.links.HypermediaEnabledData;
import org.gedcomx.links.Link;
import org.gedcomx.rt.GedcomxModelVisitor;
import org.gedcomx.rt.json.JsonElementWrapper;
import org.gedcomx.source.SourceDescription;

@XmlRootElement(name="sourceReference")
@JsonElementWrapper(name="sourceReferences")
@XmlType(name="SourceReference")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SourceReference
extends HypermediaEnabledData
implements Attributable {
    private URI descriptionRef;
    private String descriptionId;
    private Attribution attribution;
    private List<Qualifier> qualifiers;

    @Override
    public SourceReference id(String id) {
        return (SourceReference)super.id(id);
    }

    @Override
    public SourceReference extensionElement(Object element) {
        return (SourceReference)super.extensionElement(element);
    }

    @Override
    public SourceReference link(Link link) {
        return (SourceReference)super.link(link);
    }

    @Override
    public SourceReference link(String rel, URI href) {
        return (SourceReference)super.link(rel, href);
    }

    @Override
    public Attribution getAttribution() {
        return this.attribution;
    }

    @Override
    public void setAttribution(Attribution attribution) {
        this.attribution = attribution;
    }

    public SourceReference attribution(Attribution attribution) {
        this.setAttribution(attribution);
        return this;
    }

    @XmlAttribute(name="description")
    @JsonProperty(value="description")
    @org.codehaus.jackson.annotate.JsonProperty(value="description")
    public URI getDescriptionRef() {
        return this.descriptionRef;
    }

    @JsonProperty(value="description")
    @org.codehaus.jackson.annotate.JsonProperty(value="description")
    public void setDescriptionRef(URI descriptionRef) {
        this.descriptionRef = descriptionRef;
    }

    public SourceReference descriptionRef(URI descriptionRef) {
        this.setDescriptionRef(descriptionRef);
        return this;
    }

    @XmlAttribute(name="descriptionId")
    @JsonProperty(value="descriptionId")
    @org.codehaus.jackson.annotate.JsonProperty(value="descriptionId")
    public String getDescriptionId() {
        return this.descriptionId;
    }

    @JsonProperty(value="descriptionId")
    @org.codehaus.jackson.annotate.JsonProperty(value="descriptionId")
    public void setDescriptionId(String descriptionId) {
        this.descriptionId = descriptionId;
    }

    public SourceReference descriptionId(String descriptionId) {
        this.setDescriptionId(descriptionId);
        return this;
    }

    public SourceReference description(SourceDescription description) {
        if (description.getId() == null) {
            throw new IllegalArgumentException("Cannot reference description: no id.");
        }
        return this.descriptionRef(URI.create("#" + description.getId())).descriptionId(description.getId());
    }

    @XmlElement(name="qualifier")
    @JsonProperty(value="qualifiers")
    @org.codehaus.jackson.annotate.JsonProperty(value="qualifiers")
    public List<Qualifier> getQualifiers() {
        return this.qualifiers;
    }

    @JsonProperty(value="qualifiers")
    @org.codehaus.jackson.annotate.JsonProperty(value="qualifiers")
    public void setQualifiers(List<Qualifier> qualifiers) {
        this.qualifiers = qualifiers;
    }

    public SourceReference qualifier(Qualifier qualifier) {
        this.addQualifier(qualifier);
        return this;
    }

    public void addQualifier(Qualifier qualifier) {
        if (this.qualifiers == null) {
            this.qualifiers = new ArrayList<Qualifier>();
        }
        this.qualifiers.add(qualifier);
    }

    public void accept(GedcomxModelVisitor visitor) {
        visitor.visitSourceReference(this);
    }
}

