/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.gedcomx.common.HasTransientProperties;
import org.gedcomx.rt.SupportsExtensionElements;

@XmlType(name="ExtensibleData")
public abstract class ExtensibleData
implements SupportsExtensionElements,
HasTransientProperties {
    private String id;
    protected List<Object> extensionElements;
    protected final Map<String, Object> transientProperties = new TreeMap<String, Object>();

    @XmlAttribute
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ExtensibleData id(String id) {
        this.id = id;
        return this;
    }

    @XmlAnyElement(lax=true)
    @JsonIgnore
    public List<Object> getExtensionElements() {
        return this.extensionElements;
    }

    @JsonIgnore
    public void setExtensionElements(List<Object> extensionElements) {
        this.extensionElements = extensionElements;
    }

    public void addExtensionElement(Object element) {
        if (this.extensionElements == null) {
            this.extensionElements = new ArrayList<Object>();
        }
        this.extensionElements.add(element);
    }

    public ExtensibleData extensionElement(Object element) {
        this.addExtensionElement(element);
        return this;
    }

    public <E> List<E> removeExtensionElements(Class<E> clazz) {
        ArrayList<Object> removed = new ArrayList<Object>();
        if (this.extensionElements != null) {
            Iterator<Object> elements = this.extensionElements.iterator();
            while (elements.hasNext()) {
                Object next = elements.next();
                if (!clazz.isInstance(next)) continue;
                removed.add(next);
                elements.remove();
            }
        }
        return removed;
    }

    public void setExtensionElement(Object element) {
        this.removeExtensionElements(element.getClass());
        this.addExtensionElement(element);
    }

    public <E> E findExtensionOfType(Class<E> clazz) {
        List<E> candidates = this.findExtensionsOfType(clazz);
        if (candidates.size() > 0) {
            return candidates.get(0);
        }
        return null;
    }

    public <E> List<E> findExtensionsOfType(Class<E> clazz) {
        ArrayList<Object> ext = new ArrayList<Object>();
        if (this.extensionElements != null) {
            for (Object extension : this.extensionElements) {
                if (!clazz.isInstance(extension)) continue;
                ext.add(extension);
            }
        }
        return ext;
    }

    public <E> E findExtensionOfType(Class<E> clazz, String name, String namespace) {
        List<E> candidates = this.findExtensionsOfType(clazz, name, namespace);
        if (candidates.size() > 0) {
            return candidates.get(0);
        }
        return null;
    }

    public <E> List<E> findExtensionsOfType(Class<E> clazz, String name, String namespace) {
        ArrayList<Object> ext = new ArrayList<Object>();
        if (this.extensionElements != null) {
            for (Object extension : this.extensionElements) {
                JAXBElement element;
                if (!JAXBElement.class.isInstance(extension) || !clazz.isInstance((element = (JAXBElement)extension).getValue()) || !element.getName().getLocalPart().equals(name) || !element.getName().getNamespaceURI().equals(namespace)) continue;
                ext.add(element.getValue());
            }
        }
        return ext;
    }

    @Override
    @JsonIgnore
    @XmlTransient
    public Map<String, Object> getTransientProperties() {
        return Collections.unmodifiableMap(this.transientProperties);
    }

    @Override
    public Object getTransientProperty(String name) {
        return this.transientProperties.get(name);
    }

    @Override
    public void setTransientProperty(String name, Object value) {
        this.transientProperties.put(name, value);
    }

    protected void embed(ExtensibleData data) {
        if (data.extensionElements != null) {
            this.extensionElements = this.extensionElements == null ? new ArrayList() : this.extensionElements;
            this.extensionElements.addAll(data.extensionElements);
        }
    }

    public String toString() {
        return "id: " + this.id;
    }
}

